/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins.bootablejar.maven.goals;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.wildfly.core.launcher.CommandBuilder;
import org.wildfly.core.launcher.Launcher;
import org.wildfly.core.launcher.StandaloneCommandBuilder;
import org.wildfly.plugins.bootablejar.maven.common.Utils;

public class ServerModeConfig {
    private static final String SERVER_DIRECTORY_NAME = "wildfly.bootable.server.directory.name";
    private static final String SERVER_LAUNCH_SCRIPT = "wildfly.bootable.server.launch.script";
    private static final String DEFAULT_DIRECTORY_NAME = "server";
    private String directoryName;
    private String launchScript;
    private boolean enabled = true;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setDirectoryName(String directoryName) {
        this.directoryName = directoryName;
    }

    public String getDirectoryName() {
        String name = System.getProperty(SERVER_DIRECTORY_NAME);
        if (name == null) {
            name = this.directoryName == null ? DEFAULT_DIRECTORY_NAME : this.directoryName;
        }
        return name;
    }

    public void setLaunchScript(String launchScript) {
        this.launchScript = launchScript;
    }

    public String getLaunchScript() {
        String name = System.getProperty(SERVER_LAUNCH_SCRIPT);
        if (name == null) {
            name = this.launchScript;
        }
        return name;
    }

    public Launcher createServerLauncher(MavenProject project, List<String> jvmArguments, List<String> arguments, boolean redirect, String goal) throws MojoExecutionException {
        String script = this.getLaunchScript();
        Path jbossHome = Paths.get(Utils.getWildFlyPath(this.getDirectoryName(), project, goal), new String[0]);
        if (script == null) {
            StandaloneCommandBuilder builder = (StandaloneCommandBuilder)StandaloneCommandBuilder.of((Path)jbossHome).addJavaOptions(jvmArguments).addServerArguments(arguments);
            if (redirect) {
                builder.addJavaOption("-Dorg.jboss.logmanager.nocolor=true");
            }
            return Launcher.of((CommandBuilder)builder);
        }
        LauncherCommandBuilder launchBuilder = new LauncherCommandBuilder(Utils.getWildFlyLauncherPath(this.getDirectoryName(), project, script, goal));
        launchBuilder.addServerArguments(arguments);
        ArrayList<String> jvmArgs = new ArrayList<String>();
        jvmArgs.addAll(jvmArguments);
        if (redirect) {
            jvmArgs.add("-Dorg.jboss.logmanager.nocolor=true");
        }
        return Launcher.of((CommandBuilder)launchBuilder).addEnvironmentVariable("JBOSS_HOME", jbossHome.toString()).addEnvironmentVariable("JAVA_OPTS", String.join((CharSequence)" ", jvmArgs));
    }

    static class LauncherCommandBuilder
    implements CommandBuilder {
        private final Path script;
        private final List<String> serverArguments = new ArrayList<String>();

        LauncherCommandBuilder(Path script) {
            this.script = script;
        }

        void addServerArguments(List<String> serverArguments) {
            this.serverArguments.addAll(serverArguments);
        }

        public List<String> buildArguments() {
            return Collections.emptyList();
        }

        public List<String> build() {
            ArrayList<String> lst = new ArrayList<String>();
            lst.add(this.script.toString());
            lst.addAll(this.serverArguments);
            return lst;
        }
    }
}

