/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.deployment.domain;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.domain.DeploymentActionResult;
import org.jboss.as.controller.client.helpers.domain.DeploymentActionsCompleteBuilder;
import org.jboss.as.controller.client.helpers.domain.DeploymentPlan;
import org.jboss.as.controller.client.helpers.domain.DeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.domain.DeploymentPlanResult;
import org.jboss.as.controller.client.helpers.domain.DomainClient;
import org.jboss.as.controller.client.helpers.domain.DomainDeploymentManager;
import org.jboss.as.controller.client.helpers.domain.DuplicateDeploymentNameException;
import org.jboss.as.controller.client.helpers.domain.InitialDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.domain.RemoveDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.domain.ServerGroupDeploymentActionResult;
import org.jboss.as.controller.client.helpers.domain.ServerGroupDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.domain.ServerIdentity;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.as.controller.client.helpers.domain.ServerUpdateResult;
import org.wildfly.plugin.common.DeploymentExecutionException;
import org.wildfly.plugin.common.DeploymentFailureException;
import org.wildfly.plugin.common.DeploymentInspector;
import org.wildfly.plugin.deployment.Deployment;
import org.wildfly.plugin.deployment.MatchPatternStrategy;
import org.wildfly.plugin.deployment.domain.Domain;

class DomainDeployment
implements Deployment {
    private final File content;
    private final DomainClient client;
    private final Domain domain;
    private final String name;
    private final String runtimeName;
    private final Deployment.Type type;
    private final String matchPattern;
    private final MatchPatternStrategy matchPatternStrategy;
    private InputStream contentStream;

    DomainDeployment(DomainClient client, Domain domain, File content, String name, String runtimeName, Deployment.Type type, String matchPattern, MatchPatternStrategy matchPatternStrategy) {
        this.content = content;
        this.client = client;
        this.domain = domain;
        this.name = name == null ? content.getName() : name;
        this.runtimeName = runtimeName == null ? this.name : runtimeName;
        this.type = type;
        this.matchPattern = matchPattern;
        this.matchPatternStrategy = matchPatternStrategy;
    }

    private DeploymentPlan createPlan(DeploymentPlanBuilder builder) throws IOException, DuplicateDeploymentNameException, DeploymentFailureException {
        DeploymentActionsCompleteBuilder completeBuilder = null;
        List<String> existingDeployments = DeploymentInspector.getDeployments((ModelControllerClient)this.client, this.name, this.matchPattern);
        switch (this.type) {
            case DEPLOY: {
                this.contentStream = Files.newInputStream(this.content.toPath(), new OpenOption[0]);
                completeBuilder = builder.add(this.name, this.runtimeName, this.contentStream).andDeploy();
                break;
            }
            case FORCE_DEPLOY: {
                this.contentStream = Files.newInputStream(this.content.toPath(), new OpenOption[0]);
                if (existingDeployments.contains(this.name)) {
                    completeBuilder = builder.replace(this.name, this.runtimeName, this.contentStream);
                    break;
                }
                completeBuilder = builder.add(this.name, this.runtimeName, this.contentStream).andDeploy();
                break;
            }
            case REDEPLOY: {
                this.contentStream = Files.newInputStream(this.content.toPath(), new OpenOption[0]);
                completeBuilder = builder.replace(this.name, this.runtimeName, this.contentStream);
                break;
            }
            case UNDEPLOY: {
                this.validateExistingDeployments(existingDeployments);
                completeBuilder = this.undeployAndRemoveUndeployed(builder, existingDeployments);
                break;
            }
            case UNDEPLOY_IGNORE_MISSING: {
                this.validateExistingDeployments(existingDeployments);
                if (!existingDeployments.isEmpty()) {
                    completeBuilder = this.undeployAndRemoveUndeployed(builder, existingDeployments);
                    break;
                }
                return null;
            }
        }
        if (completeBuilder != null) {
            ServerGroupDeploymentPlanBuilder groupDeploymentBuilder = null;
            for (String serverGroupName : this.domain.getServerGroups()) {
                groupDeploymentBuilder = groupDeploymentBuilder == null ? completeBuilder.toServerGroup(serverGroupName) : groupDeploymentBuilder.toServerGroup(serverGroupName);
            }
            if (groupDeploymentBuilder == null) {
                throw new DeploymentFailureException("No server groups were defined for the deployment.");
            }
            return groupDeploymentBuilder.withRollback().build();
        }
        throw new IllegalStateException(String.format("Invalid type '%s' for deployment", new Object[]{this.type}));
    }

    private DeploymentActionsCompleteBuilder undeployAndRemoveUndeployed(DeploymentPlanBuilder builder, Iterable<String> deploymentNames) {
        RemoveDeploymentPlanBuilder completeBuilder = null;
        for (String deploymentName : deploymentNames) {
            DeploymentPlanBuilder b = completeBuilder == null ? builder : completeBuilder;
            completeBuilder = b.undeploy(deploymentName).andRemoveUndeployed();
            if (this.matchPatternStrategy != MatchPatternStrategy.FIRST) continue;
            break;
        }
        return completeBuilder;
    }

    private void validateExistingDeployments(List<String> existingDeployments) throws DeploymentFailureException {
        if (this.matchPattern == null) {
            return;
        }
        if (this.matchPatternStrategy == MatchPatternStrategy.FAIL && existingDeployments.size() > 1) {
            throw new DeploymentFailureException(String.format("Deployment failed, found %d deployed artifacts for pattern '%s' (%s)", existingDeployments.size(), this.matchPattern, existingDeployments));
        }
    }

    @Override
    public Deployment.Status execute() throws DeploymentExecutionException, DeploymentFailureException {
        try {
            this.validate();
            DomainDeploymentManager manager = this.client.getDeploymentManager();
            InitialDeploymentPlanBuilder builder = manager.newDeploymentPlan();
            DeploymentPlan plan = this.createPlan((DeploymentPlanBuilder)builder);
            if (plan != null) {
                this.executePlan(manager, plan);
            }
        }
        catch (DeploymentExecutionException | DeploymentFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentExecutionException(e, "Error executing %s", new Object[]{this.type});
        }
        finally {
            DomainDeployment.safeClose(this.contentStream);
        }
        return Deployment.Status.SUCCESS;
    }

    void validate() throws DeploymentFailureException {
        Map statuses = this.client.getServerStatuses();
        List<String> serverGroups = this.domain.getServerGroups();
        for (String serverGroup : serverGroups) {
            boolean notFound = true;
            for (ServerIdentity serverId : statuses.keySet()) {
                if (!serverGroup.equals(serverId.getServerGroupName())) continue;
                ServerStatus currentStatus = (ServerStatus)statuses.get(serverId);
                if (currentStatus != ServerStatus.STARTED) {
                    throw new DeploymentFailureException("Status of server group '%s' is '%s', but is required to be '%s'.", serverGroup, currentStatus, ServerStatus.STARTED);
                }
                notFound = false;
                break;
            }
            if (!notFound) continue;
            throw new DeploymentFailureException("Server group '%s' does not exist on the server.", serverGroup);
        }
    }

    @Override
    public Deployment.Type getType() {
        return this.type;
    }

    private void executePlan(DomainDeploymentManager manager, DeploymentPlan plan) throws DeploymentExecutionException, ExecutionException, InterruptedException {
        if (!plan.getDeploymentActions().isEmpty()) {
            DeploymentPlanResult planResult = (DeploymentPlanResult)manager.execute(plan).get();
            Map actionResults = planResult.getDeploymentActionResults();
            for (UUID uuid : actionResults.keySet()) {
                Map groupDeploymentActionResults = ((DeploymentActionResult)actionResults.get(uuid)).getResultsByServerGroup();
                for (String serverGroup2 : groupDeploymentActionResults.keySet()) {
                    Map serverUpdateResults = ((ServerGroupDeploymentActionResult)groupDeploymentActionResults.get(serverGroup2)).getResultByServer();
                    for (String server : serverUpdateResults.keySet()) {
                        Throwable t = ((ServerUpdateResult)serverUpdateResults.get(server)).getFailureResult();
                        if (t == null) continue;
                        throw new DeploymentExecutionException(t, "Error executing %s", new Object[]{this.type});
                    }
                }
            }
        }
    }

    private static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

