/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.server;

import java.io.File;
import org.apache.maven.project.MavenProject;
import org.wildfly.plugin.server.RuntimeVersions;

public interface ArtifactResolver {
    public File resolve(MavenProject var1, String var2);

    public static class ArtifactNameSplitter {
        private final String artifact;
        private String groupId;
        private String artifactId;
        private String classifier;
        private String packaging;
        private String version;

        public ArtifactNameSplitter(String artifact) {
            this.artifact = artifact;
        }

        public static ArtifactNameSplitter of(String artifact) {
            return new ArtifactNameSplitter(artifact);
        }

        public String getGroupId() {
            return this.groupId;
        }

        public ArtifactNameSplitter setGroupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public ArtifactNameSplitter setArtifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public String getClassifier() {
            return this.classifier;
        }

        public ArtifactNameSplitter setClassifier(String classifier) {
            this.classifier = classifier;
            return this;
        }

        public String getPackaging() {
            return this.packaging;
        }

        public ArtifactNameSplitter setPackaging(String packaging) {
            this.packaging = packaging;
            return this;
        }

        public String getVersion() {
            return this.version;
        }

        public ArtifactNameSplitter setVersion(String version) {
            this.version = version;
            return this;
        }

        public ArtifactNameSplitter split() {
            if (this.artifact != null) {
                String[] artifactSegments = this.artifact.split(":");
                if (artifactSegments.length == 0) {
                    throw new IllegalArgumentException(String.format("Invalid artifact pattern: %s", this.artifact));
                }
                switch (artifactSegments.length) {
                    case 5: {
                        String value = artifactSegments[4].trim();
                        if (!value.isEmpty()) {
                            this.classifier = value;
                        }
                    }
                    case 4: {
                        String value = artifactSegments[3].trim();
                        if (!value.isEmpty()) {
                            this.packaging = value;
                        }
                    }
                    case 3: {
                        String value = artifactSegments[2].trim();
                        if (!value.isEmpty()) {
                            this.version = value;
                        }
                    }
                    case 2: {
                        String value = artifactSegments[1].trim();
                        if (!value.isEmpty()) {
                            this.artifactId = value;
                        }
                    }
                    case 1: {
                        String value = artifactSegments[0].trim();
                        if (value.isEmpty()) break;
                        this.groupId = value;
                    }
                }
            }
            return this;
        }

        public String asString() {
            this.split();
            if (this.version == null) {
                this.version = RuntimeVersions.getLatestFinal(this.groupId, this.artifactId);
            }
            if (this.groupId == null || this.artifactId == null || this.version == null) {
                throw new IllegalStateException("The groupId, artifactId and version parameters are required");
            }
            StringBuilder result = new StringBuilder();
            result.append(this.groupId).append(':').append(this.artifactId).append(':').append(this.version).append(':');
            if (this.packaging != null) {
                result.append(this.packaging);
            }
            result.append(':');
            if (this.classifier != null) {
                result.append(this.classifier);
            }
            return result.toString();
        }
    }
}

