/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.server;

import java.io.File;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.wildfly.plugin.server.ArtifactResolver;

@Named
class EclipseAetherArtifactResolver
implements ArtifactResolver {
    @Inject
    private RepositorySystem repoSystem;

    EclipseAetherArtifactResolver() {
    }

    @Override
    public File resolve(MavenProject project, String artifact) {
        ArtifactResult result;
        try {
            ProjectBuildingRequest projectBuildingRequest = project.getProjectBuildingRequest();
            ArtifactRequest request = new ArtifactRequest();
            ArtifactResolver.ArtifactNameSplitter splitter = ArtifactResolver.ArtifactNameSplitter.of(artifact).split();
            DefaultArtifact defaultArtifact = new DefaultArtifact(splitter.getGroupId(), splitter.getArtifactId(), splitter.getClassifier(), splitter.getPackaging(), splitter.getVersion());
            request.setArtifact((Artifact)defaultArtifact);
            List repos = project.getRemoteProjectRepositories();
            request.setRepositories(repos);
            result = this.repoSystem.resolveArtifact(projectBuildingRequest.getRepositorySession(), request);
        }
        catch (ArtifactResolutionException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return result.getArtifact().getFile();
    }
}

