/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.cli;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.jboss.as.controller.client.ModelControllerClient;
import org.wildfly.plugin.common.MavenModelControllerClientConfiguration;

public class CommandConfiguration {
    private final Collection<String> jvmOptions;
    private final Collection<String> commands;
    private final Map<String, String> systemProperties;
    private final Collection<Path> propertiesFiles;
    private final Collection<Path> scripts;
    private final Supplier<ModelControllerClient> client;
    private final Supplier<MavenModelControllerClientConfiguration> clientConfiguration;
    private boolean batch;
    private boolean failOnError;
    private boolean fork;
    private Path jbossHome;
    private boolean offline;
    private String stdout;
    private int timeout;

    private CommandConfiguration(Supplier<ModelControllerClient> client, Supplier<MavenModelControllerClientConfiguration> clientConfiguration) {
        this.client = client;
        this.clientConfiguration = clientConfiguration;
        this.jvmOptions = new ArrayList<String>();
        this.commands = new ArrayList<String>();
        this.systemProperties = new LinkedHashMap<String, String>();
        this.propertiesFiles = new ArrayList<Path>();
        this.scripts = new ArrayList<Path>();
        this.failOnError = true;
    }

    public static CommandConfiguration of(Supplier<ModelControllerClient> clientSupplier, Supplier<MavenModelControllerClientConfiguration> clientConfigurationSupplier) {
        return new CommandConfiguration(clientSupplier, clientConfigurationSupplier);
    }

    public boolean isBatch() {
        return this.batch;
    }

    public CommandConfiguration setBatch(boolean batch) {
        this.batch = batch;
        return this;
    }

    public ModelControllerClient getClient() {
        return this.client.get();
    }

    public MavenModelControllerClientConfiguration getClientConfiguration() {
        return this.clientConfiguration.get();
    }

    public Path getJBossHome() {
        return this.jbossHome;
    }

    public CommandConfiguration setJBossHome(String jbossHome) {
        this.jbossHome = jbossHome == null ? null : Paths.get(jbossHome, new String[0]);
        return this;
    }

    public CommandConfiguration setJBossHome(Path jbossHome) {
        this.jbossHome = jbossHome;
        return this;
    }

    public Collection<String> getJvmOptions() {
        return Collections.unmodifiableCollection(this.jvmOptions);
    }

    public CommandConfiguration addJvmOptions(String ... jvmOptions) {
        if (jvmOptions != null) {
            Collections.addAll(this.jvmOptions, jvmOptions);
        }
        return this;
    }

    public Map<String, String> getSystemProperties() {
        return Collections.unmodifiableMap(this.systemProperties);
    }

    public CommandConfiguration addSystemProperties(Map<String, String> systemProperties) {
        if (systemProperties != null) {
            this.systemProperties.putAll(systemProperties);
        }
        return this;
    }

    public Collection<Path> getPropertiesFiles() {
        return Collections.unmodifiableCollection(this.propertiesFiles);
    }

    public CommandConfiguration addPropertiesFiles(Collection<File> propertiesFiles) {
        propertiesFiles.forEach(f -> this.propertiesFiles.add(f.toPath()));
        return this;
    }

    public Collection<String> getCommands() {
        return Collections.unmodifiableCollection(this.commands);
    }

    public CommandConfiguration addCommands(Collection<String> commands) {
        if (commands != null) {
            this.commands.addAll(commands);
        }
        return this;
    }

    public Collection<Path> getScripts() {
        return Collections.unmodifiableCollection(this.scripts);
    }

    public CommandConfiguration addScripts(Collection<File> scripts) {
        scripts.forEach(f -> this.scripts.add(f.toPath()));
        return this;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public CommandConfiguration setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
        return this;
    }

    public boolean isFork() {
        return this.fork;
    }

    public CommandConfiguration setFork(boolean fork) {
        this.fork = fork;
        return this;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public CommandConfiguration setOffline(boolean offline) {
        this.offline = offline;
        return this;
    }

    public String getStdout() {
        return this.stdout;
    }

    public CommandConfiguration setStdout(String stdout) {
        this.stdout = stdout;
        return this;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public CommandConfiguration setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }
}

