/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.cli;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.wildfly.core.launcher.CliCommandBuilder;
import org.wildfly.plugin.cli.AbstractCommandExecutor;
import org.wildfly.plugin.cli.CommandConfiguration;
import org.wildfly.plugin.cli.LocalCLIExecutor;
import org.wildfly.plugin.common.MavenModelControllerClientConfiguration;
import org.wildfly.plugin.common.StandardOutput;
import org.wildfly.plugin.core.ServerHelper;

@Singleton
@Named
public class CommandExecutor
extends AbstractCommandExecutor<CommandConfiguration> {
    @Override
    public void execute(CommandConfiguration config, MavenRepoManager artifactResolver) throws MojoFailureException, MojoExecutionException {
        if (config.isOffline()) {
            if (!ServerHelper.isValidHomeDirectory((Path)config.getJBossHome())) {
                throw new MojoFailureException("Invalid JBoss Home directory is not valid: " + config.getJBossHome());
            }
            this.executeInNewProcess(config);
        } else if (config.isFork()) {
            this.executeInNewProcess(config);
        } else {
            try {
                this.executeInProcess(config, artifactResolver);
            }
            catch (Exception ex) {
                throw new MojoExecutionException(ex.getLocalizedMessage(), ex);
            }
        }
    }

    @Override
    protected int executeInNewProcess(CommandConfiguration config, Path scriptFile, StandardOutput stdout) throws MojoExecutionException, IOException {
        try (MavenModelControllerClientConfiguration clientConfiguration = config.getClientConfiguration();){
            CliCommandBuilder builder = this.createCommandBuilder(config, scriptFile);
            if (!config.isOffline()) {
                builder.setConnection(clientConfiguration.getController());
            }
            if (clientConfiguration != null && clientConfiguration.getAuthenticationConfigUri() != null) {
                builder.addJavaOption("-Dwildfly.config.url=" + clientConfiguration.getAuthenticationConfigUri().toString());
            }
            int n = this.launchProcess(builder, config, stdout);
            return n;
        }
    }

    private void executeInProcess(CommandConfiguration config, MavenRepoManager artifactResolver) throws Exception {
        Path jbossHome = config.getJBossHome();
        if (jbossHome != null && !ServerHelper.isValidHomeDirectory((Path)jbossHome)) {
            throw new MojoFailureException("Invalid JBoss Home directory is not valid: " + jbossHome);
        }
        Properties currentSystemProperties = System.getProperties();
        try {
            this.getLogger().debug("Executing commands");
            Properties newSystemProperties = new Properties(currentSystemProperties);
            if (jbossHome != null) {
                newSystemProperties.setProperty("jboss.home", jbossHome.toString());
                newSystemProperties.setProperty("jboss.home.dir", jbossHome.toString());
            }
            for (Path file : config.getPropertiesFiles()) {
                CommandExecutor.parseProperties(file, newSystemProperties);
            }
            newSystemProperties.putAll(config.getSystemProperties());
            System.setProperties(newSystemProperties);
            try (LocalCLIExecutor commandContext = null;
                 ModelControllerClient client = config.getClient();){
                Collection<Path> scripts;
                commandContext = this.createCommandContext(jbossHome, config.isExpressionResolved(), client, artifactResolver);
                Collection<String> commands = config.getCommands();
                if (!commands.isEmpty()) {
                    if (config.isBatch()) {
                        commandContext.executeBatch(commands);
                    } else {
                        commandContext.executeCommands(commands, config.isFailOnError());
                    }
                }
                if (!(scripts = config.getScripts()).isEmpty()) {
                    for (Path scriptFile : scripts) {
                        List<String> cmds = Files.readAllLines(scriptFile, StandardCharsets.UTF_8);
                        if (config.isBatch()) {
                            commandContext.executeBatch(cmds);
                            continue;
                        }
                        commandContext.executeCommands(cmds, config.isFailOnError());
                    }
                }
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to parse properties.", (Throwable)e);
        }
        finally {
            System.setProperties(currentSystemProperties);
        }
    }

    private LocalCLIExecutor createCommandContext(Path jbossHome, boolean resolveExpression, ModelControllerClient client, MavenRepoManager artifactResolver) throws Exception {
        LocalCLIExecutor commandContext = null;
        try {
            commandContext = new LocalCLIExecutor(jbossHome, resolveExpression, artifactResolver);
            commandContext.bindClient(client);
        }
        catch (Exception e) {
            if (commandContext != null) {
                commandContext.close();
            }
            throw new IllegalStateException("Failed to initialize CLI context", e);
        }
        return commandContext;
    }
}

