/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.provision;

import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import org.wildfly.glow.Arguments;
import org.wildfly.glow.OutputFormat;
import org.wildfly.glow.ScanArguments;

public class GlowConfig {
    private String context = "bare-metal";
    private String profile;
    private Set<String> addOns = Set.of();
    private String version;
    private boolean suggest;
    private Set<String> layersForJndi = Set.of();
    private boolean failsOnError = true;
    private boolean preview;

    public Arguments toArguments(Path deployment, Path inProvisioning) {
        Set profiles = this.profile != null ? Set.of(this.profile) : Set.of();
        List<Path> lst = List.of(deployment);
        ScanArguments.Builder builder = Arguments.scanBuilder().setExecutionContext(this.context).setExecutionProfiles(profiles).setUserEnabledAddOns(this.addOns).setBinaries(lst).setSuggest(this.suggest).setJndiLayers(this.getLayersForJndi()).setVersion(this.version).setTechPreview(this.preview).setOutput(OutputFormat.PROVISIONING_XML);
        if (inProvisioning != null) {
            builder.setProvisoningXML(inProvisioning);
        }
        return builder.build();
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public Set<String> getAddOns() {
        return this.addOns;
    }

    public void setAddOns(Set<String> addOns) {
        this.addOns = Set.copyOf(addOns);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isSuggest() {
        return this.suggest;
    }

    public void setSuggest(boolean suggest) {
        this.suggest = suggest;
    }

    public Set<String> getLayersForJndi() {
        return this.layersForJndi;
    }

    public void setLayersForJndi(Set<String> layersForJndi) {
        this.layersForJndi = Set.copyOf(layersForJndi);
    }

    public boolean isFailsOnError() {
        return this.failsOnError;
    }

    public void setFailsOnError(boolean failsOnError) {
        this.failsOnError = failsOnError;
    }

    public void setPreview(boolean preview) {
        this.preview = preview;
    }

    public boolean isPreview() {
        return this.preview;
    }
}

