/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.provision;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.api.GalleonBuilder;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.jboss.galleon.maven.plugin.util.MvnMessageWriter;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.jboss.galleon.util.IoUtils;
import org.wildfly.glow.ScanResults;
import org.wildfly.plugin.cli.BaseCommandConfiguration;
import org.wildfly.plugin.cli.CliSession;
import org.wildfly.plugin.cli.OfflineCommandExecutor;
import org.wildfly.plugin.common.StandardOutput;
import org.wildfly.plugin.common.Utils;
import org.wildfly.plugin.deployment.MojoDeploymentException;
import org.wildfly.plugin.deployment.PackageType;
import org.wildfly.plugin.provision.AbstractProvisionServerMojo;
import org.wildfly.plugin.provision.GlowConfig;
import org.wildfly.plugin.tools.bootablejar.BootableJarSupport;

@Mojo(name="package", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PACKAGE)
public class PackageServerMojo
extends AbstractProvisionServerMojo {
    private static final String JAR = "jar";
    private static final String BOOTABLE_JAR_NAME_RADICAL = "server-";
    @Parameter(alias="extra-server-content-dirs")
    List<String> extraServerContentDirs = Collections.emptyList();
    @Parameter(alias="packaging-scripts")
    private List<CliSession> packagingScripts = new ArrayList<CliSession>();
    @Parameter(property="wildfly.deployment.filename")
    private String filename;
    @Parameter(property="wildfly.serverConfig", alias="server-config", defaultValue="standalone.xml")
    private String serverConfig;
    @Parameter(property="wildfly.deployment.name")
    private String name;
    @Deprecated(since="4.1.O")
    @Parameter(property="wildfly.deployment.runtime.name", alias="runtime-name")
    protected String runtimeName;
    @Parameter(name="stdout", defaultValue="System.out", property="wildfly.stdout")
    private String stdout;
    @Parameter(defaultValue="false", property="wildfly.package.skip")
    private boolean skip;
    @Parameter(defaultValue="false", property="wildfly.package.deployment.skip")
    protected boolean skipDeployment;
    @Parameter(alias="discover-provisioning-info")
    private GlowConfig discoverProvisioningInfo;
    @Parameter(alias="bootable-jar", required=false, property="wildfly.bootable.jar")
    private boolean bootableJar;
    @Parameter(alias="bootable-jar-name", required=false, property="wildfly.bootable.jar.name")
    private String bootableJarName;
    @Parameter(alias="bootable-jar-install-artifact-classifier", property="wildfly.bootable.jar.classifier", defaultValue="bootable")
    private String bootableJarInstallArtifactClassifier;
    @Inject
    private OfflineCommandExecutor commandExecutor;
    private GalleonProvisioningConfig config;

    @Override
    protected GalleonProvisioningConfig getDefaultConfig() throws ProvisioningException {
        return null;
    }

    @Override
    protected GalleonProvisioningConfig buildGalleonConfig(GalleonBuilder pm) throws MojoExecutionException, ProvisioningException {
        GalleonProvisioningConfig galleonProvisioningConfig;
        block9: {
            if (this.discoverProvisioningInfo == null) {
                this.config = super.buildGalleonConfig(pm);
                return this.config;
            }
            ScanResults results = Utils.scanDeployment(this.discoverProvisioningInfo, this.layers, this.excludedLayers, this.featurePacks, this.dryRun, this.getLog(), this.getDeploymentContent(), this.artifactResolver, Paths.get(this.project.getBuild().getDirectory(), new String[0]), pm, this.galleonOptions, this.layersConfigurationFileName);
            try {
                galleonProvisioningConfig = this.config = results.getProvisioningConfig();
                if (results == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (results != null) {
                        try {
                            results.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    throw new MojoExecutionException(ex.getLocalizedMessage(), ex);
                }
            }
            results.close();
        }
        return galleonProvisioningConfig;
    }

    @Override
    protected String getGoal() {
        return "package";
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().debug((CharSequence)String.format("Skipping " + this.getGoal() + " of %s:%s", this.project.getGroupId(), this.project.getArtifactId()));
            return;
        }
        super.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void serverProvisioned(Path jbossHome) throws MojoExecutionException, MojoFailureException {
        Object deploymentContent;
        try {
            if (StandardOutput.isFile(this.stdout)) {
                Files.deleteIfExists(Paths.get(this.stdout, new String[0]));
            }
            if (!this.extraServerContentDirs.isEmpty()) {
                this.getLog().info((CharSequence)"Copying extra content to server");
                this.copyExtraContent(jbossHome);
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException(ex.getLocalizedMessage(), (Exception)ex);
        }
        if (!this.skipDeployment && Files.exists((Path)(deploymentContent = this.getDeploymentContent()), new LinkOption[0])) {
            Path standaloneDeploymentDir = Path.of(this.provisioningDir, "standalone", "deployments");
            if (!standaloneDeploymentDir.isAbsolute()) {
                standaloneDeploymentDir = Path.of(this.project.getBuild().getDirectory(), new String[0]).resolve(standaloneDeploymentDir);
            }
            try {
                Path deploymentTarget = standaloneDeploymentDir.resolve(this.getDeploymentTargetName());
                this.getLog().info((CharSequence)("Copy deployment " + (Path)deploymentContent + " to " + deploymentTarget));
                Files.copy((Path)deploymentContent, deploymentTarget, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new MojoDeploymentException("Could not copy deployment in provisioned server", e);
            }
        }
        try {
            if (!this.packagingScripts.isEmpty()) {
                this.getLog().info((CharSequence)"Excuting CLI commands and scripts");
                for (CliSession session : this.packagingScripts) {
                    List<File> wrappedScripts = this.wrapOfflineScripts(session.getScripts());
                    try {
                        BaseCommandConfiguration cmdConfig = ((BaseCommandConfiguration.Builder)((BaseCommandConfiguration.Builder)((BaseCommandConfiguration.Builder)((BaseCommandConfiguration.Builder)((BaseCommandConfiguration.Builder)((BaseCommandConfiguration.Builder)((BaseCommandConfiguration.Builder)((BaseCommandConfiguration.Builder)((BaseCommandConfiguration.Builder)new BaseCommandConfiguration.Builder().addCommands(this.wrapOfflineCommands(session.getCommands()))).addScripts(wrappedScripts)).addCLIArguments(new String[]{"--echo-command"})).setJBossHome(jbossHome)).setAppend(true)).setStdout(this.stdout)).addPropertiesFiles(this.resolveFiles(session.getPropertiesFiles()))).addJvmOptions(session.getJavaOpts())).setResolveExpression(session.getResolveExpression())).build();
                        this.commandExecutor.execute(cmdConfig, this.artifactResolver);
                    }
                    finally {
                        for (File f : wrappedScripts) {
                            Files.delete(f.toPath());
                        }
                    }
                }
            }
            PackageServerMojo.cleanupServer(jbossHome);
            if (this.bootableJar) {
                this.packageBootableJar(jbossHome, this.config);
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException(ex.getLocalizedMessage(), ex);
        }
    }

    private void attachJar(Path jarFile) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Attaching bootable jar " + jarFile + " as a project artifact with classifier " + this.bootableJarInstallArtifactClassifier));
        }
        this.projectHelper.attachArtifact(this.project, JAR, this.bootableJarInstallArtifactClassifier, jarFile.toFile());
    }

    private void packageBootableJar(Path jbossHome, GalleonProvisioningConfig activeConfig) throws Exception {
        String jarName = this.bootableJarName == null ? "server-bootable.jar" : this.bootableJarName;
        Path targetPath = Paths.get(this.project.getBuild().getDirectory(), new String[0]);
        Path targetJarFile = targetPath.toAbsolutePath().resolve(jarName);
        Files.deleteIfExists(targetJarFile);
        BootableJarSupport.packageBootableJar((Path)targetJarFile, (Path)targetPath, (GalleonProvisioningConfig)activeConfig, (Path)jbossHome, (MavenRepoManager)this.artifactResolver, (MessageWriter)new MvnMessageWriter(this.getLog()));
        this.attachJar(targetJarFile);
        this.getLog().info((CharSequence)("Bootable JAR packaging DONE. To run the server: java -jar " + targetJarFile));
    }

    protected String getDeploymentTargetName() throws MojoExecutionException {
        String targetName = this.runtimeName != null ? this.runtimeName : (this.name != null ? this.name : this.getDeploymentContent().getFileName().toString());
        return targetName;
    }

    private List<File> resolveFiles(List<File> files) {
        if (files == null || files.isEmpty()) {
            return files;
        }
        ArrayList<File> resolvedFiles = new ArrayList<File>();
        for (File f : files) {
            resolvedFiles.add(PackageServerMojo.resolvePath(this.project, f.toPath()).toFile());
        }
        return resolvedFiles;
    }

    private List<String> wrapOfflineCommands(List<String> commands) {
        if (commands == null || commands.isEmpty()) {
            return commands;
        }
        ArrayList<String> offlineCommands = new ArrayList<String>();
        String serverConfigName = this.serverConfig;
        if (!this.layersConfigurationFileName.equals("standalone.xml")) {
            serverConfigName = this.layersConfigurationFileName;
        }
        offlineCommands.add("embed-server --server-config=" + serverConfigName);
        offlineCommands.addAll(commands);
        offlineCommands.add("stop-embedded-server");
        return offlineCommands;
    }

    private List<File> wrapOfflineScripts(List<File> scripts) throws IOException, MojoExecutionException {
        ArrayList<File> wrappedScripts = new ArrayList<File>();
        for (File script : scripts) {
            if (script == null) continue;
            wrappedScripts.add(this.wrapScript(script).toFile());
        }
        return wrappedScripts;
    }

    private Path wrapScript(File script) throws IOException, MojoExecutionException {
        Path tempScript = Files.createTempFile("offline-cli-script", ".cli", new FileAttribute[0]);
        Path resolvedScript = PackageServerMojo.resolvePath(this.project, script.toPath());
        if (!Files.exists(resolvedScript, new LinkOption[0])) {
            throw new MojoExecutionException("CLI script " + resolvedScript + " doesn't exist");
        }
        List<String> cmds = Files.readAllLines(resolvedScript, StandardCharsets.UTF_8);
        List<String> wrappedCommands = this.wrapOfflineCommands(cmds);
        Files.write(tempScript, wrappedCommands, StandardCharsets.UTF_8, new OpenOption[0]);
        return tempScript;
    }

    public void copyExtraContent(Path target) throws MojoExecutionException, IOException {
        for (String path : this.extraServerContentDirs) {
            Path extraContent = Paths.get(path, new String[0]);
            if (Files.notExists(extraContent = PackageServerMojo.resolvePath(this.project, extraContent), new LinkOption[0])) {
                throw new MojoExecutionException("Extra content dir " + extraContent + " doesn't exist");
            }
            if (!Files.isDirectory(extraContent, new LinkOption[0])) {
                throw new MojoExecutionException("Extra content dir " + extraContent + " is not a directory");
            }
            this.warnExtraConfig(extraContent);
            IoUtils.copy((Path)extraContent, (Path)target);
        }
    }

    private void warnExtraConfig(Path extraContentDir) {
        Path config = extraContentDir.resolve("standalone").resolve("configurations").resolve("standalone.xml");
        if (Files.exists(config, new LinkOption[0])) {
            this.getLog().warn((CharSequence)("The file " + config + " overrides the Galleon generated configuration, un-expected behavior can occur when starting the server"));
        }
    }

    protected Path getDeploymentContent() throws MojoExecutionException {
        PackageType packageType = PackageType.resolve(this.project);
        String filename = this.filename == null ? String.format("%s.%s", this.project.getBuild().getFinalName(), packageType.getFileExtension()) : this.filename;
        Path deployment = Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve(filename);
        if (Files.notExists(deployment, new LinkOption[0])) {
            if (this.filename != null) {
                throw new MojoExecutionException("No deployment found with name " + this.filename);
            }
            if (this.runtimeName != null) {
                throw new MojoExecutionException("No deployment found with name " + filename + ". A runtime-name has been set that indicates that a deployment is expected. A custom file name can be set with the <filename> parameter.");
            }
            this.getLog().warn((CharSequence)"The project doesn't define a deployment artifact to deploy to the server.");
        }
        return deployment;
    }

    private static void cleanupServer(Path jbossHome) throws IOException {
        Path history = jbossHome.resolve("standalone").resolve("configuration").resolve("standalone_xml_history");
        IoUtils.recursiveDelete((Path)history);
        Path tmp = jbossHome.resolve("standalone").resolve("tmp");
        IoUtils.recursiveDelete((Path)tmp);
        Path log = jbossHome.resolve("standalone").resolve("log");
        IoUtils.recursiveDelete((Path)log);
    }
}

