/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.server;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.as.controller.client.helpers.domain.DomainClient;
import org.jboss.dmr.ModelNode;
import org.jboss.galleon.maven.plugin.util.MavenArtifactRepositoryManager;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.wildfly.core.launcher.CommandBuilder;
import org.wildfly.core.launcher.Launcher;
import org.wildfly.plugin.common.AbstractServerConnection;
import org.wildfly.plugin.common.StandardOutput;
import org.wildfly.plugin.core.MavenRepositoriesEnricher;
import org.wildfly.plugin.server.ServerContext;
import org.wildfly.plugin.server.ServerType;
import org.wildfly.plugin.tools.ServerHelper;

public abstract class AbstractStartMojo
extends AbstractServerConnection {
    @Component
    protected RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    protected RepositorySystemSession session;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    protected List<RemoteRepository> repositories;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession mavenSession;
    @Parameter(alias="java-opts", property="wildfly.javaOpts")
    protected String[] javaOpts;
    @Parameter(alias="java-home", property="java.home")
    protected String javaHome;
    @Parameter(property="wildfly.debug", defaultValue="false")
    protected boolean debug;
    @Parameter(property="wildfly.debug.host", defaultValue="*")
    protected String debugHost;
    @Parameter(property="wildfly.debug.port", defaultValue="8787")
    protected int debugPort;
    @Parameter(property="wildfly.debug.suspend", defaultValue="false")
    protected boolean debugSuspend;
    @Parameter(alias="properties-file", property="wildfly.propertiesFile")
    protected String propertiesFile;
    @Parameter(alias="startup-timeout", defaultValue="60", property="wildfly.startupTimeout")
    private long startupTimeout;
    @Parameter(alias="server-args", property="wildfly.serverArgs")
    protected String[] serverArgs;
    @Parameter(defaultValue="false", property="wildfly.skip")
    protected boolean skip;
    @Parameter
    private Map<String, String> env;
    private final AtomicBoolean initialized = new AtomicBoolean();
    protected MavenRepoManager mavenRepoManager;

    protected void init() throws MojoExecutionException {
        if (this.initialized.compareAndSet(false, true)) {
            MavenRepositoriesEnricher.enrich((MavenSession)this.mavenSession, (MavenProject)this.project, this.repositories);
            this.mavenRepoManager = this.createMavenRepoManager();
        }
    }

    protected MavenRepoManager createMavenRepoManager() throws MojoExecutionException {
        return new MavenArtifactRepositoryManager(this.repoSystem, this.session, this.repositories);
    }

    protected abstract Path getServerHome() throws MojoExecutionException, MojoFailureException;

    protected ServerContext startServer(ServerType serverType) throws MojoExecutionException, MojoFailureException {
        ServerContext serverContext;
        block14: {
            Log log = this.getLog();
            this.init();
            final Path server = this.getServerHome();
            StandardOutput out = this.standardOutput();
            ModelControllerClient client = this.createClient();
            try {
                if (ServerHelper.isStandaloneRunning((ModelControllerClient)client) || ServerHelper.isDomainRunning((ModelControllerClient)client)) {
                    throw new MojoExecutionException(String.format("%s server is already running?", new Object[]{serverType}));
                }
                final CommandBuilder commandBuilder = this.createCommandBuilder(server);
                log.info((CharSequence)String.format("%s server is starting up.", new Object[]{serverType}));
                Launcher launcher = Launcher.of((CommandBuilder)commandBuilder).setRedirectErrorStream(true);
                if (this.env != null) {
                    launcher.addEnvironmentVariables(this.env);
                }
                out.getRedirect().ifPresent(arg_0 -> ((Launcher)launcher).redirectOutput(arg_0));
                final Process process = launcher.launch();
                out.startConsumer(process);
                if (serverType == ServerType.DOMAIN) {
                    ServerHelper.waitForDomain((Process)process, (ModelControllerClient)DomainClient.Factory.create((ModelControllerClient)client), (long)this.startupTimeout);
                } else {
                    ServerHelper.waitForStandalone((Process)process, (ModelControllerClient)client, (long)this.startupTimeout);
                }
                if (!process.isAlive()) {
                    throw new MojoExecutionException("The process has been terminated before the start goal has completed.");
                }
                serverContext = new ServerContext(){

                    @Override
                    public Process process() {
                        return process;
                    }

                    @Override
                    public CommandBuilder commandBuilder() {
                        return commandBuilder;
                    }

                    @Override
                    public Path jbossHome() {
                        return server;
                    }
                };
                if (client == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MojoExecutionException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new MojoExecutionException("The server failed to start", e);
                }
            }
            client.close();
        }
        return serverContext;
    }

    protected abstract CommandBuilder createCommandBuilder(Path var1) throws MojoExecutionException;

    protected StandardOutput standardOutput() throws IOException {
        return StandardOutput.parse(null, false);
    }

    public void setJavaOpts(String value) {
        if (value != null) {
            this.javaOpts = value.split("\\s+");
        }
    }

    protected ServerContext actOnServerState(ModelControllerClient client, ServerContext context) throws IOException, MojoExecutionException, MojoFailureException {
        String serverState = ServerHelper.serverState((ModelControllerClient)client);
        if ("restart-required".equals(serverState)) {
            ServerHelper.shutdownStandalone((ModelControllerClient)client, (int)this.timeout);
            return this.startServer(ServerType.STANDALONE);
        }
        if ("reload-required".equals(serverState)) {
            ServerHelper.executeReload((ModelControllerClient)client, (ModelNode)Operations.createOperation((String)"reload"));
            try {
                ServerHelper.waitForStandalone((Process)context.process(), (ModelControllerClient)client, (long)this.timeout);
            }
            catch (InterruptedException | TimeoutException e) {
                throw new MojoExecutionException("Failed to wait for standalone server after a reload.", e);
            }
        } else if (!"running".equals(serverState)) {
            this.getLog().warn((CharSequence)String.format("The server may be in an unexpected state for further interaction. The current state is %s", serverState));
        }
        return context;
    }
}

