/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.cli;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.wildfly.plugin.cli.BaseCommandConfiguration;

class ScriptWriter {
    ScriptWriter() {
    }

    static Path create(BaseCommandConfiguration config) throws IOException {
        Path tempScript = Files.createTempFile("cli-scrpts", ".cli", new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(tempScript, StandardCharsets.UTF_8, new OpenOption[0]);){
            if (config.isBatch()) {
                writer.write("batch");
                writer.newLine();
            }
            boolean inTry = false;
            for (String cmd : config.getCommands()) {
                if (cmd == null || cmd.isEmpty()) continue;
                if (config.isFailOnError()) {
                    ScriptWriter.writeCommand(writer, cmd);
                    continue;
                }
                if ("try".equals(cmd.trim())) {
                    inTry = true;
                }
                if (inTry) {
                    ScriptWriter.writeCommand(writer, cmd);
                } else {
                    ScriptWriter.writeCommandInTry(writer, cmd);
                }
                if (!"end-try".equals(cmd.trim())) continue;
                inTry = false;
            }
            if (config.isBatch()) {
                writer.write("run-batch");
                writer.newLine();
            }
        }
        return tempScript;
    }

    private static void writeCommand(BufferedWriter writer, String cmd) throws IOException {
        writer.write(cmd);
        writer.newLine();
    }

    private static void writeCommandInTry(BufferedWriter writer, String cmd) throws IOException {
        writer.write("try");
        writer.newLine();
        ScriptWriter.writeCommand(writer, cmd);
        writer.write("catch");
        writer.newLine();
        writer.write("echo Failed to execute command: \"");
        writer.write(cmd);
        writer.write(34);
        writer.newLine();
        writer.write("end-try");
        writer.newLine();
    }
}

