/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.provision;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Map;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.wildfly.plugin.provision.ApplicationImageInfo;
import org.wildfly.plugin.provision.ExecUtil;
import org.wildfly.plugin.provision.PackageServerMojo;

@Mojo(name="image", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PACKAGE)
public class ApplicationImageMojo
extends PackageServerMojo {
    public static final int DOCKER_CMD_CHECK_TIMEOUT = 3000;
    @Parameter(property="settings", readonly=true, required=true, defaultValue="${settings}")
    private Settings settings;
    @Inject
    private SettingsDecrypter settingsDecrypter;
    @Deprecated(forRemoval=true, since="5.0.1")
    @Parameter(alias="image")
    private ApplicationImageInfo image;
    @Parameter(defaultValue="true", property="wildfly.image.build")
    private boolean build;
    @Parameter(defaultValue="false", property="wildfly.image.push")
    private boolean push;
    @Parameter(alias="jdk-version", property="wildfly.image.jdk.version")
    private String jdkVersion;
    @Parameter(property="wildfly.image.group")
    private String group;
    @Parameter(alias="image-name", property="wildfly.image.name")
    private String imageName;
    @Parameter(defaultValue="latest", property="wildfly.image.tag")
    private String tag;
    @Parameter(property="wildfly.image.registry")
    private String registry;
    @Parameter(alias="registry-id", property="wildfly.image.registry.id")
    private String registryId;
    @Parameter(property="wildfly.image.user")
    private String user;
    @Parameter
    private String password;
    @Parameter(alias="docker-binary", property="wildfly.image.binary")
    private String dockerBinary;
    @Parameter(property="wildfly.image.labels")
    private Map<String, String> labels;

    @Override
    protected String getGoal() {
        return "image";
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.skipDeployment = true;
        super.execute();
        if (this.image == null) {
            this.image = new ApplicationImageInfo();
            this.image.build = this.build;
            this.image.dockerBinary = this.dockerBinary;
            this.image.group = this.group;
            this.image.jdkVersion = this.jdkVersion;
            this.image.name = this.imageName;
            this.image.push = this.push;
            this.image.registry = this.registry;
            this.image.tag = this.tag;
            if (this.user == null && this.settings != null && this.registryId != null) {
                Server server = this.settings.getServer(this.registryId);
                if (server != null) {
                    this.image.user = server.getUsername();
                    this.image.password = this.decrypt(server);
                } else {
                    this.getLog().warn((CharSequence)String.format("No server %s found in settings.", this.registryId));
                    this.image.user = this.user;
                    this.image.password = this.password;
                }
            } else {
                this.image.user = this.user;
                this.image.password = this.password;
            }
        } else {
            this.getLog().warn((CharSequence)"You are using the deprecated image parameter. The image parameters will be ignored if defined outside of the image tag.");
        }
        try {
            String imageBinary;
            String runtimeImage = this.image.getWildFlyRuntimeImage();
            this.getLog().info((CharSequence)String.format("Generating Dockerfile %s from base image %s", Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve("Dockerfile"), runtimeImage));
            this.generateDockerfile(runtimeImage, Paths.get(this.project.getBuild().getDirectory(), new String[0]), this.provisioningDir);
            if (!this.image.build) {
                return;
            }
            if (this.image.dockerBinary == null) {
                this.image.setDockerBinary(this.project.getProperties().getProperty("wildfly.image.binary", System.getProperty("wildfly.image.binary")));
            }
            if ((imageBinary = this.image.getDockerBinary()) == null) {
                throw new MojoExecutionException("Could not locate a binary to build the image with. Please check your installation and either set the path to the binary in your PATH environment variable or define the define the fully qualified path in your configuration, <docker-binary>/path/to/docker</docker-binary>. The path can also be defined with the -Dwildfly.image.binary=/path/to/docker system property.");
            }
            if (!this.isImageBinaryAvailable(imageBinary)) {
                throw new MojoExecutionException(String.format("Unable to build application image with %1$s. Please check your %1$s installation", imageBinary));
            }
            String image = this.image.getApplicationImageName(this.project.getArtifactId());
            boolean buildSuccess = this.buildApplicationImage(image);
            if (!buildSuccess) {
                throw new MojoExecutionException(String.format("Unable to build application image %s", image));
            }
            this.getLog().info((CharSequence)String.format("Successfully built application image %s", image));
            if (this.image.push) {
                this.logToRegistry();
                boolean pushSuccess = this.pushApplicationImage(image);
                if (!pushSuccess) {
                    throw new MojoExecutionException(String.format("Unable to push application image %s", image));
                }
                this.getLog().info((CharSequence)String.format("Successfully pushed application image %s", image));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)e);
        }
    }

    private void logToRegistry() throws MojoExecutionException {
        String registry = this.image.registry;
        if (registry == null) {
            this.getLog().info((CharSequence)String.format("Registry was not set. Using default for %s.", this.image.getDockerBinary()));
        }
        if (this.image.user != null && this.image.password != null) {
            String[] dockerArgs = new String[]{"login", registry, "-u", this.image.user, "-p", this.image.password};
            boolean loginSuccessful = ExecUtil.exec(this.getLog(), this.image.getDockerBinary(), dockerArgs);
            if (!loginSuccessful) {
                throw new MojoExecutionException(String.format("Could not log to the container registry with the command: %s login %s -u %s -p *****", this.image.getDockerBinary(), registry, this.image.user));
            }
        }
    }

    private boolean buildApplicationImage(String image) throws IOException {
        this.getLog().info((CharSequence)String.format("Building application image %s using %s.", image, this.image.getDockerBinary()));
        CharSequence[] dockerArgs = new String[]{"build", "-t", image, "."};
        this.getLog().info((CharSequence)String.format("Executing the following command to build application image: '%s %s'", this.image.getDockerBinary(), String.join((CharSequence)" ", dockerArgs)));
        return ExecUtil.exec(this.getLog(), Paths.get(this.project.getBuild().getDirectory(), new String[0]).toFile(), this.image.getDockerBinary(), (String[])dockerArgs);
    }

    private boolean pushApplicationImage(String image) {
        this.getLog().info((CharSequence)String.format("Pushing application image %s using %s.", image, this.image.getDockerBinary()));
        CharSequence[] dockerArgs = new String[]{"push", image};
        this.getLog().info((CharSequence)String.format("Executing the following command to push application image: '%s %s'", this.image.getDockerBinary(), String.join((CharSequence)" ", dockerArgs)));
        return ExecUtil.exec(this.getLog(), Paths.get(this.project.getBuild().getDirectory(), new String[0]).toFile(), this.image.getDockerBinary(), (String[])dockerArgs);
    }

    private void generateDockerfile(String runtimeImage, Path targetDir, String wildflyDirectory) throws IOException, MojoExecutionException {
        Path jbossHome = Path.of(wildflyDirectory, new String[0]);
        if (jbossHome.isAbsolute()) {
            jbossHome = targetDir.relativize(jbossHome);
        }
        String targetName = this.getDeploymentTargetName();
        StringBuilder dockerfileContent = new StringBuilder();
        dockerfileContent.append("FROM ").append(runtimeImage).append('\n');
        if (this.labels != null) {
            this.labels.forEach((key, value) -> dockerfileContent.append("LABEL ").append((String)key).append("=\"").append(value.replace("\"", "\\\"")).append("\"\n"));
        }
        dockerfileContent.append("COPY --chown=jboss:root ").append(jbossHome).append(" $JBOSS_HOME\n").append("RUN chmod -R ug+rwX $JBOSS_HOME\n").append("COPY --chown=jboss:root ").append(this.getDeploymentContent().getFileName()).append(" $JBOSS_HOME/standalone/deployments/").append(targetName);
        ArrayList<CallSite> serverArgs = new ArrayList<CallSite>();
        if (!this.layers.isEmpty() && !this.layersConfigurationFileName.equals("standalone.xml")) {
            serverArgs.add((CallSite)((Object)("-c=" + this.layersConfigurationFileName)));
        } else if (!this.serverConfig.equals("standalone.xml")) {
            serverArgs.add((CallSite)((Object)("-c=" + this.serverConfig)));
        }
        if (!serverArgs.isEmpty()) {
            dockerfileContent.append('\n').append("ENV SERVER_ARGS=\"").append(String.join((CharSequence)",", serverArgs)).append('\"');
        }
        Files.writeString(targetDir.resolve("Dockerfile"), (CharSequence)dockerfileContent, StandardCharsets.UTF_8, new OpenOption[0]);
    }

    private boolean isImageBinaryAvailable(String imageBinary) {
        try {
            if (!ExecUtil.execSilentWithTimeout(Duration.ofMillis(3000L), imageBinary, "-v")) {
                this.getLog().warn((CharSequence)String.format("'%1$s -v' returned an error code. Make sure your %1$s binary is correct", imageBinary));
                return false;
            }
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)String.format("No %s binary found or general error: %s", imageBinary, e));
            return false;
        }
        return true;
    }

    private String decrypt(Server server) {
        SettingsDecryptionResult decrypt = this.settingsDecrypter.decrypt((SettingsDecryptionRequest)new DefaultSettingsDecryptionRequest(server));
        return decrypt.getServer().getPassword();
    }
}

