/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.tools.server;

import java.io.IOException;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.wildfly.plugin.tools.OperationExecutionException;
import org.wildfly.plugin.tools.server.AbstractServerManager;
import org.wildfly.plugin.tools.server.CommonOperations;
import org.wildfly.plugin.tools.server.ServerManagerException;

public class StandaloneManager
extends AbstractServerManager<ModelControllerClient> {
    private static final Logger LOGGER = Logger.getLogger(StandaloneManager.class);

    StandaloneManager(ProcessHandle process, ModelControllerClient client, boolean shutdownOnClose) {
        super(process, client, shutdownOnClose);
    }

    @Override
    public String serverState() {
        try {
            return this.executeOperation(Operations.createReadAttributeOperation((ModelNode)CommonOperations.EMPTY_ADDRESS, (String)"server-state")).asString();
        }
        catch (OperationExecutionException e) {
            LOGGER.debugf("Checking the server state has failed: %s", (Object)Operations.getFailureDescription((ModelNode)e.getExecutionResult()));
        }
        catch (IOException | RuntimeException e) {
            LOGGER.tracef("Interrupted determining the server state", (Object)e);
        }
        return "failed";
    }

    @Override
    public void executeReload() throws IOException {
        this.executeReload(Operations.createOperation((String)"reload"));
    }

    @Override
    public void reloadIfRequired(long timeout, TimeUnit unit) throws IOException {
        String launchType = this.launchType();
        if ("STANDALONE".equalsIgnoreCase(launchType)) {
            String runningState = this.serverState();
            if ("reload-required".equalsIgnoreCase(runningState)) {
                this.executeReload();
                try {
                    if (!this.waitFor(timeout, unit)) {
                        throw new ServerManagerException("Failed to reload server within %d %s.", timeout, unit.name().toLowerCase(Locale.ROOT));
                    }
                }
                catch (InterruptedException e) {
                    throw new ServerManagerException(e, "Failed to reload the server.");
                }
            }
        } else {
            LOGGER.warnf("Cannot reload and wait for the server to start with a server type of %s.", (Object)launchType);
        }
    }

    @Override
    public boolean isRunning() {
        if (this.process != null) {
            return this.process.isAlive() && CommonOperations.isStandaloneRunning(this.client());
        }
        return CommonOperations.isStandaloneRunning(this.client());
    }

    @Override
    void internalShutdown(ModelControllerClient client, long timeout) throws IOException {
        ModelNode op = Operations.createOperation((String)"shutdown");
        op.get("timeout").set(timeout);
        StandaloneManager.executeOperation(client, op);
    }
}

