/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.tools.cli;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jboss.logging.Logger;

public class ForkedCLIUtil {
    private static final Logger LOGGER = Logger.getLogger(ForkedCLIUtil.class);
    private static final Path JAVA_HOME;
    private static final String JAVA_CMD;

    public static void fork(String[] artifacts, Class<?> clazz, Path home, Path output, String ... args) throws IOException {
        ForkedCLIUtil.fork(List.of(artifacts), clazz, home, output, args);
    }

    public static void fork(Collection<String> artifacts, Class<?> clazz, Path home, Path output, String ... args) throws IOException {
        ForkedCLIUtil.fork(artifacts, clazz, home, null, output, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fork(Collection<String> artifacts, Class<?> clazz, Path home, String stabilityLevel, Path output, String ... args) throws IOException {
        StringBuilder cp = new StringBuilder();
        for (String loc : artifacts) {
            cp.append(loc).append(File.pathSeparator);
        }
        StringBuilder contextCP = new StringBuilder();
        ForkedCLIUtil.collectCpUrls(Thread.currentThread().getContextClassLoader(), contextCP);
        if (contextCP.length() == 0) {
            LOGGER.debug((Object)"Re-using process classpath to retrieve Maven plugin classes to fork CLI process.");
            cp.append(System.getProperty("java.class.path"));
        } else {
            cp.append((CharSequence)contextCP);
        }
        Path properties = ForkedCLIUtil.storeSystemProps();
        Path cpFile = Files.createTempFile("classpath-", ".txt", new FileAttribute[0]);
        Files.writeString(cpFile, (CharSequence)cp.toString(), StandardCharsets.UTF_8, new OpenOption[0]);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debugf("Classpath '%s' written to argument file %s (%d chars)", (Object)cp, (Object)cpFile, (Object)cp.length());
        }
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add(JAVA_CMD);
        argsList.add("-server");
        argsList.add("-cp");
        argsList.add("@" + String.valueOf(cpFile));
        argsList.add(clazz.getName());
        argsList.add(home.toString());
        argsList.add(output.toString());
        argsList.add(properties.toString());
        if (stabilityLevel != null) {
            argsList.add(stabilityLevel);
        }
        argsList.addAll(List.of(args));
        LOGGER.debugf("CLI process command line %s", argsList);
        try {
            Process p = new ProcessBuilder(argsList).redirectErrorStream(true).start();
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                int exitCode;
                int len;
                byte[] buffer = new byte[1024];
                InputStream in = p.getInputStream();
                while ((len = in.read(buffer)) != -1) {
                    bos.write(buffer, 0, len);
                }
                if (p.isAlive()) {
                    try {
                        p.waitFor();
                    }
                    catch (InterruptedException e) {
                        LOGGER.errorf((Throwable)e, "Interrupted while waiting for forked process %d to terminate.", (Object)p.pid());
                    }
                }
                if ((exitCode = p.exitValue()) != 0) {
                    String stdout = bos.toString(StandardCharsets.UTF_8);
                    throw new RuntimeException("CLI execution failed:" + stdout);
                }
            }
        }
        finally {
            Files.deleteIfExists(properties);
            Files.deleteIfExists(cpFile);
        }
    }

    private static Path storeSystemProps() throws IOException {
        Path props = Files.createTempFile("wfbootablejar", "sysprops", new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(props, new OpenOption[0]);){
            System.getProperties().store(writer, "");
        }
        return props;
    }

    private static void collectCpUrls(ClassLoader cl, StringBuilder buf) {
        ClassLoader parentCl = cl.getParent();
        if (parentCl != null) {
            ForkedCLIUtil.collectCpUrls(cl.getParent(), buf);
        }
        if (cl instanceof URLClassLoader) {
            for (URL url : ((URLClassLoader)cl).getURLs()) {
                String file;
                try {
                    file = new File(url.toURI()).getAbsolutePath();
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
                if (file.startsWith(JAVA_HOME.toString())) continue;
                if (buf.length() > 0) {
                    buf.append(File.pathSeparatorChar);
                }
                buf.append(file);
            }
        }
    }

    static {
        String javaHome = System.getProperty("java.home");
        JAVA_HOME = Path.of(javaHome, new String[0]);
        Path cmd = JAVA_HOME.resolve("bin").resolve("java");
        JAVA_CMD = Files.notExists(cmd, new LinkOption[0]) ? "java" : cmd.toAbsolutePath().toString();
    }
}

