/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.bean_validation.model;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.NotEmpty;

@Entity
@Table(name="MEMBER_BEAN_VALIDATION", uniqueConstraints={@UniqueConstraint(columnNames={"email"})})
public class Member
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue
    private Long id;
    @NotNull
    @Size(min=1, max=25)
    @Pattern(regexp="[A-Za-z ]*", message="must contain only letters and spaces")
    private String name;
    @NotNull
    @NotEmpty(message="not a well-formed email address")
    @Email(message="not a well-formed email address")
    private String email;
    @NotNull
    @Size(min=10, max=12, message="size must be between 10 and 12")
    @Digits(fraction=0, integer=12)
    @Column(name="phone_number")
    private String phoneNumber;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }
}

