/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.bmt;

import java.util.List;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;
import javax.transaction.RollbackException;
import javax.transaction.UserTransaction;
import org.jboss.as.quickstarts.bmt.KVPair;

public class UnManagedComponent {
    @PersistenceUnit(unitName="primary")
    private EntityManagerFactory entityManagerFactory;
    @Inject
    private UserTransaction userTransaction;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String updateKeyValueDatabase(String key, String value) {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        try {
            this.userTransaction.begin();
            entityManager.joinTransaction();
            String result = this.updateKeyValueDatabase(entityManager, key, value);
            this.userTransaction.commit();
            String string = result;
            return string;
        }
        catch (RollbackException e) {
            Throwable t = e.getCause();
            String string = t != null ? t.getMessage() : e.getMessage();
            return string;
        }
        catch (Exception e) {
            String string = e.getMessage();
            return string;
        }
        finally {
            try {
                if (this.userTransaction.getStatus() == 0) {
                    this.userTransaction.rollback();
                }
            }
            catch (Throwable throwable) {}
            entityManager.close();
        }
    }

    public String updateKeyValueDatabase(EntityManager entityManager, String key, String value) {
        StringBuilder sb = new StringBuilder();
        if (key == null || key.length() == 0) {
            List list = entityManager.createQuery("select k from KVPair k").getResultList();
            for (KVPair kvPair : list) {
                sb.append(kvPair.getKey()).append("=").append(kvPair.getValue()).append(',');
            }
        } else {
            KVPair kvPair;
            if (value == null) {
                kvPair = new KVPair(key, value);
                entityManager.refresh((Object)kvPair);
            } else {
                kvPair = (KVPair)entityManager.find(KVPair.class, (Object)key);
                if (kvPair == null) {
                    kvPair = new KVPair(key, value);
                    entityManager.persist((Object)kvPair);
                } else {
                    kvPair.setValue(value);
                    entityManager.persist((Object)kvPair);
                }
            }
            sb.append(kvPair.getKey()).append("=").append(kvPair.getValue());
        }
        return sb.toString();
    }
}

