/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstart.cdi.extension;

import java.lang.reflect.Field;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.InjectionException;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import org.jboss.as.quickstart.cdi.extension.model.Creature;
import org.w3c.dom.Element;

public class XmlBackedWrappedInjectionTarget<X extends Creature>
implements InjectionTarget<X> {
    private final InjectionTarget<X> wrapped;
    private final Element xmlBacking;

    public XmlBackedWrappedInjectionTarget(InjectionTarget<X> it, Element xmlElement) {
        this.wrapped = it;
        this.xmlBacking = xmlElement;
    }

    public void inject(X instance, CreationalContext<X> ctx) {
        this.wrapped.inject(instance, ctx);
        Class<?> klass = instance.getClass();
        for (Field field : klass.getDeclaredFields()) {
            field.setAccessible(true);
            String fieldValueFromXml = this.xmlBacking.getAttribute(field.getName());
            try {
                if (field.getType().isAssignableFrom(Integer.TYPE)) {
                    field.set(instance, Integer.parseInt(fieldValueFromXml));
                    continue;
                }
                if (field.getType().isAssignableFrom(String.class)) {
                    field.set(instance, fieldValueFromXml);
                    continue;
                }
                throw new InjectionException("Cannot convert to type " + field.getType());
            }
            catch (IllegalAccessException e) {
                throw new InjectionException("Cannot access field " + field);
            }
        }
    }

    public void postConstruct(X instance) {
        this.wrapped.postConstruct(instance);
    }

    public void preDestroy(X instance) {
        this.wrapped.preDestroy(instance);
    }

    public X produce(CreationalContext<X> ctx) {
        return (X)((Creature)this.wrapped.produce(ctx));
    }

    public void dispose(X instance) {
        this.wrapped.dispose(instance);
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return this.wrapped.getInjectionPoints();
    }
}

