/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.cmt.controller;

import java.util.List;
import java.util.logging.Logger;
import javax.faces.bean.RequestScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.jboss.as.quickstarts.cmt.ejb.CustomerManagerEJB;
import org.jboss.as.quickstarts.cmt.model.Customer;

@Named(value="customerManager")
@RequestScoped
public class CustomerManager {
    private Logger logger = Logger.getLogger(CustomerManager.class.getName());
    @Inject
    private CustomerManagerEJB customerManager;

    public List<Customer> getCustomers() throws SecurityException, IllegalStateException, NamingException, NotSupportedException, SystemException, RollbackException, HeuristicMixedException, HeuristicRollbackException {
        return this.customerManager.listCustomers();
    }

    public String addCustomer(String name) {
        try {
            this.customerManager.createCustomer(name);
            return "customerAdded";
        }
        catch (Exception e) {
            if (e.getMessage().contains("Invalid name")) {
                this.logger.warning("Invalid name: " + e.getMessage());
                return "customerInvalidName";
            }
            this.logger.warning("Caught a duplicate: " + e.getMessage());
            return "customerDuplicate";
        }
    }
}

