/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.cmt.ejb;

import java.rmi.RemoteException;
import java.util.List;
import javax.ejb.EJBException;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import javax.jms.JMSException;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.jboss.as.quickstarts.cmt.ejb.InvoiceManagerEJB;
import org.jboss.as.quickstarts.cmt.ejb.LogMessageManagerEJB;
import org.jboss.as.quickstarts.cmt.model.Customer;

/*
 * Exception performing whole class analysis ignored.
 */
@Stateless
public class CustomerManagerEJB {
    @PersistenceContext
    private EntityManager entityManager;
    @Inject
    private LogMessageManagerEJB logMessageManager;
    @Inject
    private InvoiceManagerEJB invoiceManager;

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void createCustomer(String name) throws RemoteException, JMSException {
        this.logMessageManager.logCreateCustomer(name);
        Customer c1 = new Customer();
        c1.setName(name);
        this.entityManager.persist((Object)c1);
        this.invoiceManager.createInvoice(name);
        if (!CustomerManagerEJB.nameIsValid((String)name)) {
            throw new EJBException("Invalid name: customer names should only contain letters & '-'");
        }
    }

    static boolean nameIsValid(String name) {
        return name.matches("[\\p{L}-]+");
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public List<Customer> listCustomers() {
        return this.entityManager.createQuery("select c from Customer c").getResultList();
    }
}

