/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.ejb_security_context_propagation;

import javax.annotation.Resource;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ejb.Remote;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import org.jboss.as.quickstarts.ejb_security_context_propagation.SecuredEJBRemote;
import org.jboss.ejb3.annotation.SecurityDomain;

@Stateless
@Remote(value={SecuredEJBRemote.class})
@SecurityDomain(value="quickstart-domain")
public class SecuredEJB
implements SecuredEJBRemote {
    @Resource
    private SessionContext context;

    @Override
    @PermitAll
    public String getSecurityInformation() {
        StringBuilder sb = new StringBuilder("[");
        sb.append("Principal=[").append(this.context.getCallerPrincipal().getName()).append("], ");
        this.userInRole("guest", sb).append(", ");
        this.userInRole("user", sb).append(", ");
        this.userInRole("admin", sb).append("]");
        return sb.toString();
    }

    @Override
    @RolesAllowed(value={"guest"})
    public String guestMethod() {
        return "Principal=[" + this.context.getCallerPrincipal() + "] has guest permissions";
    }

    @Override
    @RolesAllowed(value={"user"})
    public String userMethod() {
        return "Principal=[" + this.context.getCallerPrincipal() + "] has user permissions";
    }

    @Override
    @RolesAllowed(value={"admin"})
    public String adminMethod() {
        return "Principal=[" + this.context.getCallerPrincipal() + "] has admin permissions";
    }

    private StringBuilder userInRole(String role, StringBuilder sb) {
        sb.append("In role [").append(role).append("]=").append(this.context.isCallerInRole(role));
        return sb;
    }
}

