/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.ejb_security_jaas;

import java.io.IOException;
import java.io.PrintWriter;
import javax.ejb.EJB;
import javax.servlet.ServletException;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.annotation.ServletSecurity;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.as.quickstarts.ejb_security_jaas.SecuredEJBRemote;

@WebServlet(value={"/SecuredEJBServlet"})
@ServletSecurity(value=@HttpConstraint(rolesAllowed={"guest"}))
public class SecuredEJBServlet
extends HttpServlet {
    private static String PAGE_HEADER = "<html><head><title>ejb-security</title></head><body>";
    private static String PAGE_FOOTER = "</body></html>";
    @EJB
    private SecuredEJBRemote securedEJB;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        PrintWriter writer = resp.getWriter();
        String principal = null;
        String authType = null;
        String remoteUser = null;
        principal = this.securedEJB.getSecurityInformation();
        remoteUser = req.getRemoteUser();
        authType = req.getAuthType();
        boolean hasAdminPermission = false;
        try {
            hasAdminPermission = this.securedEJB.administrativeMethod();
        }
        catch (Exception exception) {
            // empty catch block
        }
        writer.println(PAGE_HEADER);
        writer.println("<h1>Successfully called Secured EJB </h1>");
        writer.println("<p>Principal  : " + principal + "</p>");
        writer.println("<p>Remote User : " + remoteUser + "</p>");
        writer.println("<p>Has admin permission : " + hasAdminPermission + "</p>");
        writer.println("<p>Authentication Type : " + authType + "</p>");
        writer.println(PAGE_FOOTER);
        writer.close();
    }
}

