/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.jms.Destination;
import javax.jms.JMSContext;
import javax.jms.JMSDestinationDefinition;
import javax.jms.JMSDestinationDefinitions;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@JMSDestinationDefinitions(value={@JMSDestinationDefinition(name="java:/${property.helloworldmdb.queue}", interfaceName="javax.jms.Queue", destinationName="HelloWorldMDBQueue"), @JMSDestinationDefinition(name="java:/${property.helloworldmdb.topic}", interfaceName="javax.jms.Topic", destinationName="HelloWorldMDBTopic")})
@WebServlet(value={"/HelloWorldMDBServletClient"})
public class HelloWorldMDBServletClient
extends HttpServlet {
    private static final long serialVersionUID = -8314035702649252239L;
    private static final int MSG_COUNT = 5;
    @Inject
    private JMSContext context;
    @Resource(lookup="${property.helloworldmdb.queue}")
    private Queue queue;
    @Resource(lookup="${property.helloworldmdb.topic}")
    private Topic topic;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/html");
        out.write("<h1>Quickstart: Example demonstrates the use of <strong>JMS 2.0</strong> and <strong>EJB 3.2 Message-Driven Bean</strong> in JBoss EAP.</h1>");
        try (PrintWriter out = resp.getWriter();){
            boolean useTopic = req.getParameterMap().keySet().contains("topic");
            Topic destination = useTopic ? this.topic : this.queue;
            out.write("<p>Sending messages to <em>" + destination + "</em></p>");
            out.write("<h2>The following messages will be sent to the destination:</h2>");
            for (int i = 0; i < 5; ++i) {
                String text = "This is message " + (i + 1);
                this.context.createProducer().send((Destination)destination, text);
                out.write("Message (" + i + "): " + text + "</br>");
            }
            out.write("<p><i>Go to your JBoss EAP server console or server log to see the result of messages processing.</i></p>");
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }
}

