/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.jaxrsclient.rest;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jboss.as.quickstarts.jaxrsclient.model.Contact;

@Path(value="/contacts")
public class ContactResourceRESTService {
    private static Map<Long, Contact> contactsRepository = new HashMap();

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createContact(Contact contact) {
        Response.ResponseBuilder builder = null;
        Long nextId = (long)contactsRepository.keySet().size() + 1L;
        try {
            contact.setId(nextId);
            contactsRepository.put(nextId, contact);
            builder = Response.ok((Object)contact);
        }
        catch (Exception e) {
            builder = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage());
        }
        return builder.build();
    }

    @DELETE
    public Response removeAllContacts() {
        contactsRepository.clear();
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/{id}")
    public Response removeContact(@PathParam(value="id") Long id) {
        contactsRepository.remove(id);
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/json"})
    public Response getAll() {
        Collection allcontacts = contactsRepository.values();
        return Response.ok(allcontacts).build();
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response getById(@PathParam(value="id") Long id) {
        Contact contact = (Contact)contactsRepository.get(id);
        return Response.ok((Object)contact).build();
    }
}

