/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.quickstarts.jaxrsjwt.rs;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import java.security.Principal;
import java.text.ParseException;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.jboss.quickstarts.jaxrsjwt.auth.JwtManager;
import org.jboss.quickstarts.jaxrsjwt.model.Jwt;
import org.jboss.quickstarts.jaxrsjwt.user.User;
import org.jboss.quickstarts.jaxrsjwt.user.UserService;

@Path(value="/")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class TestRest {
    private static final Logger log = Logger.getLogger(TestRest.class.getName());
    @Inject
    JwtManager jwtManager;
    @EJB
    UserService service;
    @Context
    private SecurityContext securityContext;

    @GET
    @Path(value="/customer")
    public String getCustomerJSON() {
        return "{\"path\":\"customer\",\"result\":" + this.sayHello() + "}";
    }

    @GET
    @Path(value="/protected")
    public String getProtectedJSON() {
        return "{\"path\":\"protected\",\"result\":" + this.sayHello() + "}";
    }

    @GET
    @Path(value="/public")
    public String getPublicJSON() {
        return "{\"path\":\"public\",\"result\":" + this.sayHello() + "}";
    }

    @GET
    @Path(value="/claims")
    public Response demonstrateClaims(@HeaderParam(value="Authorization") String auth) {
        if (auth != null && auth.startsWith("Bearer ")) {
            try {
                JWT j = JWTParser.parse((String)auth.substring(7));
                return Response.ok((Object)j.getJWTClaimsSet().getClaims()).build();
            }
            catch (ParseException e) {
                log.warning(e.toString());
                return Response.status((int)400).build();
            }
        }
        return Response.status((int)204).build();
    }

    @POST
    @Path(value="/token")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response postJWT(@FormParam(value="username") String username, @FormParam(value="password") String password) {
        log.info("Authenticating " + username);
        try {
            User user = this.service.authenticate(username, password);
            if (user != null) {
                if (user.getName() != null) {
                    log.info("Generating JWT for org.jboss.user " + user.getName());
                }
                String token = this.jwtManager.createJwt(user.getName(), user.getRoles());
                return Response.ok((Object)new Jwt(token)).build();
            }
        }
        catch (Exception e) {
            log.info(e.getMessage());
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    private String sayHello() {
        Principal userPrincipal = this.securityContext.getUserPrincipal();
        String principalName = userPrincipal == null ? "anonymous" : userPrincipal.getName();
        return "\"Hello " + principalName + "!\"";
    }
}

