/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.xa;

import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.TextMessage;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XASession;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.transaction.UserTransaction;
import org.jboss.as.quickstarts.xa.KVPair;

public class XAService {
    private static final Logger LOGGER = Logger.getLogger(XAService.class.getName());
    @PersistenceContext
    private EntityManager em;
    @Inject
    private UserTransaction userTransaction;
    @Resource(mappedName="java:/JmsXA")
    private XAConnectionFactory xaConnectionFactory;
    @Resource(mappedName="java:/queue/jta-crash-rec-quickstart")
    private Queue queue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyUpdate(Queue queue, String msg) throws Exception {
        XAConnection connection = null;
        try {
            connection = this.xaConnectionFactory.createXAConnection();
            XASession session = connection.createXASession();
            MessageProducer messageProducer = session.createProducer((Destination)queue);
            connection.start();
            TextMessage message = session.createTextMessage();
            message.setText(msg);
            messageProducer.send((Message)message);
            messageProducer.close();
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (JMSException e) {
                    LOGGER.info("Error closing JMS connection: " + e.getMessage());
                }
            }
        }
    }

    private String listPairs() {
        StringBuilder result = new StringBuilder();
        List list = this.em.createQuery("select k from KVPair k").getResultList();
        result.append("<table><caption>Database Table Contents</caption><tr><th>Key</th><th>Value</th></tr>");
        for (KVPair kvPair : list) {
            result.append("<tr><td>");
            result.append(kvPair.getKey());
            result.append("</td><td>");
            result.append(kvPair.getValue());
            result.append("</td></tr>");
        }
        result.append("</table>");
        return result.toString();
    }

    public boolean modifyKeyValueTable(EntityManager entityManager, boolean delete, String key, String value) {
        boolean keyIsValid;
        boolean bl = keyIsValid = key != null && key.length() != 0;
        if (delete) {
            if (keyIsValid) {
                KVPair pair = (KVPair)entityManager.find(KVPair.class, (Object)key);
                if (pair != null) {
                    entityManager.remove((Object)pair);
                }
            } else {
                Query query = entityManager.createQuery("DELETE FROM KVPair k");
                query.executeUpdate();
            }
        } else if (keyIsValid) {
            KVPair pair = (KVPair)entityManager.find(KVPair.class, (Object)key);
            if (pair == null) {
                entityManager.persist((Object)new KVPair(key, value));
            } else {
                pair.setValue(value);
                entityManager.merge((Object)pair);
            }
            return true;
        }
        return false;
    }

    public void modifyKeyValueTable(boolean delete, String key, String value) {
        this.modifyKeyValueTable(this.em, delete, key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String updateKeyValueDatabase(boolean delete, String key, String value) {
        StringBuilder result = new StringBuilder();
        try {
            this.userTransaction.begin();
            if (this.modifyKeyValueTable(this.em, delete, key, value)) {
                this.notifyUpdate(this.queue, key + "=" + value);
            }
            this.userTransaction.commit();
            this.userTransaction.begin();
            result.append(this.listPairs());
            this.userTransaction.commit();
        }
        catch (Exception e) {
            result.append(e.getCause() != null ? e.getCause().getMessage() : e.getMessage());
        }
        finally {
            try {
                if (this.userTransaction.getStatus() == 0 || this.userTransaction.getStatus() == 1) {
                    this.userTransaction.rollback();
                }
            }
            catch (Throwable e) {
                result.append(" Transaction did not finish: ").append(e.getMessage());
            }
        }
        return result.toString();
    }
}

