/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.kitchensink.controller;

import javax.annotation.PostConstruct;
import javax.enterprise.inject.Model;
import javax.enterprise.inject.Produces;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.as.quickstarts.kitchensink.model.Member;
import org.jboss.as.quickstarts.kitchensink.service.MemberRegistration;

@Model
public class MemberController {
    @Inject
    private FacesContext facesContext;
    @Inject
    private MemberRegistration memberRegistration;
    @Produces
    @Named
    private Member newMember;

    @PostConstruct
    public void initNewMember() {
        this.newMember = new Member();
    }

    public void register() throws Exception {
        try {
            this.memberRegistration.register(this.newMember);
            FacesMessage m = new FacesMessage(FacesMessage.SEVERITY_INFO, "Registered!", "Registration successful");
            this.facesContext.addMessage(null, m);
            this.initNewMember();
        }
        catch (Exception e) {
            String errorMessage = this.getRootErrorMessage(e);
            FacesMessage m = new FacesMessage(FacesMessage.SEVERITY_ERROR, errorMessage, "Registration unsuccessful");
            this.facesContext.addMessage(null, m);
        }
    }

    private String getRootErrorMessage(Exception e) {
        String errorMessage = "Registration failed. See server log for more information";
        if (e == null) {
            return errorMessage;
        }
        for (Throwable t = e; t != null; t = t.getCause()) {
            errorMessage = t.getLocalizedMessage();
        }
        return errorMessage;
    }
}

