/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.kitchensink.data;

import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.jboss.as.quickstarts.kitchensink.model.Member;

@ApplicationScoped
public class MemberRepository {
    @Inject
    private EntityManager em;

    public Member findById(Long id) {
        return (Member)this.em.find(Member.class, (Object)id);
    }

    public Member findByEmail(String email) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery criteria = cb.createQuery(Member.class);
        Root member = criteria.from(Member.class);
        criteria.select((Selection)member).where((Expression)cb.equal((Expression)member.get("email"), (Object)email));
        return (Member)this.em.createQuery(criteria).getSingleResult();
    }

    public List<Member> findAllOrderedByName() {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery criteria = cb.createQuery(Member.class);
        Root member = criteria.from(Member.class);
        criteria.select((Selection)member).orderBy(new Order[]{cb.asc((Expression)member.get("name"))});
        return this.em.createQuery(criteria).getResultList();
    }
}

