/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.kitchensink.rest;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.persistence.NoResultException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.jboss.as.quickstarts.kitchensink.data.MemberRepository;
import org.jboss.as.quickstarts.kitchensink.model.Member;
import org.jboss.as.quickstarts.kitchensink.service.MemberRegistration;

@Path(value="/members")
@RequestScoped
public class MemberResourceRESTService {
    @Inject
    private Logger log;
    @Inject
    private Validator validator;
    @Inject
    private MemberRepository repository;
    @Inject
    MemberRegistration registration;

    @GET
    @Produces(value={"application/json"})
    public List<Member> listAllMembers() {
        return this.repository.findAllOrderedByName();
    }

    @GET
    @Path(value="/{id:[0-9][0-9]*}")
    @Produces(value={"application/json"})
    public Member lookupMemberById(@PathParam(value="id") long id) {
        Member member = this.repository.findById(Long.valueOf(id));
        if (member == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        return member;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createMember(Member member) {
        Response.ResponseBuilder builder = null;
        try {
            this.validateMember(member);
            this.registration.register(member);
            builder = Response.ok();
        }
        catch (ConstraintViolationException ce) {
            builder = this.createViolationResponse(ce.getConstraintViolations());
        }
        catch (ValidationException e) {
            HashMap<String, String> responseObj = new HashMap<String, String>();
            responseObj.put("email", "Email taken");
            builder = Response.status((Response.Status)Response.Status.CONFLICT).entity(responseObj);
        }
        catch (Exception e) {
            HashMap<String, String> responseObj = new HashMap<String, String>();
            responseObj.put("error", e.getMessage());
            builder = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(responseObj);
        }
        return builder.build();
    }

    private void validateMember(Member member) throws ConstraintViolationException, ValidationException {
        Set violations = this.validator.validate((Object)member, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(new HashSet(violations));
        }
        if (this.emailAlreadyExists(member.getEmail())) {
            throw new ValidationException("Unique Email Violation");
        }
    }

    private Response.ResponseBuilder createViolationResponse(Set<ConstraintViolation<?>> violations) {
        this.log.fine("Validation completed. violations found: " + violations.size());
        HashMap<String, String> responseObj = new HashMap<String, String>();
        for (ConstraintViolation<?> violation : violations) {
            responseObj.put(violation.getPropertyPath().toString(), violation.getMessage());
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(responseObj);
    }

    public boolean emailAlreadyExists(String email) {
        Member member = null;
        try {
            member = this.repository.findByEmail(email);
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
        return member != null;
    }
}

