/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.payment.beans;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.as.quickstarts.payment.beans.PaymentBean;
import org.jboss.as.quickstarts.payment.events.PaymentEvent;
import org.jboss.as.quickstarts.payment.events.PaymentTypeEnum;
import org.jboss.as.quickstarts.payment.qualifiers.Credit;
import org.jboss.as.quickstarts.payment.qualifiers.Debit;

@Named
@SessionScoped
public class PaymentBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    private Logger log;
    @Inject
    @Credit
    Event<PaymentEvent> creditEventProducer;
    @Inject
    @Debit
    Event<PaymentEvent> debitEventProducer;
    private BigDecimal amount = new BigDecimal(0);
    private PaymentTypeEnum paymentOption = PaymentTypeEnum.DEBIT;

    @PostConstruct
    private void init() {
        this.amount = new BigDecimal(0);
        this.paymentOption = PaymentTypeEnum.DEBIT;
    }

    public String pay() {
        PaymentEvent currentEvtPayload = new PaymentEvent();
        currentEvtPayload.setType(this.paymentOption);
        currentEvtPayload.setAmount(this.amount);
        currentEvtPayload.setDatetime(new Date());
        switch (1.$SwitchMap$org$jboss$as$quickstarts$payment$events$PaymentTypeEnum[currentEvtPayload.getType().ordinal()]) {
            case 1: {
                this.debitEventProducer.fire((Object)currentEvtPayload);
                break;
            }
            case 2: {
                this.creditEventProducer.fire((Object)currentEvtPayload);
                break;
            }
            default: {
                this.log.severe("invalid payment option");
            }
        }
        return "index";
    }

    public void reset() {
        this.init();
    }

    public Event<PaymentEvent> getCreditEventLauncher() {
        return this.creditEventProducer;
    }

    public void setCreditEventLauncher(Event<PaymentEvent> creditEventLauncher) {
        this.creditEventProducer = creditEventLauncher;
    }

    public Event<PaymentEvent> getDebitEventLauncher() {
        return this.debitEventProducer;
    }

    public void setDebitEventLauncher(Event<PaymentEvent> debitEventLauncher) {
        this.debitEventProducer = debitEventLauncher;
    }

    public PaymentTypeEnum getPaymentOption() {
        return this.paymentOption;
    }

    public void setPaymentOption(PaymentTypeEnum paymentOption) {
        this.paymentOption = paymentOption;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }
}

