/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstarts.kitchensink.spring.matrixvariables.controller;

import java.util.List;
import java.util.logging.Logger;
import javax.persistence.NoResultException;
import javax.validation.Valid;
import org.jboss.as.quickstarts.kitchensink.spring.matrixvariables.data.MemberDao;
import org.jboss.as.quickstarts.kitchensink.spring.matrixvariables.data.MemberDaoImpl;
import org.jboss.as.quickstarts.kitchensink.spring.matrixvariables.model.Member;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.UnexpectedRollbackException;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.MatrixVariable;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/"})
public class MemberController {
    private static final Logger log = Logger.getLogger(MemberDaoImpl.class.getName());
    @Autowired
    private MemberDao memberDao;

    @RequestMapping(method={RequestMethod.GET})
    public String displaySortedMembers(Model model) {
        model.addAttribute("newMember", (Object)new Member());
        model.addAttribute("members", (Object)this.memberDao.findAllOrderedByName());
        return "index";
    }

    @RequestMapping(value={"/mv/{filter}"}, method={RequestMethod.GET})
    public ModelAndView filteredMembers(@MatrixVariable(value="n", pathVar="filter", required=false, defaultValue="") String n, @MatrixVariable(value="e", pathVar="filter", required=false, defaultValue="") String e) {
        log.fine("filteredMembers @MatrixVariable n = " + n + ", e = " + e);
        ModelAndView model = new ModelAndView("index");
        model.addObject("newMember", (Object)new Member());
        List members = this.memberDao.findByNameAndEmail(n, e);
        model.addObject("members", (Object)members);
        return model;
    }

    @RequestMapping(method={RequestMethod.POST})
    public String registerNewMember(@Valid @ModelAttribute(value="newMember") Member newMember, BindingResult result, Model model) {
        if (!result.hasErrors()) {
            try {
                this.memberDao.register(newMember);
                return "redirect:/";
            }
            catch (UnexpectedRollbackException e) {
                model.addAttribute("members", (Object)this.memberDao.findAllOrderedByName());
                if (this.emailAlreadyExists(newMember.getEmail())) {
                    model.addAttribute("error", (Object)"Unique Email Violation");
                } else {
                    model.addAttribute("error", (Object)e.getCause().getCause());
                }
                return "index";
            }
        }
        model.addAttribute("members", (Object)this.memberDao.findAllOrderedByName());
        return "index";
    }

    public boolean emailAlreadyExists(String email) {
        Member member = null;
        try {
            member = this.memberDao.findByEmail(email);
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
        return member != null;
    }
}

