/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstart.deltaspike.beanbuilder;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import org.apache.deltaspike.core.util.bean.BeanBuilder;
import org.apache.deltaspike.core.util.metadata.builder.ContextualLifecycle;
import org.jboss.as.quickstart.deltaspike.beanbuilder.ById;
import org.jboss.as.quickstart.deltaspike.beanbuilder.ByIdLiteral;
import org.jboss.as.quickstart.deltaspike.beanbuilder.PersonContextualLifecycle;
import org.jboss.as.quickstart.deltaspike.beanbuilder.model.Person;

public class ByIdExtension
implements Extension {
    private final List<String> ids = new LinkedList();

    public void processInjectionTarget(@Observes ProcessInjectionTarget<?> pit) {
        for (InjectionPoint ip : pit.getInjectionTarget().getInjectionPoints()) {
            ById idValue = (ById)ip.getAnnotated().getAnnotation(ById.class);
            if (idValue == null) continue;
            this.ids.add(idValue.value());
        }
    }

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery abd, BeanManager bm) {
        for (String idValue : this.ids) {
            BeanBuilder beanBuilder = new BeanBuilder(bm).beanClass(Person.class).types(new Type[]{Person.class, Object.class}).qualifiers(new Annotation[]{new ByIdLiteral(idValue)}).beanLifecycle((ContextualLifecycle)new PersonContextualLifecycle(idValue));
            abd.addBean(beanBuilder.create());
        }
    }
}

