/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstart.xml;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.List;
import javax.inject.Inject;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.jboss.as.quickstart.xml.Book;
import org.jboss.as.quickstart.xml.Errors;
import org.jboss.as.quickstart.xml.Resources;

public abstract class XMLParser {
    @Inject
    private Errors errorHolder;

    public List<Book> parse(InputStream is) throws Exception {
        StringBuilder xmlFile = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(is));
        String line = null;
        while ((line = bufferedReader.readLine()) != null) {
            xmlFile.append(line);
        }
        String xml = xmlFile.toString();
        try {
            URL schema = Resources.getResource((String)"/catalog.xsd");
            Validator validator = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schema).newValidator();
            StreamSource source = new StreamSource(new CharArrayReader(xml.toCharArray()));
            validator.validate(source);
        }
        catch (Exception e) {
            this.errorHolder.addErrorMessage("Validation Error", e);
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes());
        return this.parseInternal((InputStream)bais);
    }

    protected abstract List<Book> parseInternal(InputStream var1) throws Exception;
}

