/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.quickstart.xml.upload;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.jboss.as.quickstart.xml.upload.FileUploadBean;

@WebServlet(urlPatterns={"/upload"})
@MultipartConfig(maxFileSize=0x100000L)
public class FileUploadServlet
extends HttpServlet {
    private static final long serialVersionUID = 127759768859064589L;
    private static final Logger logger = Logger.getLogger(FileUploadServlet.class.getName());
    public static final String INPUT_NAME = "file";
    @Inject
    private FileUploadBean fileUploadBean;

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        RequestDispatcher rd;
        String reqContentType = req.getContentType();
        if (!reqContentType.contains("multipart/form-data")) {
            logger.severe("Received request which is not mulipart: " + reqContentType);
            resp.sendError(406, "Received request which is not mulipart: " + reqContentType);
            return;
        }
        Collection fileParts = req.getParts();
        if (fileParts != null && fileParts.size() > 0) {
            for (Part p : fileParts) {
                String partContentType = p.getContentType();
                String partName = p.getName();
                if (partContentType == null || !partContentType.equals("text/xml") || partName == null || !partName.equals(INPUT_NAME)) continue;
                InputStream is = p.getInputStream();
                this.fileUploadBean.parseUpload(is);
                break;
            }
        }
        if ((rd = this.getServletContext().getRequestDispatcher("/")) != null) {
            rd.forward((ServletRequest)req, (ServletResponse)resp);
            return;
        }
        throw new IllegalStateException("Container is not well!");
    }
}

