/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential._private;

import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import java.util.Locale;
import javax.security.sasl.SaslException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.security.credential._private.ElytronMessages;

public class ElytronMessages_$logger
extends DelegatingBasicLogger
implements ElytronMessages,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String emptyParameter = "ELY00002: Parameter %s is empty";
    private static final String unrecognizedAlgorithm = "ELY00004: Unrecognized algorithm \"%s\"";
    private static final String certificateChainIsEmpty = "ELY01037: Certificate chain is empty";
    private static final String mismatchedPublicPrivateKeyAlgorithms = "ELY01059: Public and private key algorithm names are mismatched";
    private static final String publicKeyIsNull = "ELY01061: Public key is null";
    private static final String privateKeyIsNull = "ELY01063: Private key is null";
    private static final String invalidKeyStoreEntryPassword = "ELY02001: Invalid key store entry password for alias \"%s\"";
    private static final String invalidKeyStoreEntryType = "ELY02002: Invalid key store entry type for alias \"%s\" (expected %s, got %s)";
    private static final String keyCannotBeProtected = "ELY02003: Key store key for alias \"%s\" cannot be protected";
    private static final String keyStoreFailedToTranslate = "ELY02004: Key store failed to translate password for alias \"%s\"";
    private static final String noAlgorithmForPassword = "ELY02005: Key store failed to identify a suitable algorithm for alias \"%s\"";
    private static final String unexpectedWhitespaceInPasswordFile = "ELY02006: Unexpected whitespace in password file";
    private static final String unexpectedEof = "ELY02007: Unexpected end of file";
    private static final String reversibleLoadNotPossible = "ELY02008: A reversible load is not possible until the KeyStore has first been initialized";
    private static final String unableToCreateKeyStore = "ELY02009: Unable to create a new KeyStore instance";
    private static final String emptyFilter = "ELY02012: An empty alias filter was supplied";
    private static final String missingPlusMinusAt = "ELY02013: Filter is missing '+' or '-' at offset %d";
    private static final String invalidFirstWord = "ELY02014: Invalid first word '%s', must be one of ALL/NONE";
    private static final String failedToObtainDirContext = "ELY02015: Failed to obtain DirContext";
    private static final String failedToReturnDirContext = "ELY02016: Failed to return DirContext";
    private static final String ldapKeyStoreFailedToObtainAlias = "ELY02017: LdapKeyStore failed to obtain alias [%s]";
    private static final String ldapKeyStoreFailedToObtainCertificate = "ELY02018: LdapKeyStore failed to obtain certificate [%s]";
    private static final String ldapKeyStoreFailedToObtainCertificateChain = "ELY02019: LdapKeyStore failed to obtain certificate chain [%s]";
    private static final String ldapKeyStoreFailedToObtainKey = "ELY02020: LdapKeyStore failed to recover key of alias [%s]";
    private static final String ldapKeyStoreFailedToObtainAliasByCertificate = "ELY02021: LdapKeyStore failed to obtain alias by certificate";
    private static final String ldapKeyStoreFailedToRecoverKey = "ELY02022: LdapKeyStore failed to recover key of alias [%s]";
    private static final String ldapKeyStoreFailedToObtainCreationDate = "ELY02023: LdapKeyStore failed to obtain creation date of alias [%s]";
    private static final String creationNotConfigured = "ELY02024: Alias [%s] does not exist in LdapKeyStore and not configured for creation";
    private static final String ldapKeyStoreFailedToStore = "ELY02025: LdapKeyStore failed store alias [%s]";
    private static final String ldapKeyStoreFailedToSerializeCertificate = "ELY02026: LdapKeyStore failed to serialize certificate of alias [%s]";
    private static final String ldapKeyStoreFailedToSerializeKey = "ELY02027: LdapKeyStore failed to protect (pack into keystore) key of alias [%s]";
    private static final String ldapKeyStoreFailedToDelete = "ELY02028: LdapKeyStore failed to delete alias [%s]";
    private static final String ldapKeyStoreFailedToDeleteNonExisting = "ELY02029: LdapKeyStore failed to delete alias [%s] - alias not found";
    private static final String ldapKeyStoreFailedToTestAliasExistence = "ELY02030: LdapKeyStore failed to test alias [%s] existence";
    private static final String ldapKeyStoreFailedToIterateAliases = "ELY02031: LdapKeyStore failed to iterate aliases";
    private static final String keySpecMustBeSecretKeySpec = "ELY02032: keySpec must be SecretKeySpect, given: [%s]";
    private static final String keyMustImplementSecretKeySpecAndKeySpecMustBeSecretKeySpec = "ELY02033: key must implement SecretKeySpec and keySpec must be SecretKeySpec, given key, keySpec: [%s]";
    private static final String keyStoreTypeNotDetected = "ELY02035: KeyStore type could not be detected";
    private static final String mechInvalidOTPAlgorithm = "ELY05151: Invalid OTP algorithm \"%s\"";
    private static final String invalidKeySpecUnrecognizedKeySpecAlgorithm = "ELY08001: Unrecognized key spec algorithm";
    private static final String invalidKeySpecPasswordSpecCannotBeRenderedAsString = "ELY08002: Password spec cannot be rendered as a string";
    private static final String invalidKeySpecUnknownCryptStringAlgorithm = "ELY08003: Unknown crypt string algorithm";
    private static final String invalidKeySpecInvalidCharacterEncountered = "ELY08004: Invalid character encountered";
    private static final String invalidKeySpecNoIterationCountTerminatorGiven = "ELY08005: No iteration count terminator given";
    private static final String invalidKeySpecUnexpectedEndOfInputString = "ELY08006: Unexpected end of input string";
    private static final String invalidKeySpecNoSaltTerminatorGiven = "ELY08007: No salt terminator given";
    private static final String invalidHashLength = "ELY08008: Invalid hash length";
    private static final String invalidKeySpecUnexpectedEndOfPasswordString = "ELY08009: Unexpected end of password string";
    private static final String invalidKeySpecUnexpectedEndOfPasswordStringWithCause = "ELY08010: Unexpected end of password string";
    private static final String invalidKeySpecInvalidMinorVersion = "ELY08011: Invalid minor version";
    private static final String invalidKeySpecCostMustBeTwoDigitInteger = "ELY08012: Invalid cost: must be a two digit integer";
    private static final String invalidKeySpecNoSuchMessageDigestAlgorithm = "ELY08013: No such MessageDigest algorithm for \"%s\"";
    private static final String invalidKeyNoSuchMessageDigestAlgorithm = "ELY08014: No such MessageDigest algorithm for \"%s\"";
    private static final String invalidKeyCannotVerifyPassword = "ELY08015: Cannot verify password";
    private static final String invalidKeyDesCryptPasswordHashMustBeBytes = "ELY08017: DES crypt password hash must be %d bytes";
    private static final String invalidParameterSpecSaltMustBeBytesBits = "ELY08018: Salt must be %d bytes (%d bits)";
    private static final String invalidNumberOfRoundsMustBeIntBetween = "ELY08020: Invalid number of rounds. Must be an integer between %d and %d, inclusive";
    private static final String invalidSaltMustBeBytesLong = "ELY08021: Invalid salt: must be %d bytes long";
    private static final String invalidKeySpecBsdDesCryptPasswordHashMustBeBytes = "ELY08022: BSD DES crypt password hash must be %d bytes";
    private static final String invalidParameterSpecSaltMustBeBytes = "ELY08023: Salt must be %d bytes";
    private static final String invalidKeyBsdDesCryptPasswordHashMustBeBytes = "ELY08024: BSD DES crypt password hash must be %d bytes";
    private static final String invalidKeySpecExpectedSpecGotSpec = "ELY08025: Expected to get a \"%s\" as spec, got \"%s\"";
    private static final String invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec = "ELY08026: Unknown algorithm or incompatible PasswordSpec";
    private static final String invalidKeyUnknownUnknownPasswordTypeOrAlgorithm = "ELY08027: Unknown password type or algorithm";
    private static final String noSuchAlgorithmInvalidAlgorithm = "ELY08028: Invalid algorithm \"%s\"";
    private static final String couldNotObtainKeySpecEncodingIdentifier = "ELY08029: Could not obtain key spec encoding identifier.";
    private static final String mismatchedPublicPrivateKeyParameters = "ELY09000: Public and private key parameters are mismatched";

    public ElytronMessages_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String emptyParameter$str() {
        return emptyParameter;
    }

    @Override
    public final IllegalArgumentException emptyParameter(String parameter) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.emptyParameter$str(), parameter));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unrecognizedAlgorithm$str() {
        return unrecognizedAlgorithm;
    }

    @Override
    public final IllegalArgumentException unrecognizedAlgorithm(String algorithm) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unrecognizedAlgorithm$str(), algorithm));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String certificateChainIsEmpty$str() {
        return certificateChainIsEmpty;
    }

    @Override
    public final IllegalArgumentException certificateChainIsEmpty() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.certificateChainIsEmpty$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mismatchedPublicPrivateKeyAlgorithms$str() {
        return mismatchedPublicPrivateKeyAlgorithms;
    }

    @Override
    public final IllegalArgumentException mismatchedPublicPrivateKeyAlgorithms() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.mismatchedPublicPrivateKeyAlgorithms$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String publicKeyIsNull$str() {
        return publicKeyIsNull;
    }

    @Override
    public final IllegalArgumentException publicKeyIsNull() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.publicKeyIsNull$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String privateKeyIsNull$str() {
        return privateKeyIsNull;
    }

    @Override
    public final IllegalArgumentException privateKeyIsNull() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.privateKeyIsNull$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeyStoreEntryPassword$str() {
        return invalidKeyStoreEntryPassword;
    }

    @Override
    public final UnrecoverableKeyException invalidKeyStoreEntryPassword(String alias) {
        UnrecoverableKeyException result = new UnrecoverableKeyException(String.format(this.getLoggingLocale(), this.invalidKeyStoreEntryPassword$str(), alias));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeyStoreEntryType$str() {
        return invalidKeyStoreEntryType;
    }

    @Override
    public final KeyStoreException invalidKeyStoreEntryType(String alias, Class<?> expectedClass, Class<?> actualClass) {
        KeyStoreException result = new KeyStoreException(String.format(this.getLoggingLocale(), this.invalidKeyStoreEntryType$str(), alias, expectedClass, actualClass));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String keyCannotBeProtected$str() {
        return keyCannotBeProtected;
    }

    @Override
    public final KeyStoreException keyCannotBeProtected(String alias) {
        KeyStoreException result = new KeyStoreException(String.format(this.getLoggingLocale(), this.keyCannotBeProtected$str(), alias));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String keyStoreFailedToTranslate$str() {
        return keyStoreFailedToTranslate;
    }

    @Override
    public final IOException keyStoreFailedToTranslate(String alias, Throwable cause) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.keyStoreFailedToTranslate$str(), alias), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noAlgorithmForPassword$str() {
        return noAlgorithmForPassword;
    }

    @Override
    public final NoSuchAlgorithmException noAlgorithmForPassword(String alias) {
        NoSuchAlgorithmException result = new NoSuchAlgorithmException(String.format(this.getLoggingLocale(), this.noAlgorithmForPassword$str(), alias));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unexpectedWhitespaceInPasswordFile$str() {
        return unexpectedWhitespaceInPasswordFile;
    }

    @Override
    public final IOException unexpectedWhitespaceInPasswordFile() {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.unexpectedWhitespaceInPasswordFile$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unexpectedEof$str() {
        return unexpectedEof;
    }

    @Override
    public final EOFException unexpectedEof() {
        EOFException result = new EOFException(String.format(this.getLoggingLocale(), this.unexpectedEof$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String reversibleLoadNotPossible$str() {
        return reversibleLoadNotPossible;
    }

    @Override
    public final IllegalStateException reversibleLoadNotPossible() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.reversibleLoadNotPossible$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToCreateKeyStore$str() {
        return unableToCreateKeyStore;
    }

    @Override
    public final IOException unableToCreateKeyStore(Exception cause) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.unableToCreateKeyStore$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String emptyFilter$str() {
        return emptyFilter;
    }

    @Override
    public final IllegalArgumentException emptyFilter() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.emptyFilter$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingPlusMinusAt$str() {
        return missingPlusMinusAt;
    }

    @Override
    public final IllegalArgumentException missingPlusMinusAt(long position) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.missingPlusMinusAt$str(), position));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidFirstWord$str() {
        return invalidFirstWord;
    }

    @Override
    public final IllegalArgumentException invalidFirstWord(String firstWord) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidFirstWord$str(), firstWord));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToObtainDirContext$str() {
        return failedToObtainDirContext;
    }

    @Override
    public final IllegalStateException failedToObtainDirContext(Throwable cause) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.failedToObtainDirContext$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToReturnDirContext$str() {
        return failedToReturnDirContext;
    }

    @Override
    public final IllegalStateException failedToReturnDirContext(Throwable cause) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.failedToReturnDirContext$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ldapKeyStoreFailedToObtainAlias$str() {
        return ldapKeyStoreFailedToObtainAlias;
    }

    @Override
    public final IllegalStateException ldapKeyStoreFailedToObtainAlias(String alias, Throwable cause) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.ldapKeyStoreFailedToObtainAlias$str(), alias), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ldapKeyStoreFailedToObtainCertificate$str() {
        return ldapKeyStoreFailedToObtainCertificate;
    }

    @Override
    public final IllegalStateException ldapKeyStoreFailedToObtainCertificate(String alias, Throwable cause) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.ldapKeyStoreFailedToObtainCertificate$str(), alias), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ldapKeyStoreFailedToObtainCertificateChain$str() {
        return ldapKeyStoreFailedToObtainCertificateChain;
    }

    @Override
    public final IllegalStateException ldapKeyStoreFailedToObtainCertificateChain(String alias, Throwable cause) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.ldapKeyStoreFailedToObtainCertificateChain$str(), alias), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ldapKeyStoreFailedToObtainKey$str() {
        return ldapKeyStoreFailedToObtainKey;
    }

    @Override
    public final IllegalStateException ldapKeyStoreFailedToObtainKey(String alias, Throwable cause) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.ldapKeyStoreFailedToObtainKey$str(), alias), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ldapKeyStoreFailedToObtainAliasByCertificate$str() {
        return ldapKeyStoreFailedToObtainAliasByCertificate;
    }

    @Override
    public final IllegalStateException ldapKeyStoreFailedToObtainAliasByCertificate(Throwable cause) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.ldapKeyStoreFailedToObtainAliasByCertificate$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ldapKeyStoreFailedToRecoverKey$str() {
        return ldapKeyStoreFailedToRecoverKey;
    }

    @Override
    public final UnrecoverableKeyException ldapKeyStoreFailedToRecoverKey(String alias, Throwable cause) {
        UnrecoverableKeyException result = new UnrecoverableKeyException(String.format(this.getLoggingLocale(), this.ldapKeyStoreFailedToRecoverKey$str(), alias));
        result.initCause(cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ldapKeyStoreFailedToObtainCreationDate$str() {
        return ldapKeyStoreFailedToObtainCreationDate;
    }

    @Override
    public final IllegalStateException ldapKeyStoreFailedToObtainCreationDate(String alias, Throwable cause) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.ldapKeyStoreFailedToObtainCreationDate$str(), alias), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String creationNotConfigured$str() {
        return creationNotConfigured;
    }

    @Override
    public final KeyStoreException creationNotConfigured(String alias) {
        KeyStoreException result = new KeyStoreException(String.format(this.getLoggingLocale(), this.creationNotConfigured$str(), alias));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ldapKeyStoreFailedToStore$str() {
        return ldapKeyStoreFailedToStore;
    }

    @Override
    public final KeyStoreException ldapKeyStoreFailedToStore(String alias, Throwable cause) {
        KeyStoreException result = new KeyStoreException(String.format(this.getLoggingLocale(), this.ldapKeyStoreFailedToStore$str(), alias), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ldapKeyStoreFailedToSerializeCertificate$str() {
        return ldapKeyStoreFailedToSerializeCertificate;
    }

    @Override
    public final KeyStoreException ldapKeyStoreFailedToSerializeCertificate(String alias, Throwable cause) {
        KeyStoreException result = new KeyStoreException(String.format(this.getLoggingLocale(), this.ldapKeyStoreFailedToSerializeCertificate$str(), alias), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ldapKeyStoreFailedToSerializeKey$str() {
        return ldapKeyStoreFailedToSerializeKey;
    }

    @Override
    public final KeyStoreException ldapKeyStoreFailedToSerializeKey(String alias, Throwable cause) {
        KeyStoreException result = new KeyStoreException(String.format(this.getLoggingLocale(), this.ldapKeyStoreFailedToSerializeKey$str(), alias), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ldapKeyStoreFailedToDelete$str() {
        return ldapKeyStoreFailedToDelete;
    }

    @Override
    public final KeyStoreException ldapKeyStoreFailedToDelete(String alias, Throwable cause) {
        KeyStoreException result = new KeyStoreException(String.format(this.getLoggingLocale(), this.ldapKeyStoreFailedToDelete$str(), alias), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ldapKeyStoreFailedToDeleteNonExisting$str() {
        return ldapKeyStoreFailedToDeleteNonExisting;
    }

    @Override
    public final KeyStoreException ldapKeyStoreFailedToDeleteNonExisting(String alias) {
        KeyStoreException result = new KeyStoreException(String.format(this.getLoggingLocale(), this.ldapKeyStoreFailedToDeleteNonExisting$str(), alias));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ldapKeyStoreFailedToTestAliasExistence$str() {
        return ldapKeyStoreFailedToTestAliasExistence;
    }

    @Override
    public final IllegalStateException ldapKeyStoreFailedToTestAliasExistence(String alias, Throwable cause) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.ldapKeyStoreFailedToTestAliasExistence$str(), alias), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ldapKeyStoreFailedToIterateAliases$str() {
        return ldapKeyStoreFailedToIterateAliases;
    }

    @Override
    public final IllegalStateException ldapKeyStoreFailedToIterateAliases(Throwable cause) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.ldapKeyStoreFailedToIterateAliases$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String keySpecMustBeSecretKeySpec$str() {
        return keySpecMustBeSecretKeySpec;
    }

    @Override
    public final InvalidKeySpecException keySpecMustBeSecretKeySpec(String type) {
        InvalidKeySpecException result = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.keySpecMustBeSecretKeySpec$str(), type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String keyMustImplementSecretKeySpecAndKeySpecMustBeSecretKeySpec$str() {
        return keyMustImplementSecretKeySpecAndKeySpecMustBeSecretKeySpec;
    }

    @Override
    public final InvalidKeySpecException keyMustImplementSecretKeySpecAndKeySpecMustBeSecretKeySpec(String keyAndKeySpec) {
        InvalidKeySpecException result = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.keyMustImplementSecretKeySpecAndKeySpecMustBeSecretKeySpec$str(), keyAndKeySpec));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String keyStoreTypeNotDetected$str() {
        return keyStoreTypeNotDetected;
    }

    @Override
    public final KeyStoreException keyStoreTypeNotDetected() {
        KeyStoreException result = new KeyStoreException(String.format(this.getLoggingLocale(), this.keyStoreTypeNotDetected$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechInvalidOTPAlgorithm$str() {
        return mechInvalidOTPAlgorithm;
    }

    @Override
    public final SaslException mechInvalidOTPAlgorithm(String algorithm) {
        SaslException result = new SaslException(String.format(this.getLoggingLocale(), this.mechInvalidOTPAlgorithm$str(), algorithm));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeySpecUnrecognizedKeySpecAlgorithm$str() {
        return invalidKeySpecUnrecognizedKeySpecAlgorithm;
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecUnrecognizedKeySpecAlgorithm() {
        InvalidKeySpecException result = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecUnrecognizedKeySpecAlgorithm$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeySpecPasswordSpecCannotBeRenderedAsString$str() {
        return invalidKeySpecPasswordSpecCannotBeRenderedAsString;
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecPasswordSpecCannotBeRenderedAsString() {
        InvalidKeySpecException result = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecPasswordSpecCannotBeRenderedAsString$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeySpecUnknownCryptStringAlgorithm$str() {
        return invalidKeySpecUnknownCryptStringAlgorithm;
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecUnknownCryptStringAlgorithm() {
        InvalidKeySpecException result = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecUnknownCryptStringAlgorithm$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeySpecInvalidCharacterEncountered$str() {
        return invalidKeySpecInvalidCharacterEncountered;
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecInvalidCharacterEncountered() {
        InvalidKeySpecException result = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecInvalidCharacterEncountered$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeySpecNoIterationCountTerminatorGiven$str() {
        return invalidKeySpecNoIterationCountTerminatorGiven;
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecNoIterationCountTerminatorGiven() {
        InvalidKeySpecException result = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecNoIterationCountTerminatorGiven$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeySpecUnexpectedEndOfInputString$str() {
        return invalidKeySpecUnexpectedEndOfInputString;
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecUnexpectedEndOfInputString() {
        InvalidKeySpecException result = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecUnexpectedEndOfInputString$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeySpecNoSaltTerminatorGiven$str() {
        return invalidKeySpecNoSaltTerminatorGiven;
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecNoSaltTerminatorGiven() {
        InvalidKeySpecException result = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecNoSaltTerminatorGiven$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidHashLength$str() {
        return invalidHashLength;
    }

    @Override
    public final IllegalArgumentException invalidHashLength() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidHashLength$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeySpecUnexpectedEndOfPasswordString$str() {
        return invalidKeySpecUnexpectedEndOfPasswordString;
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecUnexpectedEndOfPasswordString() {
        InvalidKeySpecException result = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecUnexpectedEndOfPasswordString$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeySpecUnexpectedEndOfPasswordStringWithCause$str() {
        return invalidKeySpecUnexpectedEndOfPasswordStringWithCause;
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecUnexpectedEndOfPasswordStringWithCause(Throwable cause) {
        InvalidKeySpecException result = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecUnexpectedEndOfPasswordStringWithCause$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeySpecInvalidMinorVersion$str() {
        return invalidKeySpecInvalidMinorVersion;
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecInvalidMinorVersion() {
        InvalidKeySpecException result = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecInvalidMinorVersion$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeySpecCostMustBeTwoDigitInteger$str() {
        return invalidKeySpecCostMustBeTwoDigitInteger;
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecCostMustBeTwoDigitInteger() {
        InvalidKeySpecException result = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecCostMustBeTwoDigitInteger$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeySpecNoSuchMessageDigestAlgorithm$str() {
        return invalidKeySpecNoSuchMessageDigestAlgorithm;
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecNoSuchMessageDigestAlgorithm(String algorithm) {
        InvalidKeySpecException result = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecNoSuchMessageDigestAlgorithm$str(), algorithm));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeyNoSuchMessageDigestAlgorithm$str() {
        return invalidKeyNoSuchMessageDigestAlgorithm;
    }

    @Override
    public final InvalidKeyException invalidKeyNoSuchMessageDigestAlgorithm(String algorithm) {
        InvalidKeyException result = new InvalidKeyException(String.format(this.getLoggingLocale(), this.invalidKeyNoSuchMessageDigestAlgorithm$str(), algorithm));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeyCannotVerifyPassword$str() {
        return invalidKeyCannotVerifyPassword;
    }

    @Override
    public final InvalidKeyException invalidKeyCannotVerifyPassword(Throwable cause) {
        InvalidKeyException result = new InvalidKeyException(String.format(this.getLoggingLocale(), this.invalidKeyCannotVerifyPassword$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeyDesCryptPasswordHashMustBeBytes$str() {
        return invalidKeyDesCryptPasswordHashMustBeBytes;
    }

    @Override
    public final InvalidKeyException invalidKeyDesCryptPasswordHashMustBeBytes(int bytes) {
        InvalidKeyException result = new InvalidKeyException(String.format(this.getLoggingLocale(), this.invalidKeyDesCryptPasswordHashMustBeBytes$str(), bytes));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidParameterSpecSaltMustBeBytesBits$str() {
        return invalidParameterSpecSaltMustBeBytesBits;
    }

    @Override
    public final InvalidParameterSpecException invalidParameterSpecSaltMustBeBytesBits(int bytes, int bits) {
        InvalidParameterSpecException result = new InvalidParameterSpecException(String.format(this.getLoggingLocale(), this.invalidParameterSpecSaltMustBeBytesBits$str(), bytes, bits));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidNumberOfRoundsMustBeIntBetween$str() {
        return invalidNumberOfRoundsMustBeIntBetween;
    }

    @Override
    public final IllegalArgumentException invalidNumberOfRoundsMustBeIntBetween(int min, int max) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidNumberOfRoundsMustBeIntBetween$str(), min, max));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidSaltMustBeBytesLong$str() {
        return invalidSaltMustBeBytesLong;
    }

    @Override
    public final IllegalArgumentException invalidSaltMustBeBytesLong(int length) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidSaltMustBeBytesLong$str(), length));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeySpecBsdDesCryptPasswordHashMustBeBytes$str() {
        return invalidKeySpecBsdDesCryptPasswordHashMustBeBytes;
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecBsdDesCryptPasswordHashMustBeBytes(int bytes) {
        InvalidKeySpecException result = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecBsdDesCryptPasswordHashMustBeBytes$str(), bytes));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidParameterSpecSaltMustBeBytes$str() {
        return invalidParameterSpecSaltMustBeBytes;
    }

    @Override
    public final InvalidParameterSpecException invalidParameterSpecSaltMustBeBytes(int bytes) {
        InvalidParameterSpecException result = new InvalidParameterSpecException(String.format(this.getLoggingLocale(), this.invalidParameterSpecSaltMustBeBytes$str(), bytes));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeyBsdDesCryptPasswordHashMustBeBytes$str() {
        return invalidKeyBsdDesCryptPasswordHashMustBeBytes;
    }

    @Override
    public final InvalidKeyException invalidKeyBsdDesCryptPasswordHashMustBeBytes(int bytes) {
        InvalidKeyException result = new InvalidKeyException(String.format(this.getLoggingLocale(), this.invalidKeyBsdDesCryptPasswordHashMustBeBytes$str(), bytes));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeySpecExpectedSpecGotSpec$str() {
        return invalidKeySpecExpectedSpecGotSpec;
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecExpectedSpecGotSpec(String expected, String got) {
        InvalidKeySpecException result = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecExpectedSpecGotSpec$str(), expected, got));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec$str() {
        return invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec;
    }

    @Override
    public final InvalidKeySpecException invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec() {
        InvalidKeySpecException result = new InvalidKeySpecException(String.format(this.getLoggingLocale(), this.invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeyUnknownUnknownPasswordTypeOrAlgorithm$str() {
        return invalidKeyUnknownUnknownPasswordTypeOrAlgorithm;
    }

    @Override
    public final InvalidKeyException invalidKeyUnknownUnknownPasswordTypeOrAlgorithm() {
        InvalidKeyException result = new InvalidKeyException(String.format(this.getLoggingLocale(), this.invalidKeyUnknownUnknownPasswordTypeOrAlgorithm$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noSuchAlgorithmInvalidAlgorithm$str() {
        return noSuchAlgorithmInvalidAlgorithm;
    }

    @Override
    public final NoSuchAlgorithmException noSuchAlgorithmInvalidAlgorithm(String algorithm) {
        NoSuchAlgorithmException result = new NoSuchAlgorithmException(String.format(this.getLoggingLocale(), this.noSuchAlgorithmInvalidAlgorithm$str(), algorithm));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String couldNotObtainKeySpecEncodingIdentifier$str() {
        return couldNotObtainKeySpecEncodingIdentifier;
    }

    @Override
    public final IllegalArgumentException couldNotObtainKeySpecEncodingIdentifier() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.couldNotObtainKeySpecEncodingIdentifier$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mismatchedPublicPrivateKeyParameters$str() {
        return mismatchedPublicPrivateKeyParameters;
    }

    @Override
    public final IllegalArgumentException mismatchedPublicPrivateKeyParameters() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.mismatchedPublicPrivateKeyParameters$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

