/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.oidc;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.regex.Matcher;
import org.wildfly.security.http.oidc.AccessToken;
import org.wildfly.security.http.oidc.AuthChallenge;
import org.wildfly.security.http.oidc.AuthenticationError;
import org.wildfly.security.http.oidc.ElytronMessages;
import org.wildfly.security.http.oidc.Oidc;
import org.wildfly.security.http.oidc.OidcClientConfiguration;
import org.wildfly.security.http.oidc.OidcException;
import org.wildfly.security.http.oidc.OidcHttpFacade;
import org.wildfly.security.http.oidc.RealmAccessClaim;
import org.wildfly.security.http.oidc.TokenValidator;

class BearerTokenRequestAuthenticator {
    protected OidcHttpFacade facade;
    protected OidcClientConfiguration oidcClientConfiguration;
    protected AuthChallenge challenge;
    protected String tokenString;
    private AccessToken token;
    private String surrogate;

    public BearerTokenRequestAuthenticator(OidcHttpFacade facade, OidcClientConfiguration oidcClientConfiguration) {
        this.facade = facade;
        this.oidcClientConfiguration = oidcClientConfiguration;
    }

    public AuthChallenge getChallenge() {
        return this.challenge;
    }

    public String getTokenString() {
        return this.tokenString;
    }

    public AccessToken getToken() {
        return this.token;
    }

    public String getSurrogate() {
        return this.surrogate;
    }

    public Oidc.AuthOutcome authenticate() {
        List<String> authorizationValues = this.facade.getRequest().getHeaders("Authorization");
        if (authorizationValues == null || authorizationValues.isEmpty()) {
            this.challenge = this.challengeResponse(AuthenticationError.Reason.NO_BEARER_TOKEN, null, null);
            return Oidc.AuthOutcome.NOT_ATTEMPTED;
        }
        for (String authorizationValue : authorizationValues) {
            Matcher matcher = Oidc.BEARER_TOKEN_PATTERN.matcher(authorizationValue);
            if (!matcher.matches()) continue;
            this.tokenString = matcher.group(1);
            ElytronMessages.log.debugf("Found [%d] values in authorization header, selecting the first value for Bearer", authorizationValues.size());
            break;
        }
        if (this.tokenString == null) {
            this.challenge = this.challengeResponse(AuthenticationError.Reason.NO_BEARER_TOKEN, null, null);
            return Oidc.AuthOutcome.NOT_ATTEMPTED;
        }
        return this.verifyToken(this.tokenString);
    }

    protected Oidc.AuthOutcome verifyToken(String tokenString) {
        ElytronMessages.log.debug("Verifying access_token");
        Oidc.logToken("\taccess_token", tokenString);
        try {
            TokenValidator tokenValidator = TokenValidator.builder(this.oidcClientConfiguration).build();
            this.token = tokenValidator.parseAndVerifyToken(tokenString);
            ElytronMessages.log.debug("Token Verification succeeded!");
        }
        catch (OidcException e) {
            ElytronMessages.log.failedVerificationOfToken(e.getMessage());
            this.challenge = this.challengeResponse(AuthenticationError.Reason.INVALID_TOKEN, "invalid_token", e.getMessage());
            return Oidc.AuthOutcome.FAILED;
        }
        if (this.token.getIssuedAt() < (long)this.oidcClientConfiguration.getNotBefore()) {
            ElytronMessages.log.debug("Stale token");
            this.challenge = this.challengeResponse(AuthenticationError.Reason.STALE_TOKEN, "invalid_token", "Stale token");
            return Oidc.AuthOutcome.FAILED;
        }
        boolean verifyCaller = this.oidcClientConfiguration.isUseResourceRoleMappings() ? this.isVerifyCaller(this.token.getResourceAccessClaim(this.oidcClientConfiguration.getResourceName())) : this.isVerifyCaller(this.token.getRealmAccessClaim());
        if (verifyCaller) {
            List<String> trustedCerts = this.token.getTrustedCertsClaim();
            if (trustedCerts == null || trustedCerts.isEmpty()) {
                ElytronMessages.log.noTrustedCertificatesInToken();
                this.challenge = this.clientCertChallenge();
                return Oidc.AuthOutcome.FAILED;
            }
            Certificate[] chain = this.facade.getCertificateChain();
            if (chain == null || chain.length == 0) {
                ElytronMessages.log.noPeerCertificatesEstablishedOnConnection();
                this.challenge = this.clientCertChallenge();
                return Oidc.AuthOutcome.FAILED;
            }
            this.surrogate = ((X509Certificate)chain[0]).getSubjectDN().getName();
        }
        ElytronMessages.log.debug("Successfully authorized");
        return Oidc.AuthOutcome.AUTHENTICATED;
    }

    private boolean isVerifyCaller(RealmAccessClaim accessClaim) {
        if (accessClaim != null && accessClaim.getVerifyCaller() != null) {
            return accessClaim.getVerifyCaller();
        }
        return false;
    }

    protected AuthChallenge challengeResponse(final AuthenticationError.Reason reason, String error, final String description) {
        StringBuilder header = new StringBuilder("Bearer");
        if (this.oidcClientConfiguration.getRealm() != null) {
            header.append(" ").append("realm").append("=\"").append(this.oidcClientConfiguration.getRealm()).append("\"");
            if (error != null || description != null) {
                header.append(",");
            }
        }
        if (error != null) {
            header.append(" ").append("error").append("=\"").append(error).append("\"");
            if (description != null) {
                header.append(",");
            }
        }
        if (description != null) {
            header.append(" ").append("error_description").append("=\"").append(description).append("\"");
        }
        final String challenge = header.toString();
        return new AuthChallenge(){

            @Override
            public int getResponseCode() {
                return 401;
            }

            @Override
            public boolean challenge(OidcHttpFacade facade) {
                AuthenticationError error = new AuthenticationError(reason, description);
                facade.getRequest().setError(error);
                facade.getResponse().addHeader("WWW-Authenticate", challenge);
                if (BearerTokenRequestAuthenticator.this.oidcClientConfiguration.isDelegateBearerErrorResponseSending()) {
                    facade.getResponse().setStatus(401);
                } else {
                    facade.getResponse().sendError(401);
                }
                return true;
            }
        };
    }

    protected AuthChallenge clientCertChallenge() {
        return new AuthChallenge(){

            @Override
            public int getResponseCode() {
                return 0;
            }

            @Override
            public boolean challenge(OidcHttpFacade facade) {
                return false;
            }
        };
    }
}

