package org.wildfly.security.mechanism._private;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.wildfly.security.mechanism.ScramServerException;
import org.jboss.logging.DelegatingBasicLogger;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.asn1.ASN1Exception;
import java.lang.NumberFormatException;
import java.lang.SecurityException;
import java.lang.String;
import org.jboss.logging.Logger;
import org.wildfly.security.mechanism.ScramServerErrorCode;
import java.lang.Exception;
import java.lang.RuntimeException;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.util.Arrays;
import java.lang.IllegalArgumentException;
import org.wildfly.security.mechanism.AuthenticationMechanismException;


import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2020-07-10T09:15:17-0400")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void credentialDestroyingFailed(final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, credentialDestroyingFailed$str());
    }
    protected String credentialDestroyingFailed$str() {
        return "ELY00007: Credential destroying failed";
    }
    protected String authenticationFailedEvidenceVerification$str() {
        return "ELY01151: Evidence Verification Failed.";
    }
    @Override
    public final SecurityException authenticationFailedEvidenceVerification() {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), authenticationFailedEvidenceVerification$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String mechMessageAfterComplete$str() {
        return "ELY05001: Authentication mechanism exchange received a message after authentication was already complete";
    }
    @Override
    public final AuthenticationMechanismException mechMessageAfterComplete() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechMessageAfterComplete$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechUserNameContainsInvalidCharacter$str() {
        return "ELY05002: Authentication mechanism user name contains an invalid or disallowed character";
    }
    @Override
    public final AuthenticationMechanismException mechUserNameContainsInvalidCharacter() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUserNameContainsInvalidCharacter$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechAuthorizationFailed0$str() {
        return "ELY05004: Authentication mechanism authorization failed";
    }
    @Override
    public final AuthenticationMechanismException mechAuthorizationFailed(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechAuthorizationFailed0$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechAuthenticationNotComplete$str() {
        return "ELY05005: Authentication mechanism authentication is not yet complete";
    }
    @Override
    public final IllegalStateException mechAuthenticationNotComplete() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), mechAuthenticationNotComplete$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechNoSecurityLayer$str() {
        return "ELY05006: Authentication mechanism does not support security layer (wrapping/unwrapping)";
    }
    @Override
    public final IllegalStateException mechNoSecurityLayer() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), mechNoSecurityLayer$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechInvalidMessageReceived$str() {
        return "ELY05007: Invalid authentication mechanism negotiation message received";
    }
    @Override
    public final AuthenticationMechanismException mechInvalidMessageReceived() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechInvalidMessageReceived$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechNoLoginNameGiven$str() {
        return "ELY05008: No authentication mechanism login name was given";
    }
    @Override
    public final AuthenticationMechanismException mechNoLoginNameGiven() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechNoLoginNameGiven$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechNoPasswordGiven$str() {
        return "ELY05009: No authentication mechanism password was given";
    }
    @Override
    public final AuthenticationMechanismException mechNoPasswordGiven() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechNoPasswordGiven$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechMalformedFields$str() {
        return "ELY05010: Authentication mechanism authentication failed due to one or more malformed fields";
    }
    @Override
    public final AuthenticationMechanismException mechMalformedFields(final IllegalArgumentException ex) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechMalformedFields$str()), ex);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechMessageTooLong$str() {
        return "ELY05011: Authentication mechanism message is too long";
    }
    @Override
    public final AuthenticationMechanismException mechMessageTooLong() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechMessageTooLong$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechServerSideAuthenticationFailed$str() {
        return "ELY05012: Authentication mechanism server-side authentication failed";
    }
    @Override
    public final AuthenticationMechanismException mechServerSideAuthenticationFailed(final Exception e) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechServerSideAuthenticationFailed$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechPasswordNotVerified$str() {
        return "ELY05013: Authentication mechanism password not verified";
    }
    @Override
    public final AuthenticationMechanismException mechPasswordNotVerified() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechPasswordNotVerified$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechAuthorizationFailed2$str() {
        return "ELY05014: Authentication mechanism authorization failed: \"%s\" running as \"%s\"";
    }
    @Override
    public final AuthenticationMechanismException mechAuthorizationFailed(final String userName, final String authorizationId) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechAuthorizationFailed2$str(), userName, authorizationId));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechChannelBindingChanged$str() {
        return "ELY05018: Channel binding data changed";
    }
    @Override
    public final AuthenticationMechanismException mechChannelBindingChanged() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechChannelBindingChanged$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechNoTokenGiven$str() {
        return "ELY05019: No token was given";
    }
    @Override
    public final AuthenticationMechanismException mechNoTokenGiven() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechNoTokenGiven$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechInitialChallengeMustBeEmpty$str() {
        return "ELY05022: Initial challenge must be empty";
    }
    @Override
    public final AuthenticationMechanismException mechInitialChallengeMustBeEmpty() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechInitialChallengeMustBeEmpty$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechUnableToSetChannelBinding$str() {
        return "ELY05023: Unable to set channel binding";
    }
    @Override
    public final AuthenticationMechanismException mechUnableToSetChannelBinding(final Exception e) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnableToSetChannelBinding$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechFailedToDetermineChannelBindingStatus$str() {
        return "ELY05024: Failed to determine channel binding status";
    }
    @Override
    public final AuthenticationMechanismException mechFailedToDetermineChannelBindingStatus(final Exception e) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechFailedToDetermineChannelBindingStatus$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechMutualAuthenticationNotEnabled$str() {
        return "ELY05025: Mutual authentication not enabled";
    }
    @Override
    public final AuthenticationMechanismException mechMutualAuthenticationNotEnabled() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechMutualAuthenticationNotEnabled$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechMechanismToOidMappingFailed$str() {
        return "ELY05026: Unable to map SASL mechanism name to a GSS-API OID";
    }
    @Override
    public final AuthenticationMechanismException mechMechanismToOidMappingFailed(final Exception e) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechMechanismToOidMappingFailed$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechUnableToDisposeGssContext$str() {
        return "ELY05027: Unable to dispose of GSSContext";
    }
    @Override
    public final AuthenticationMechanismException mechUnableToDisposeGssContext(final Exception e) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnableToDisposeGssContext$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechUnableToCreateNameForAcceptor$str() {
        return "ELY05028: Unable to create name for acceptor";
    }
    @Override
    public final AuthenticationMechanismException mechUnableToCreateNameForAcceptor(final Exception e) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnableToCreateNameForAcceptor$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechUnableToCreateGssContext$str() {
        return "ELY05029: Unable to create GSSContext";
    }
    @Override
    public final AuthenticationMechanismException mechUnableToCreateGssContext(final Exception e) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnableToCreateGssContext$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechUnableToSetGssContextRequestFlags$str() {
        return "ELY05030: Unable to set GSSContext request flags";
    }
    @Override
    public final AuthenticationMechanismException mechUnableToSetGssContextRequestFlags(final Exception e) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnableToSetGssContextRequestFlags$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechUnableToAcceptClientMessage$str() {
        return "ELY05031: Unable to accept SASL client message";
    }
    @Override
    public final AuthenticationMechanismException mechUnableToAcceptClientMessage(final Exception e) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnableToAcceptClientMessage$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechGssApiMechanismMismatch$str() {
        return "ELY05032: GSS-API mechanism mismatch between SASL client and server";
    }
    @Override
    public final AuthenticationMechanismException mechGssApiMechanismMismatch() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechGssApiMechanismMismatch$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechChannelBindingNotSupported$str() {
        return "ELY05033: Channel binding not supported for this SASL mechanism";
    }
    @Override
    public final AuthenticationMechanismException mechChannelBindingNotSupported() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechChannelBindingNotSupported$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechChannelBindingTypeMismatch$str() {
        return "ELY05034: Channel binding type mismatch between SASL client and server";
    }
    @Override
    public final AuthenticationMechanismException mechChannelBindingTypeMismatch() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechChannelBindingTypeMismatch$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechChannelBindingNotProvided$str() {
        return "ELY05035: Channel binding not provided by client";
    }
    @Override
    public final AuthenticationMechanismException mechChannelBindingNotProvided() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechChannelBindingNotProvided$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechUnableToDeterminePeerName$str() {
        return "ELY05036: Unable to determine peer name";
    }
    @Override
    public final AuthenticationMechanismException mechUnableToDeterminePeerName(final Exception e) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnableToDeterminePeerName$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechClientRefusesToInitiateAuthentication$str() {
        return "ELY05037: Authentication mechanism client refuses to initiate authentication";
    }
    @Override
    public final AuthenticationMechanismException mechClientRefusesToInitiateAuthentication() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechClientRefusesToInitiateAuthentication$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechNoncesDoNotMatch$str() {
        return "ELY05038: Nonces do not match";
    }
    @Override
    public final AuthenticationMechanismException mechNoncesDoNotMatch() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechNoncesDoNotMatch$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidNonceLength$str() {
        return "ELY05039: Invalid length of nonce received";
    }
    @Override
    public final AuthenticationMechanismException invalidNonceLength() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), invalidNonceLength$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechIterationCountIsTooLow$str() {
        return "ELY05040: Iteration count %d is below the minimum of %d";
    }
    @Override
    public final AuthenticationMechanismException mechIterationCountIsTooLow(final int iterationCount, final int minimumIterationCount) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechIterationCountIsTooLow$str(), iterationCount, minimumIterationCount));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechIterationCountIsTooHigh$str() {
        return "ELY05041: Iteration count %d is above the maximum of %d";
    }
    @Override
    public final AuthenticationMechanismException mechIterationCountIsTooHigh(final int iterationCount, final int maximumIterationCount) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechIterationCountIsTooHigh$str(), iterationCount, maximumIterationCount));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechInvalidServerMessage$str() {
        return "ELY05043: Invalid server message";
    }
    @Override
    public final AuthenticationMechanismException mechInvalidServerMessage() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechInvalidServerMessage$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechInvalidServerMessageWithCause$str() {
        return "ELY05044: Invalid server message";
    }
    @Override
    public final AuthenticationMechanismException mechInvalidServerMessageWithCause(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechInvalidServerMessageWithCause$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechInvalidClientMessage$str() {
        return "ELY05045: Invalid client message";
    }
    @Override
    public final AuthenticationMechanismException mechInvalidClientMessage() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechInvalidClientMessage$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechInvalidClientMessageWithCause$str() {
        return "ELY05046: Invalid client message";
    }
    @Override
    public final AuthenticationMechanismException mechInvalidClientMessageWithCause(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechInvalidClientMessageWithCause$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechUnmatchedMechanism$str() {
        return "ELY05047: [%s] Authentication mechanism message is for mismatched mechanism \"%s\"";
    }
    @Override
    public final AuthenticationMechanismException mechUnmatchedMechanism(final String mechName, final String otherMechName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnmatchedMechanism$str(), mechName, otherMechName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechServerAuthenticityCannotBeVerified$str() {
        return "ELY05049: Server authenticity cannot be verified";
    }
    @Override
    public final AuthenticationMechanismException mechServerAuthenticityCannotBeVerified() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechServerAuthenticityCannotBeVerified$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechCallbackHandlerDoesNotSupportUserName$str() {
        return "ELY05050: Callback handler does not support user name";
    }
    @Override
    public final AuthenticationMechanismException mechCallbackHandlerDoesNotSupportUserName(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechCallbackHandlerDoesNotSupportUserName$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechCallbackHandlerDoesNotSupportCredentialAcquisition$str() {
        return "ELY05051: Callback handler does not support credential acquisition";
    }
    @Override
    public final AuthenticationMechanismException mechCallbackHandlerDoesNotSupportCredentialAcquisition(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechCallbackHandlerDoesNotSupportCredentialAcquisition$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechAuthorizationUnsupported$str() {
        return "ELY05052: Callback handler does not support authorization";
    }
    @Override
    public final AuthenticationMechanismException mechAuthorizationUnsupported(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechAuthorizationUnsupported$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechCallbackHandlerFailedForUnknownReason$str() {
        return "ELY05053: Callback handler failed for unknown reason";
    }
    @Override
    public final AuthenticationMechanismException mechCallbackHandlerFailedForUnknownReason(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechCallbackHandlerFailedForUnknownReason$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechAuthenticationRejectedInvalidProof$str() {
        return "ELY05055: Authentication rejected (invalid proof)";
    }
    @Override
    public final AuthenticationMechanismException mechAuthenticationRejectedInvalidProof() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechAuthenticationRejectedInvalidProof$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechClientSentExtraMessage$str() {
        return "ELY05056: Client sent extra message";
    }
    @Override
    public final AuthenticationMechanismException mechClientSentExtraMessage() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechClientSentExtraMessage$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechServerSentExtraMessage$str() {
        return "ELY05057: Server sent extra message";
    }
    @Override
    public final AuthenticationMechanismException mechServerSentExtraMessage() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechServerSentExtraMessage$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechAuthenticationFailed$str() {
        return "ELY05058: Authentication failed";
    }
    @Override
    public final AuthenticationMechanismException mechAuthenticationFailed() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechAuthenticationFailed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String emptyNumber$str() {
        return "ELY05060: Empty number";
    }
    @Override
    public final NumberFormatException emptyNumber() {
        final NumberFormatException result = new NumberFormatException(String.format(getLoggingLocale(), emptyNumber$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidNumericCharacter$str() {
        return "ELY05061: Invalid numeric character";
    }
    @Override
    public final NumberFormatException invalidNumericCharacter() {
        final NumberFormatException result = new NumberFormatException(String.format(getLoggingLocale(), invalidNumericCharacter$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String tooBigNumber$str() {
        return "ELY05062: Too big number";
    }
    @Override
    public final NumberFormatException tooBigNumber() {
        final NumberFormatException result = new NumberFormatException(String.format(getLoggingLocale(), tooBigNumber$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechCannotGetTwoWayPasswordChars$str() {
        return "ELY05063: Cannot get clear password from two way password";
    }
    @Override
    public final AuthenticationMechanismException mechCannotGetTwoWayPasswordChars(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechCannotGetTwoWayPasswordChars$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechMacAlgorithmNotSupported$str() {
        return "ELY05064: Hashing algorithm not supported";
    }
    @Override
    public final AuthenticationMechanismException mechMacAlgorithmNotSupported(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechMacAlgorithmNotSupported$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechKeywordCannotBeEmpty$str() {
        return "ELY05065: keyword cannot be empty";
    }
    @Override
    public final AuthenticationMechanismException mechKeywordCannotBeEmpty() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechKeywordCannotBeEmpty$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechNoValueFoundForKeyword$str() {
        return "ELY05066: No value found for keyword: %s";
    }
    @Override
    public final AuthenticationMechanismException mechNoValueFoundForKeyword(final String keyword) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechNoValueFoundForKeyword$str(), keyword));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechKeywordNotFollowedByEqual$str() {
        return "ELY05067: '=' expected after keyword: %s";
    }
    @Override
    public final AuthenticationMechanismException mechKeywordNotFollowedByEqual(final String keyword) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechKeywordNotFollowedByEqual$str(), keyword));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechUnmatchedQuoteFoundForValue$str() {
        return "ELY05068: Unmatched quote found for value: %s";
    }
    @Override
    public final AuthenticationMechanismException mechUnmatchedQuoteFoundForValue(final String value) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnmatchedQuoteFoundForValue$str(), value));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechExpectingCommaOrLinearWhitespaceAfterQuoted$str() {
        return "ELY05069: Expecting comma or linear whitespace after quoted string: %s";
    }
    @Override
    public final AuthenticationMechanismException mechExpectingCommaOrLinearWhitespaceAfterQuoted(final String value) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechExpectingCommaOrLinearWhitespaceAfterQuoted$str(), value));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechMessageTypeMustEqual$str() {
        return "ELY05070: MessageType must equal to %d, but it is %d";
    }
    @Override
    public final AuthenticationMechanismException mechMessageTypeMustEqual(final int expected, final int actual) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechMessageTypeMustEqual$str(), expected, actual));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechBadSequenceNumberWhileUnwrapping$str() {
        return "ELY05071: Bad sequence number while unwrapping: expected %d, but %d received";
    }
    @Override
    public final AuthenticationMechanismException mechBadSequenceNumberWhileUnwrapping(final int expected, final int actual) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechBadSequenceNumberWhileUnwrapping$str(), expected, actual));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechProblemDuringCrypt$str() {
        return "ELY05072: Problem during crypt";
    }
    @Override
    public final AuthenticationMechanismException mechProblemDuringCrypt(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechProblemDuringCrypt$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechProblemDuringDecrypt$str() {
        return "ELY05073: Problem during decrypt";
    }
    @Override
    public final AuthenticationMechanismException mechProblemDuringDecrypt(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechProblemDuringDecrypt$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechUnknownCipher$str() {
        return "ELY05074: Unknown cipher \"%s\"";
    }
    @Override
    public final AuthenticationMechanismException mechUnknownCipher(final String cipher) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnknownCipher$str(), cipher));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechAuthorizationIdChanged$str() {
        return "ELY05075: Authorization ID changed unexpectedly";
    }
    @Override
    public final AuthenticationMechanismException mechAuthorizationIdChanged() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechAuthorizationIdChanged$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechProblemGettingRequiredCipher$str() {
        return "ELY05076: Problem getting required cipher. Check your transformation mapper settings.";
    }
    @Override
    public final AuthenticationMechanismException mechProblemGettingRequiredCipher(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechProblemGettingRequiredCipher$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechNoCommonProtectionLayer$str() {
        return "ELY05077: No common protection layer between client and server";
    }
    @Override
    public final AuthenticationMechanismException mechNoCommonProtectionLayer() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechNoCommonProtectionLayer$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechNoCommonCipher$str() {
        return "ELY05078: No common cipher between client and server";
    }
    @Override
    public final AuthenticationMechanismException mechNoCommonCipher() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechNoCommonCipher$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechNoCiphersOfferedByServer$str() {
        return "ELY05079: No ciphers offered by server";
    }
    @Override
    public final AuthenticationMechanismException mechNoCiphersOfferedByServer() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechNoCiphersOfferedByServer$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechNotProvidedUserName$str() {
        return "ELY05080: Callback handler not provided user name";
    }
    @Override
    public final AuthenticationMechanismException mechNotProvidedUserName() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechNotProvidedUserName$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechMissingDirective$str() {
        return "ELY05083: Missing \"%s\" directive";
    }
    @Override
    public final AuthenticationMechanismException mechMissingDirective(final String directive) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechMissingDirective$str(), directive));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechNonceCountMustEqual$str() {
        return "ELY05084: nonce-count must equal to %d, but it is %d";
    }
    @Override
    public final AuthenticationMechanismException mechNonceCountMustEqual(final int expected, final int actual) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechNonceCountMustEqual$str(), expected, actual));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechUnsupportedCharset$str() {
        return "ELY05085: Server is set to not support %s charset";
    }
    @Override
    public final AuthenticationMechanismException mechUnsupportedCharset(final String charset) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnsupportedCharset$str(), charset));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechUnknownCharset$str() {
        return "ELY05086: Charset can be only \"utf-8\" or unspecified (to use ISO 8859-1)";
    }
    @Override
    public final AuthenticationMechanismException mechUnknownCharset() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnknownCharset$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechDisallowedClientRealm$str() {
        return "ELY05087: Client selected realm not offered by server (%s)";
    }
    @Override
    public final AuthenticationMechanismException mechDisallowedClientRealm(final String clientRealm) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechDisallowedClientRealm$str(), clientRealm));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechMismatchedWrongDigestUri$str() {
        return "ELY05088: digest-uri \"%s\" not accepted";
    }
    @Override
    public final AuthenticationMechanismException mechMismatchedWrongDigestUri(final String actual) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechMismatchedWrongDigestUri$str(), actual));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechUnexpectedQop$str() {
        return "ELY05089: Unexpected qop value: \"%s\"";
    }
    @Override
    public final AuthenticationMechanismException mechUnexpectedQop(final String qop) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnexpectedQop$str(), qop));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String wrappingNotConfigured$str() {
        return "ELY05090: Wrapping is not configured";
    }
    @Override
    public final IllegalStateException wrappingNotConfigured() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), wrappingNotConfigured$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechAuthenticationNameTooLong$str() {
        return "ELY05091: Authentication name string is too long";
    }
    @Override
    public final AuthenticationMechanismException mechAuthenticationNameTooLong() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechAuthenticationNameTooLong$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechAuthenticationNameIsEmpty$str() {
        return "ELY05092: Authentication name is empty";
    }
    @Override
    public final AuthenticationMechanismException mechAuthenticationNameIsEmpty() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechAuthenticationNameIsEmpty$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechAnonymousAuthorizationDenied$str() {
        return "ELY05093: Authorization for anonymous access is denied";
    }
    @Override
    public final AuthenticationMechanismException mechAnonymousAuthorizationDenied() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechAnonymousAuthorizationDenied$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String requiredNegativePadding$str() {
        return "ELY05094: Required padded length (%d) is less than length of conversion result (%d)";
    }
    @Override
    public final IllegalArgumentException requiredNegativePadding(final int totalLength, final int hexLength) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), requiredNegativePadding$str(), totalLength, hexLength));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechInvalidKeyForDigestHMAC$str() {
        return "ELY05095: Invalid key provided for Digest HMAC computing";
    }
    @Override
    public final AuthenticationMechanismException mechInvalidKeyForDigestHMAC() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechInvalidKeyForDigestHMAC$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToDetermineSubjectName$str() {
        return "ELY05097: Unable to determine subject name from X.509 certificate";
    }
    @Override
    public final IllegalStateException unableToDetermineSubjectName(final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unableToDetermineSubjectName$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechUnableToVerifyClientSignature$str() {
        return "ELY05098: Unable to verify client signature";
    }
    @Override
    public final AuthenticationMechanismException mechUnableToVerifyClientSignature(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnableToVerifyClientSignature$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechUnableToVerifyServerSignature$str() {
        return "ELY05099: Unable to verify server signature";
    }
    @Override
    public final AuthenticationMechanismException mechUnableToVerifyServerSignature(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnableToVerifyServerSignature$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechCallbackHandlerNotProvidedServerCertificate$str() {
        return "ELY05101: Callback handler not provided server certificate";
    }
    @Override
    public final AuthenticationMechanismException mechCallbackHandlerNotProvidedServerCertificate() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechCallbackHandlerNotProvidedServerCertificate$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechCallbackHandlerNotProvidedClientCertificate$str() {
        return "ELY05102: Callback handler not provided client certificate";
    }
    @Override
    public final AuthenticationMechanismException mechCallbackHandlerNotProvidedClientCertificate() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechCallbackHandlerNotProvidedClientCertificate$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechServerIdentifierMismatch$str() {
        return "ELY05103: Server identifier mismatch";
    }
    @Override
    public final AuthenticationMechanismException mechServerIdentifierMismatch() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechServerIdentifierMismatch$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechClientIdentifierMismatch$str() {
        return "ELY05104: Client identifier mismatch";
    }
    @Override
    public final AuthenticationMechanismException mechClientIdentifierMismatch() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechClientIdentifierMismatch$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechUnableToDetermineClientName$str() {
        return "ELY05105: Unable to determine client name";
    }
    @Override
    public final AuthenticationMechanismException mechUnableToDetermineClientName(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnableToDetermineClientName$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechCallbackHandlerNotProvidedPrivateKey$str() {
        return "ELY05106: Callback handler not provided private key";
    }
    @Override
    public final AuthenticationMechanismException mechCallbackHandlerNotProvidedPrivateKey() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechCallbackHandlerNotProvidedPrivateKey$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechUnableToCreateSignature$str() {
        return "ELY05107: Unable to create signature";
    }
    @Override
    public final AuthenticationMechanismException mechUnableToCreateSignature(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnableToCreateSignature$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechUnableToCreateResponseToken$str() {
        return "ELY05108: Unable to create response token";
    }
    @Override
    public final AuthenticationMechanismException mechUnableToCreateResponseToken(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnableToCreateResponseToken$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechUnableToCreateResponseTokenWithCause$str() {
        return "ELY05109: Unable to create response token";
    }
    @Override
    public final AuthenticationMechanismException mechUnableToCreateResponseTokenWithCause(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnableToCreateResponseTokenWithCause$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechGettingSupportedMechanismsFailed$str() {
        return "ELY05112: Getting authentication mechanisms supported by GSS-API failed";
    }
    @Override
    public final AuthenticationMechanismException mechGettingSupportedMechanismsFailed(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechGettingSupportedMechanismsFailed$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToInitialiseOid$str() {
        return "ELY05113: Unable to initialize OID of Kerberos V5";
    }
    @Override
    public final RuntimeException unableToInitialiseOid(final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), unableToInitialiseOid$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechReceiveBufferIsGreaterThanMaximum$str() {
        return "ELY05114: Receive buffer requested '%d' is greater than supported maximum '%d'";
    }
    @Override
    public final AuthenticationMechanismException mechReceiveBufferIsGreaterThanMaximum(final int requested, final int maximum) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechReceiveBufferIsGreaterThanMaximum$str(), requested, maximum));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechUnableToWrapMessage$str() {
        return "ELY05115: Unable to wrap message";
    }
    @Override
    public final AuthenticationMechanismException mechUnableToWrapMessage(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnableToWrapMessage$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechUnableToUnwrapMessage$str() {
        return "ELY05116: Unable to unwrap message";
    }
    @Override
    public final AuthenticationMechanismException mechUnableToUnwrapMessage(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnableToUnwrapMessage$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechUnableToUnwrapSecurityLayerNegotiationMessage$str() {
        return "ELY05117: Unable to unwrap security layer negotiation message";
    }
    @Override
    public final AuthenticationMechanismException mechUnableToUnwrapSecurityLayerNegotiationMessage(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnableToUnwrapSecurityLayerNegotiationMessage$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechInvalidMessageOnUnwrapping$str() {
        return "ELY05118: Invalid message of length %d on unwrapping";
    }
    @Override
    public final AuthenticationMechanismException mechInvalidMessageOnUnwrapping(final int length) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechInvalidMessageOnUnwrapping$str(), length));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechNegotiatedMechanismWasNotKerberosV5$str() {
        return "ELY05119: Negotiated mechanism was not Kerberos V5";
    }
    @Override
    public final AuthenticationMechanismException mechNegotiatedMechanismWasNotKerberosV5() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechNegotiatedMechanismWasNotKerberosV5$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechInsufficientQopsAvailable$str() {
        return "ELY05120: Insufficient levels of protection available for supported security layers";
    }
    @Override
    public final AuthenticationMechanismException mechInsufficientQopsAvailable() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechInsufficientQopsAvailable$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechUnableToGenerateChallenge$str() {
        return "ELY05121: Unable to generate security layer challenge";
    }
    @Override
    public final AuthenticationMechanismException mechUnableToGenerateChallenge(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnableToGenerateChallenge$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechSelectedUnofferedQop$str() {
        return "ELY05122: Client selected a security layer that was not offered by server";
    }
    @Override
    public final AuthenticationMechanismException mechSelectedUnofferedQop() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechSelectedUnofferedQop$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechNoSecurityLayerButLengthReceived$str() {
        return "ELY05123: No security layer selected but message length received";
    }
    @Override
    public final AuthenticationMechanismException mechNoSecurityLayerButLengthReceived() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechNoSecurityLayerButLengthReceived$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechUnableToGetMaximumSizeOfMessage$str() {
        return "ELY05124: Unable to get maximum size of message before wrap";
    }
    @Override
    public final AuthenticationMechanismException mechUnableToGetMaximumSizeOfMessage(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnableToGetMaximumSizeOfMessage$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechUnableToHandleResponseFromServer$str() {
        return "ELY05125: Unable to handle response from server";
    }
    @Override
    public final AuthenticationMechanismException mechUnableToHandleResponseFromServer(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnableToHandleResponseFromServer$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechBadLengthOfMessageForNegotiatingSecurityLayer$str() {
        return "ELY05126: Bad length of message for negotiating security layer";
    }
    @Override
    public final AuthenticationMechanismException mechBadLengthOfMessageForNegotiatingSecurityLayer() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechBadLengthOfMessageForNegotiatingSecurityLayer$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechReceivedMaxMessageSizeWhenNoSecurityLayer$str() {
        return "ELY05127: No security layer supported by server but maximum message size received: \"%d\"";
    }
    @Override
    public final AuthenticationMechanismException mechReceivedMaxMessageSizeWhenNoSecurityLayer(final int length) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechReceivedMaxMessageSizeWhenNoSecurityLayer$str(), length));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechFailedToReadChallengeFile$str() {
        return "ELY05128: Failed to read challenge file";
    }
    @Override
    public final AuthenticationMechanismException mechFailedToReadChallengeFile(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechFailedToReadChallengeFile$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechFailedToCreateChallengeFile$str() {
        return "ELY05129: Failed to create challenge file";
    }
    @Override
    public final AuthenticationMechanismException mechFailedToCreateChallengeFile(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechFailedToCreateChallengeFile$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechAuthorizationIdTooLong$str() {
        return "ELY05150: Authentication mechanism authorization ID is too long";
    }
    @Override
    public final AuthenticationMechanismException mechAuthorizationIdTooLong() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechAuthorizationIdTooLong$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechInvalidOTPAlgorithm$str() {
        return "ELY05151: Invalid OTP algorithm \"%s\"";
    }
    @Override
    public final AuthenticationMechanismException mechInvalidOTPAlgorithm(final String algorithm) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechInvalidOTPAlgorithm$str(), algorithm));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechInvalidOTPResponseType$str() {
        return "ELY05152: Invalid OTP response type";
    }
    @Override
    public final AuthenticationMechanismException mechInvalidOTPResponseType() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechInvalidOTPResponseType$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechIncorrectParity$str() {
        return "ELY05153: Incorrect parity in SASL client message";
    }
    @Override
    public final AuthenticationMechanismException mechIncorrectParity() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechIncorrectParity$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechInvalidCharacterInSeed$str() {
        return "ELY05154: Invalid character in seed";
    }
    @Override
    public final AuthenticationMechanismException mechInvalidCharacterInSeed() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechInvalidCharacterInSeed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechInvalidOTPSeed$str() {
        return "ELY05155: Invalid OTP seed, must be between 1 and 16 characters long";
    }
    @Override
    public final AuthenticationMechanismException mechInvalidOTPSeed() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechInvalidOTPSeed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechInvalidOTPPassPhrase$str() {
        return "ELY05156: Invalid OTP pass phrase, must be between 10 and 63 characters long";
    }
    @Override
    public final AuthenticationMechanismException mechInvalidOTPPassPhrase() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechInvalidOTPPassPhrase$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechInvalidOTPSequenceNumber$str() {
        return "ELY05157: Invalid OTP sequence number";
    }
    @Override
    public final AuthenticationMechanismException mechInvalidOTPSequenceNumber() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechInvalidOTPSequenceNumber$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechInvalidOTP$str() {
        return "ELY05158: Invalid OTP";
    }
    @Override
    public final AuthenticationMechanismException mechInvalidOTP() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechInvalidOTP$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechOTPPassPhraseAndSeedMustNotMatch$str() {
        return "ELY05159: OTP pass phrase and seed must not match";
    }
    @Override
    public final AuthenticationMechanismException mechOTPPassPhraseAndSeedMustNotMatch() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechOTPPassPhraseAndSeedMustNotMatch$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechInvalidOTPAlternateDictionary$str() {
        return "ELY05160: Invalid OTP alternate dictionary";
    }
    @Override
    public final AuthenticationMechanismException mechInvalidOTPAlternateDictionary() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechInvalidOTPAlternateDictionary$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechUnableToRetrievePassword$str() {
        return "ELY05161: Unable to retrieve password for \"%s\"";
    }
    @Override
    public final AuthenticationMechanismException mechUnableToRetrievePassword(final String userName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnableToRetrievePassword$str(), userName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechUnableToUpdatePassword$str() {
        return "ELY05162: Unable to update password for \"%s\"";
    }
    @Override
    public final AuthenticationMechanismException mechUnableToUpdatePassword(final String userName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnableToUpdatePassword$str(), userName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechServerTimedOut$str() {
        return "ELY05163: Authentication mechanism server timed out";
    }
    @Override
    public final AuthenticationMechanismException mechServerTimedOut() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechServerTimedOut$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechUnableToObtainExclusiveAccess$str() {
        return "ELY05164: Unable to obtain exclusive access for \"%s\"";
    }
    @Override
    public final AuthenticationMechanismException mechUnableToObtainExclusiveAccess(final String userName) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnableToObtainExclusiveAccess$str(), userName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechOTPReinitializationFailed$str() {
        return "ELY05165: OTP re-initialization failed";
    }
    @Override
    public final AuthenticationMechanismException mechOTPReinitializationFailed(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechOTPReinitializationFailed$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String scramServerRejectedAuthentication$str() {
        return "ELY05166: Server rejected authentication";
    }
    @Override
    public final ScramServerException scramServerRejectedAuthentication(final ScramServerErrorCode errorCode) {
        final ScramServerException result = new ScramServerException(String.format(getLoggingLocale(), scramServerRejectedAuthentication$str()), errorCode);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechInvalidOTPPasswordFormatType$str() {
        return "ELY05167: Invalid OTP password format type";
    }
    @Override
    public final AuthenticationMechanismException mechInvalidOTPPasswordFormatType() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechInvalidOTPPasswordFormatType$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechUnsupportedAlgorithm$str() {
        return "ELY05168: Unsupported algorithm selected \"%s\"";
    }
    @Override
    public final AuthenticationMechanismException mechUnsupportedAlgorithm(final String algorithm) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnsupportedAlgorithm$str(), algorithm));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechResponseTokenMismatch$str() {
        return "ELY05169: [%s] Clients response token does not match expected token";
    }
    @Override
    public final String mechResponseTokenMismatch(final String mechName) {
        return String.format(getLoggingLocale(), mechResponseTokenMismatch$str(), mechName);
    }
    protected String mechProblemDuringCryptResultIsNull$str() {
        return "ELY05170: Problem during crypt: The encrypted result is null. The input data has a length of zero or too short to result in a new block.";
    }
    @Override
    public final AuthenticationMechanismException mechProblemDuringCryptResultIsNull() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechProblemDuringCryptResultIsNull$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechProblemDuringDecryptResultIsNull$str() {
        return "ELY05171: Problem during decrypt: The decrypted result is null. The input data has a length of zero or too short to result in a new block.";
    }
    @Override
    public final AuthenticationMechanismException mechProblemDuringDecryptResultIsNull() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechProblemDuringDecryptResultIsNull$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToObtainServerCredential$str() {
        return "ELY05173: Unable to obtain server credential.";
    }
    @Override
    public final AuthenticationMechanismException unableToObtainServerCredential() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), unableToObtainServerCredential$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechNotChosenRealm$str() {
        return "ELY05174: Callback handler has not chosen realm";
    }
    @Override
    public final AuthenticationMechanismException mechNotChosenRealm() {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechNotChosenRealm$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechUnableToDetermineBoundServerName$str() {
        return "ELY05175: Unable to determine bound server name";
    }
    @Override
    public final AuthenticationMechanismException mechUnableToDetermineBoundServerName(final Exception e) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechUnableToDetermineBoundServerName$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechCallbackHandlerUnsupportedCallback$str() {
        return "ELY05176: Unsupported callback";
    }
    @Override
    public final AuthenticationMechanismException mechCallbackHandlerUnsupportedCallback(final Throwable cause) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechCallbackHandlerUnsupportedCallback$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechOneOfDirectivesHasToBeDefined$str() {
        return "ELY05177: One of \"%s\" and \"%s\" directives has to be defined";
    }
    @Override
    public final AuthenticationMechanismException mechOneOfDirectivesHasToBeDefined(final String directive1, final String directive2) {
        final AuthenticationMechanismException result = new AuthenticationMechanismException(String.format(getLoggingLocale(), mechOneOfDirectivesHasToBeDefined$str(), directive1, directive2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String incorrectlyFormattedHeader$str() {
        return "ELY06001: An incorrectly formatted '%s'header was encountered.";
    }
    @Override
    public final String incorrectlyFormattedHeader(final String headerName) {
        return String.format(getLoggingLocale(), incorrectlyFormattedHeader$str(), headerName);
    }
    protected String authenticationFailed2$str() {
        return "ELY06002: An authentication attempt for user '%s' failed validation using mechanism '%s'.";
    }
    @Override
    public final String authenticationFailed(final String username, final String mechanismName) {
        return String.format(getLoggingLocale(), authenticationFailed2$str(), username, mechanismName);
    }
    protected String authenticationFailed0$str() {
        return "ELY06003: An authentication attempt failed validation.";
    }
    @Override
    public final String authenticationFailed() {
        return String.format(getLoggingLocale(), authenticationFailed0$str());
    }
    protected String authorizationFailed$str() {
        return "ELY06006: An authorization check for user '%s' failed.";
    }
    @Override
    public final String authorizationFailed(final String username) {
        return String.format(getLoggingLocale(), authorizationFailed$str(), username);
    }
    protected String usernameOrPasswordMissing$str() {
        return "ELY06007: Username or password missing from authentication attempt.";
    }
    @Override
    public final String usernameOrPasswordMissing() {
        return String.format(getLoggingLocale(), usernameOrPasswordMissing$str());
    }
    protected String digestMechanismRequireRealm$str() {
        return "ELY06015: Unable to authenticate using DIGEST mechanism - realm name needs to be specified";
    }
    @Override
    public final HttpAuthenticationException digestMechanismRequireRealm() {
        final HttpAuthenticationException result = new HttpAuthenticationException(String.format(getLoggingLocale(), digestMechanismRequireRealm$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String digestMechanismInvalidRealm$str() {
        return "ELY06019: Unable to authenticate using DIGEST mechanism - mechanism realm name (%s) is not valid";
    }
    @Override
    public final HttpAuthenticationException digestMechanismInvalidRealm(final String realm) {
        final HttpAuthenticationException result = new HttpAuthenticationException(String.format(getLoggingLocale(), digestMechanismInvalidRealm$str(), realm));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsuitableScope$str() {
        return "ELY06020: Scope unsuitable for use with authentication state '%s'";
    }
    @Override
    public final IllegalArgumentException unsuitableScope(final String scopeName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unsuitableScope$str(), scopeName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToIdentifyHttpScope$str() {
        return "ELY06021: Unable to identify suitable HttpScope for mechanism state storage";
    }
    @Override
    public final IllegalArgumentException unableToIdentifyHttpScope() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unableToIdentifyHttpScope$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidNonceCount$str() {
        return "ELY06022: Invalid nonce count %s";
    }
    @Override
    public final HttpAuthenticationException invalidNonceCount(final int nonceCount) {
        final HttpAuthenticationException result = new HttpAuthenticationException(String.format(getLoggingLocale(), invalidNonceCount$str(), nonceCount));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String asnUnrecognisedAlgorithm$str() {
        return "ELY07001: Unrecognized encoding algorithm [%s]";
    }
    @Override
    public final ASN1Exception asnUnrecognisedAlgorithm(final String algorithm) {
        final ASN1Exception result = new ASN1Exception(String.format(getLoggingLocale(), asnUnrecognisedAlgorithm$str(), algorithm));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String asnInvalidGeneralNameType$str() {
        return "ELY07002: Invalid general name type";
    }
    @Override
    public final ASN1Exception asnInvalidGeneralNameType() {
        final ASN1Exception result = new ASN1Exception(String.format(getLoggingLocale(), asnInvalidGeneralNameType$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String asnUnexpectedTag$str() {
        return "ELY07004: Unexpected ASN.1 tag encountered";
    }
    @Override
    public final ASN1Exception asnUnexpectedTag() {
        final ASN1Exception result = new ASN1Exception(String.format(getLoggingLocale(), asnUnexpectedTag$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
