package org.wildfly.security.permission;

import java.util.Locale;
import org.wildfly.security.permission.PermissionVerifier;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.SecurityException;
import java.lang.String;
import org.jboss.logging.Logger;
import org.wildfly.security.permission.InvalidPermissionClassException;
import org.jboss.logging.BasicLogger;
import java.security.Permission;
import java.lang.Throwable;
import java.io.InvalidObjectException;
import java.lang.Class;
import java.util.Arrays;
import java.lang.ClassNotFoundException;
import java.lang.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-05-17T17:48:51+0100")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String permissionCollectionMustBeReadOnly$str() {
        return "ELY03013: Permission collection must be read-only";
    }
    @Override
    public final SecurityException permissionCollectionMustBeReadOnly() {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), permissionCollectionMustBeReadOnly$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String permissionClassMissing$str() {
        return "ELY03015: Could not load permission class \"%s\"";
    }
    @Override
    public final org.wildfly.security.permission.InvalidPermissionClassException permissionClassMissing(final String className, final ClassNotFoundException cause) {
        final org.wildfly.security.permission.InvalidPermissionClassException result = new org.wildfly.security.permission.InvalidPermissionClassException(String.format(getLoggingLocale(), permissionClassMissing$str(), className), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String permissionInstantiation$str() {
        return "ELY03016: Could not instantiate permission class \"%s\"";
    }
    @Override
    public final org.wildfly.security.permission.InvalidPermissionClassException permissionInstantiation(final String className, final Throwable cause) {
        final org.wildfly.security.permission.InvalidPermissionClassException result = new org.wildfly.security.permission.InvalidPermissionClassException(String.format(getLoggingLocale(), permissionInstantiation$str(), className), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noPermissionConstructor$str() {
        return "ELY03017: No valid permission constructor found on class \"%s\"";
    }
    @Override
    public final org.wildfly.security.permission.InvalidPermissionClassException noPermissionConstructor(final String className) {
        final org.wildfly.security.permission.InvalidPermissionClassException result = new org.wildfly.security.permission.InvalidPermissionClassException(String.format(getLoggingLocale(), noPermissionConstructor$str(), className));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String readOnlyPermissionCollection$str() {
        return "ELY03018: Cannot add permissions to a read-only permission collection";
    }
    @Override
    public final SecurityException readOnlyPermissionCollection() {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), readOnlyPermissionCollection$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidObjectNull$str() {
        return "ELY03019: Failure to deserialize object: field \"%s\" is null";
    }
    @Override
    public final InvalidObjectException invalidObjectNull(final String fieldName) {
        final InvalidObjectException result = new InvalidObjectException(String.format(getLoggingLocale(), invalidObjectNull$str(), fieldName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String expectedEmptyActions$str() {
        return "ELY03020: Expected empty actions string, got \"%s\"";
    }
    @Override
    public final IllegalArgumentException expectedEmptyActions(final String actions) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), expectedEmptyActions$str(), actions));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidPermissionType$str() {
        return "ELY03021: Invalid permission type; expected %s, got %s";
    }
    @Override
    public final IllegalArgumentException invalidPermissionType(final Class<? extends Permission> expected, final Permission actual) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidPermissionType$str(), expected, actual));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String permissionCheckFailed$str() {
        return "ELY03022: Permission check failed: %s is not implied by %s";
    }
    @Override
    public final SecurityException permissionCheckFailed(final Permission permission, final org.wildfly.security.permission.PermissionVerifier permissionVerifier) {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), permissionCheckFailed$str(), permission, permissionVerifier));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
