/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.SetCallbackHandlerAuthenticationConfiguration;

class SetRealmAuthenticationConfiguration
extends AuthenticationConfiguration
implements AuthenticationConfiguration.HandlesCallbacks {
    private final String realm;

    SetRealmAuthenticationConfiguration(AuthenticationConfiguration parent, String realm) {
        super(parent.without(SetCallbackHandlerAuthenticationConfiguration.class));
        this.realm = realm;
    }

    @Override
    void handleCallback(Callback[] callbacks, int index) throws IOException, UnsupportedCallbackException {
        Callback callback = callbacks[index];
        if (callback instanceof RealmCallback) {
            RealmCallback realmCallback = (RealmCallback)callback;
            realmCallback.setText(this.realm != null ? this.realm : realmCallback.getDefaultText());
            return;
        }
        if (callback instanceof RealmChoiceCallback) {
            RealmChoiceCallback realmChoiceCallback = (RealmChoiceCallback)callback;
            if (this.realm == null) {
                realmChoiceCallback.setSelectedIndex(realmChoiceCallback.getDefaultChoice());
            } else {
                String[] choices = realmChoiceCallback.getChoices();
                for (int i = 0; i < choices.length; ++i) {
                    if (!this.realm.equals(choices[i])) continue;
                    realmChoiceCallback.setSelectedIndex(i);
                    break;
                }
            }
            return;
        }
        super.handleCallback(callbacks, index);
    }

    @Override
    AuthenticationConfiguration reparent(AuthenticationConfiguration newParent) {
        return new SetRealmAuthenticationConfiguration(newParent, this.realm);
    }

    @Override
    String getMechanismRealm() {
        return this.realm;
    }

    @Override
    boolean halfEqual(AuthenticationConfiguration other) {
        return this.realm.equals(other.getMechanismRealm()) && this.parentHalfEqual(other);
    }

    @Override
    int calcHashCode() {
        return HashMath.multiHashUnordered(this.parentHashCode(), 28493, this.realm.hashCode());
    }

    @Override
    StringBuilder asString(StringBuilder sb) {
        return this.parentAsString(sb).append("realm=").append(this.realm).append(',');
    }
}

