/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.io.IOException;
import java.net.URI;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.x500.X500Principal;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.Oid;
import org.wildfly.common.Assert;
import org.wildfly.common.annotation.NotNull;
import org.wildfly.security.FixedSecurityFactory;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security.WildFlyElytronProvider;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.callback.CallbackUtil;
import org.wildfly.security.auth.callback.ChannelBindingCallback;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.auth.callback.EvidenceVerifyCallback;
import org.wildfly.security.auth.callback.ParameterCallback;
import org.wildfly.security.auth.callback.PasswordResetCallback;
import org.wildfly.security.auth.callback.SSLCallback;
import org.wildfly.security.auth.callback.TrustedAuthoritiesCallback;
import org.wildfly.security.auth.client.CallbackKind;
import org.wildfly.security.auth.principal.AnonymousPrincipal;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.server.IdentityCredentials;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.credential.AlgorithmCredential;
import org.wildfly.security.credential.BearerTokenCredential;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.GSSKerberosCredential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.X509CertificateChainPrivateCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.credential.source.CredentialStoreCredentialSource;
import org.wildfly.security.credential.source.FactoryCredentialSource;
import org.wildfly.security.credential.source.KeyStoreCredentialSource;
import org.wildfly.security.credential.source.LocalKerberosCredentialSource;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.evidence.X509PeerCertificateChainEvidence;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.TwoWayPassword;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.sasl.SaslMechanismSelector;
import org.wildfly.security.sasl.util.FilterMechanismSaslClientFactory;
import org.wildfly.security.sasl.util.LocalPrincipalSaslClientFactory;
import org.wildfly.security.sasl.util.PrivilegedSaslClientFactory;
import org.wildfly.security.sasl.util.PropertiesSaslClientFactory;
import org.wildfly.security.sasl.util.ProtocolSaslClientFactory;
import org.wildfly.security.sasl.util.SSLSaslClientFactory;
import org.wildfly.security.sasl.util.SaslMechanismInformation;
import org.wildfly.security.sasl.util.SecurityProviderSaslClientFactory;
import org.wildfly.security.sasl.util.ServerNameSaslClientFactory;
import org.wildfly.security.ssl.SSLConnection;
import org.wildfly.security.ssl.SSLUtils;
import org.wildfly.security.util.ProviderServiceLoaderSupplier;
import org.wildfly.security.util.ProviderUtil;
import org.wildfly.security.util._private.Arrays2;
import org.wildfly.security.x500.TrustedAuthority;

public final class AuthenticationConfiguration {
    private static final Principal[] NO_PRINCIPALS = new Principal[0];
    private static final Callback[] NO_CALLBACKS = new Callback[0];
    private static final String[] NO_STRINGS = new String[0];
    private static final EnumSet<CallbackKind> NO_CALLBACK_KINDS = EnumSet.noneOf(CallbackKind.class);
    private static final int SET_PRINCIPAL = 0;
    private static final int SET_HOST = 1;
    private static final int SET_PROTOCOL = 2;
    private static final int SET_REALM = 3;
    private static final int SET_AUTHZ_PRINCIPAL = 4;
    private static final int SET_FWD_AUTH_NAME_DOMAIN = 5;
    private static final int SET_USER_CBH = 6;
    private static final int SET_USER_CB_KINDS = 7;
    private static final int SET_CRED_SOURCE = 8;
    private static final int SET_PROVIDER_SUPPLIER = 9;
    private static final int SET_KEY_MGR_FAC = 10;
    private static final int SET_SASL_SELECTOR = 11;
    private static final int SET_FWD_AUTH_CRED_DOMAIN = 12;
    private static final int SET_PRINCIPAL_RW = 13;
    private static final int SET_SASL_FAC_SUP = 14;
    private static final int SET_PARAM_SPECS = 15;
    private static final int SET_TRUST_MGR_FAC = 16;
    private static final int SET_SASL_MECH_PROPS = 17;
    private static final int SET_ACCESS_CTXT = 18;
    private static final int SET_CALLBACK_INTERCEPT = 19;
    private static final int SET_SASL_PROTOCOL = 20;
    private static final int SET_FWD_AUTHZ_NAME_DOMAIN = 21;
    private static final Supplier<Provider[]> DEFAULT_PROVIDER_SUPPLIER = ProviderUtil.aggregate(() -> new Provider[]{new WildFlyElytronProvider()}, WildFlySecurityManager.isChecking() ? (Supplier)AccessController.doPrivileged(() -> new ProviderServiceLoaderSupplier(AuthenticationConfiguration.class.getClassLoader(), true)) : new ProviderServiceLoaderSupplier(AuthenticationConfiguration.class.getClassLoader(), true), ProviderUtil.INSTALLED_PROVIDERS);
    @Deprecated
    public static final AuthenticationConfiguration EMPTY = new AuthenticationConfiguration();
    private SaslClientFactory saslClientFactory = null;
    private int hashCode;
    private String toString;
    final AccessControlContext capturedAccessContext;
    @NotNull
    final Principal principal;
    final String setHost;
    final String setProtocol;
    final String setRealm;
    final Principal setAuthzPrincipal;
    final SecurityDomain authenticationNameForwardSecurityDomain;
    final SecurityDomain authenticationCredentialsForwardSecurityDomain;
    final SecurityDomain authorizationNameForwardSecurityDomain;
    final CallbackHandler userCallbackHandler;
    final EnumSet<CallbackKind> userCallbackKinds;
    final CredentialSource credentialSource;
    final int setPort;
    final Supplier<Provider[]> providerSupplier;
    final SecurityFactory<X509KeyManager> keyManagerFactory;
    final SaslMechanismSelector saslMechanismSelector;
    final Function<Principal, Principal> principalRewriter;
    final Supplier<SaslClientFactory> saslClientFactorySupplier;
    final List<AlgorithmParameterSpec> parameterSpecs;
    final SecurityFactory<X509TrustManager> trustManagerFactory;
    final Map<String, ?> saslMechanismProperties;
    final Predicate<Callback> callbackIntercept;
    final String saslProtocol;

    public static AuthenticationConfiguration empty() {
        return EMPTY;
    }

    private AuthenticationConfiguration() {
        this.capturedAccessContext = null;
        this.principal = AnonymousPrincipal.getInstance();
        this.setHost = null;
        this.setProtocol = null;
        this.setRealm = null;
        this.setAuthzPrincipal = null;
        this.authenticationNameForwardSecurityDomain = null;
        this.authenticationCredentialsForwardSecurityDomain = null;
        this.authorizationNameForwardSecurityDomain = null;
        this.userCallbackHandler = null;
        this.userCallbackKinds = NO_CALLBACK_KINDS;
        this.credentialSource = IdentityCredentials.NONE;
        this.setPort = -1;
        this.providerSupplier = DEFAULT_PROVIDER_SUPPLIER;
        this.keyManagerFactory = null;
        this.saslMechanismSelector = null;
        this.principalRewriter = null;
        this.saslClientFactorySupplier = null;
        this.parameterSpecs = Collections.emptyList();
        this.trustManagerFactory = null;
        this.saslMechanismProperties = Collections.singletonMap("wildfly.sasl.local-user.quiet-auth", "true");
        this.callbackIntercept = null;
        this.saslProtocol = null;
    }

    private AuthenticationConfiguration(AuthenticationConfiguration original, int what, Object value) {
        this.capturedAccessContext = what == 18 ? (AccessControlContext)value : original.capturedAccessContext;
        this.principal = what == 0 ? (Principal)value : original.principal;
        this.setHost = what == 1 ? (String)value : original.setHost;
        this.setProtocol = what == 2 ? (String)value : original.setProtocol;
        this.setRealm = what == 3 ? (String)value : original.setRealm;
        this.setAuthzPrincipal = what == 4 ? (Principal)value : original.setAuthzPrincipal;
        this.authenticationNameForwardSecurityDomain = what == 5 ? (SecurityDomain)value : original.authenticationNameForwardSecurityDomain;
        this.authenticationCredentialsForwardSecurityDomain = what == 12 ? (SecurityDomain)value : original.authenticationCredentialsForwardSecurityDomain;
        this.authorizationNameForwardSecurityDomain = what == 21 ? (SecurityDomain)value : original.authorizationNameForwardSecurityDomain;
        this.userCallbackHandler = what == 6 ? (CallbackHandler)value : original.userCallbackHandler;
        this.userCallbackKinds = (what == 7 ? (EnumSet<CallbackKind>)value : original.userCallbackKinds).clone();
        this.credentialSource = what == 8 ? (CredentialSource)value : original.credentialSource;
        this.setPort = original.setPort;
        this.providerSupplier = what == 9 ? (Supplier<Provider[]>)value : original.providerSupplier;
        this.keyManagerFactory = what == 10 ? (SecurityFactory<X509KeyManager>)value : original.keyManagerFactory;
        this.saslMechanismSelector = what == 11 ? (SaslMechanismSelector)value : original.saslMechanismSelector;
        this.principalRewriter = what == 13 ? (Function<Principal, Principal>)value : original.principalRewriter;
        this.saslClientFactorySupplier = what == 14 ? (Supplier<SaslClientFactory>)value : original.saslClientFactorySupplier;
        this.parameterSpecs = what == 15 ? (List<AlgorithmParameterSpec>)value : original.parameterSpecs;
        this.trustManagerFactory = what == 16 ? (SecurityFactory<X509TrustManager>)value : original.trustManagerFactory;
        this.saslMechanismProperties = what == 17 ? (Map<String, ?>)value : original.saslMechanismProperties;
        this.callbackIntercept = what == 19 ? (Predicate<Callback>)value : original.callbackIntercept;
        this.saslProtocol = what == 20 ? (String)value : original.saslProtocol;
        this.sanitazeOnMutation(what);
    }

    private AuthenticationConfiguration(AuthenticationConfiguration original, int what1, Object value1, int what2, Object value2) {
        AccessControlContext accessControlContext = what1 == 18 ? (AccessControlContext)value1 : (this.capturedAccessContext = what2 == 18 ? (AccessControlContext)value2 : original.capturedAccessContext);
        Principal principal = what1 == 0 ? (Principal)value1 : (this.principal = what2 == 0 ? (Principal)value2 : original.principal);
        String string = what1 == 1 ? (String)value1 : (this.setHost = what2 == 1 ? (String)value2 : original.setHost);
        String string2 = what1 == 2 ? (String)value1 : (this.setProtocol = what2 == 2 ? (String)value2 : original.setProtocol);
        String string3 = what1 == 3 ? (String)value1 : (this.setRealm = what2 == 3 ? (String)value2 : original.setRealm);
        Principal principal2 = what1 == 4 ? (Principal)value1 : (this.setAuthzPrincipal = what2 == 4 ? (Principal)value2 : original.setAuthzPrincipal);
        SecurityDomain securityDomain = what1 == 5 ? (SecurityDomain)value1 : (this.authenticationNameForwardSecurityDomain = what2 == 5 ? (SecurityDomain)value2 : original.authenticationNameForwardSecurityDomain);
        SecurityDomain securityDomain2 = what1 == 12 ? (SecurityDomain)value1 : (this.authenticationCredentialsForwardSecurityDomain = what2 == 12 ? (SecurityDomain)value2 : original.authenticationCredentialsForwardSecurityDomain);
        SecurityDomain securityDomain3 = what1 == 21 ? (SecurityDomain)value1 : (this.authorizationNameForwardSecurityDomain = what2 == 21 ? (SecurityDomain)value2 : original.authorizationNameForwardSecurityDomain);
        CallbackHandler callbackHandler = what1 == 6 ? (CallbackHandler)value1 : (this.userCallbackHandler = what2 == 6 ? (CallbackHandler)value2 : original.userCallbackHandler);
        this.userCallbackKinds = (what1 == 7 ? (EnumSet<CallbackKind>)value1 : (what2 == 7 ? (EnumSet)value2 : original.userCallbackKinds)).clone();
        this.credentialSource = what1 == 8 ? (CredentialSource)value1 : (what2 == 8 ? (CredentialSource)value2 : original.credentialSource);
        this.setPort = original.setPort;
        Supplier<Object> supplier = what1 == 9 ? (Supplier<Provider[]>)value1 : (this.providerSupplier = what2 == 9 ? (Supplier)value2 : original.providerSupplier);
        SecurityFactory<X509KeyManager> securityFactory = what1 == 10 ? (SecurityFactory<X509KeyManager>)value1 : (this.keyManagerFactory = what2 == 10 ? (SecurityFactory)value2 : original.keyManagerFactory);
        SaslMechanismSelector saslMechanismSelector = what1 == 11 ? (SaslMechanismSelector)value1 : (this.saslMechanismSelector = what2 == 11 ? (SaslMechanismSelector)value2 : original.saslMechanismSelector);
        Function<Principal, Principal> function = what1 == 13 ? (Function<Principal, Principal>)value1 : (this.principalRewriter = what2 == 13 ? (Function)value2 : original.principalRewriter);
        Supplier<SaslClientFactory> supplier2 = what1 == 14 ? (Supplier<SaslClientFactory>)value1 : (this.saslClientFactorySupplier = what2 == 14 ? (Supplier)value2 : original.saslClientFactorySupplier);
        List<AlgorithmParameterSpec> list = what1 == 15 ? (List<AlgorithmParameterSpec>)value1 : (this.parameterSpecs = what2 == 15 ? (List)value2 : original.parameterSpecs);
        SecurityFactory<X509TrustManager> securityFactory2 = what1 == 16 ? (SecurityFactory<X509TrustManager>)value1 : (this.trustManagerFactory = what2 == 16 ? (SecurityFactory)value2 : original.trustManagerFactory);
        Map<String, Object> map = what1 == 17 ? (Map<String, ?>)value1 : (this.saslMechanismProperties = what2 == 17 ? (Map)value2 : original.saslMechanismProperties);
        Predicate<Callback> predicate = what1 == 19 ? (Predicate<Callback>)value1 : (this.callbackIntercept = what2 == 19 ? (Predicate)value2 : original.callbackIntercept);
        this.saslProtocol = what1 == 20 ? (String)value1 : (what2 == 20 ? (String)value2 : original.saslProtocol);
        this.sanitazeOnMutation(what1);
        this.sanitazeOnMutation(what2);
    }

    private AuthenticationConfiguration(AuthenticationConfiguration original, int port) {
        this.capturedAccessContext = original.capturedAccessContext;
        this.principal = original.principal;
        this.setHost = original.setHost;
        this.setProtocol = original.setProtocol;
        this.setRealm = original.setRealm;
        this.setAuthzPrincipal = original.setAuthzPrincipal;
        this.authenticationNameForwardSecurityDomain = original.authenticationNameForwardSecurityDomain;
        this.authenticationCredentialsForwardSecurityDomain = original.authenticationCredentialsForwardSecurityDomain;
        this.authorizationNameForwardSecurityDomain = original.authorizationNameForwardSecurityDomain;
        this.userCallbackHandler = original.userCallbackHandler;
        this.userCallbackKinds = original.userCallbackKinds;
        this.credentialSource = original.credentialSource;
        this.setPort = port;
        this.providerSupplier = original.providerSupplier;
        this.keyManagerFactory = original.keyManagerFactory;
        this.saslMechanismSelector = original.saslMechanismSelector;
        this.principalRewriter = original.principalRewriter;
        this.saslClientFactorySupplier = original.saslClientFactorySupplier;
        this.parameterSpecs = original.parameterSpecs;
        this.trustManagerFactory = original.trustManagerFactory;
        this.saslMechanismProperties = original.saslMechanismProperties;
        this.callbackIntercept = original.callbackIntercept;
        this.saslProtocol = original.saslProtocol;
    }

    private AuthenticationConfiguration(AuthenticationConfiguration original, AuthenticationConfiguration other) {
        this.capturedAccessContext = AuthenticationConfiguration.getOrDefault(other.capturedAccessContext, original.capturedAccessContext);
        this.principal = other.principal instanceof AnonymousPrincipal ? original.principal : other.principal;
        this.setHost = AuthenticationConfiguration.getOrDefault(other.setHost, original.setHost);
        this.setProtocol = AuthenticationConfiguration.getOrDefault(other.setProtocol, original.setProtocol);
        this.setRealm = AuthenticationConfiguration.getOrDefault(other.setRealm, original.setRealm);
        this.setAuthzPrincipal = AuthenticationConfiguration.getOrDefault(other.setAuthzPrincipal, original.setAuthzPrincipal);
        this.authenticationNameForwardSecurityDomain = AuthenticationConfiguration.getOrDefault(other.authenticationNameForwardSecurityDomain, original.authenticationNameForwardSecurityDomain);
        this.authenticationCredentialsForwardSecurityDomain = AuthenticationConfiguration.getOrDefault(other.authenticationCredentialsForwardSecurityDomain, original.authenticationCredentialsForwardSecurityDomain);
        this.authorizationNameForwardSecurityDomain = AuthenticationConfiguration.getOrDefault(other.authorizationNameForwardSecurityDomain, original.authorizationNameForwardSecurityDomain);
        this.userCallbackHandler = AuthenticationConfiguration.getOrDefault(other.userCallbackHandler, original.userCallbackHandler);
        this.userCallbackKinds = AuthenticationConfiguration.getOrDefault(other.userCallbackKinds, original.userCallbackKinds).clone();
        this.credentialSource = other.credentialSource == IdentityCredentials.NONE ? original.credentialSource : other.credentialSource;
        this.setPort = AuthenticationConfiguration.getOrDefault(other.setPort, original.setPort);
        this.providerSupplier = AuthenticationConfiguration.getOrDefault(other.providerSupplier, original.providerSupplier);
        this.keyManagerFactory = AuthenticationConfiguration.getOrDefault(other.keyManagerFactory, original.keyManagerFactory);
        this.saslMechanismSelector = AuthenticationConfiguration.getOrDefault(other.saslMechanismSelector, original.saslMechanismSelector);
        this.principalRewriter = AuthenticationConfiguration.getOrDefault(other.principalRewriter, original.principalRewriter);
        this.saslClientFactorySupplier = AuthenticationConfiguration.getOrDefault(other.saslClientFactorySupplier, original.saslClientFactorySupplier);
        this.parameterSpecs = AuthenticationConfiguration.getOrDefault(other.parameterSpecs, original.parameterSpecs);
        this.trustManagerFactory = AuthenticationConfiguration.getOrDefault(other.trustManagerFactory, original.trustManagerFactory);
        this.saslMechanismProperties = AuthenticationConfiguration.getOrDefault(other.saslMechanismProperties, original.saslMechanismProperties);
        this.callbackIntercept = other.callbackIntercept == null ? original.callbackIntercept : (original.callbackIntercept == null ? other.callbackIntercept : other.callbackIntercept.or(original.callbackIntercept));
        this.saslProtocol = AuthenticationConfiguration.getOrDefault(other.saslProtocol, original.saslProtocol);
        this.sanitazeOnMutation(6);
    }

    private static <T> T getOrDefault(T value, T defVal) {
        return value != null ? value : defVal;
    }

    private static int getOrDefault(int value, int defVal) {
        return value != -1 ? value : defVal;
    }

    Principal getPrincipal() {
        return this.authenticationNameForwardSecurityDomain != null ? this.authenticationNameForwardSecurityDomain.getCurrentSecurityIdentity().getPrincipal() : this.principal;
    }

    String getHost() {
        return this.setHost;
    }

    String getProtocol() {
        return this.setProtocol;
    }

    String getSaslProtocol() {
        return this.saslProtocol;
    }

    int getPort() {
        return this.setPort;
    }

    boolean saslSupportedByConfiguration(String mechanismName) {
        if (!(this.userCallbackKinds.contains((Object)CallbackKind.PRINCIPAL) || this.principal == AnonymousPrincipal.getInstance() || mechanismName.equals("JBOSS-LOCAL-USER") || SaslMechanismInformation.doesNotUsePrincipal(mechanismName) || this.getPrincipal() instanceof AnonymousPrincipal == mechanismName.equals("ANONYMOUS"))) {
            return false;
        }
        if (this.userCallbackKinds.contains((Object)CallbackKind.CREDENTIAL) || this.credentialSource != null && !this.credentialSource.equals(IdentityCredentials.NONE)) {
            return true;
        }
        if (SaslMechanismInformation.doesNotRequireClientCredentials(mechanismName)) {
            return true;
        }
        if (this.keyManagerFactory != null && SaslMechanismInformation.IEC_ISO_9798.test(mechanismName)) {
            return true;
        }
        Set<Class<? extends Credential>> types = SaslMechanismInformation.getSupportedClientCredentialTypes(mechanismName);
        CredentialSource credentials = this.credentialSource;
        for (Class<? extends Credential> type : types) {
            if (AlgorithmCredential.class.isAssignableFrom(type)) {
                Set<String> algorithms = SaslMechanismInformation.getSupportedClientCredentialAlgorithms(mechanismName, type);
                if (algorithms.contains("*")) {
                    try {
                        if (!credentials.getCredentialAcquireSupport(type, null).mayBeSupported()) continue;
                        return true;
                    }
                    catch (IOException iOException) {
                        continue;
                    }
                }
                for (String algorithm : algorithms) {
                    try {
                        if (!credentials.getCredentialAcquireSupport(type, algorithm).mayBeSupported()) continue;
                        return true;
                    }
                    catch (IOException iOException) {
                    }
                }
                continue;
            }
            try {
                if (!credentials.getCredentialAcquireSupport(type).mayBeSupported()) continue;
                return true;
            }
            catch (IOException iOException) {
            }
        }
        return false;
    }

    Principal doRewriteUser(Principal original) {
        Principal rewritten;
        Function<Principal, Principal> principalRewriter = this.principalRewriter;
        Principal principal = rewritten = principalRewriter == null ? original : principalRewriter.apply(original);
        if (rewritten == null) {
            throw ElytronMessages.log.invalidName();
        }
        return rewritten;
    }

    Principal getAuthorizationPrincipal() {
        return this.authorizationNameForwardSecurityDomain != null ? this.authorizationNameForwardSecurityDomain.getCurrentSecurityIdentity().getPrincipal() : this.setAuthzPrincipal;
    }

    Supplier<Provider[]> getProviderSupplier() {
        Supplier<Provider[]> providerSupplier = this.providerSupplier;
        return providerSupplier == null ? ProviderUtil.INSTALLED_PROVIDERS : providerSupplier;
    }

    SaslClientFactory getSaslClientFactory(Supplier<Provider[]> providers) {
        Supplier<SaslClientFactory> supplier = this.saslClientFactorySupplier;
        return supplier != null ? supplier.get() : new SecurityProviderSaslClientFactory(providers);
    }

    SecurityFactory<X509TrustManager> getX509TrustManagerFactory() {
        return this.trustManagerFactory == null ? SSLUtils.getDefaultX509TrustManagerSecurityFactory() : this.trustManagerFactory;
    }

    SecurityFactory<X509KeyManager> getX509KeyManagerFactory() {
        return this.keyManagerFactory;
    }

    CredentialSource getCredentialSource() {
        if (this.authenticationCredentialsForwardSecurityDomain != null) {
            return AccessController.doPrivileged(() -> this.authenticationCredentialsForwardSecurityDomain.getCurrentSecurityIdentity().getPrivateCredentials(), this.capturedAccessContext);
        }
        return this.credentialSource;
    }

    public AuthenticationConfiguration rewriteUser(NameRewriter rewriter) {
        if (rewriter == null) {
            return this;
        }
        if (this.principalRewriter == null) {
            return new AuthenticationConfiguration(this, 13, rewriter.asPrincipalRewriter());
        }
        return new AuthenticationConfiguration(this, 13, this.principalRewriter.andThen(rewriter.asPrincipalRewriter()));
    }

    public AuthenticationConfiguration rewriteUserOnlyWith(NameRewriter rewriter) {
        if (rewriter == null) {
            return this;
        }
        return new AuthenticationConfiguration(this, 13, rewriter.asPrincipalRewriter());
    }

    public AuthenticationConfiguration useAnonymous() {
        return this.usePrincipal(AnonymousPrincipal.getInstance());
    }

    public AuthenticationConfiguration usePrincipal(NamePrincipal principal) {
        return this.usePrincipal((Principal)principal);
    }

    public AuthenticationConfiguration usePrincipal(Principal principal) {
        Assert.checkNotNullParam("principal", principal);
        if (Objects.equals(this.principal, principal)) {
            return this;
        }
        return new AuthenticationConfiguration(this, 0, principal);
    }

    public AuthenticationConfiguration useName(String name) {
        Assert.checkNotNullParam("name", name);
        return this.usePrincipal(new NamePrincipal(name));
    }

    public AuthenticationConfiguration useAuthorizationName(String name) {
        return this.useAuthorizationPrincipal(name == null ? null : new NamePrincipal(name));
    }

    public AuthenticationConfiguration useAuthorizationPrincipal(Principal principal) {
        if (Objects.equals(principal, this.setAuthzPrincipal)) {
            return this;
        }
        return new AuthenticationConfiguration(this, 4, principal);
    }

    public AuthenticationConfiguration useCredential(Credential credential) {
        if (credential == null) {
            return this;
        }
        CredentialSource credentialSource = this.credentialSource;
        if (credentialSource == CredentialSource.NONE) {
            return new AuthenticationConfiguration(this, 8, IdentityCredentials.NONE.withCredential(credential));
        }
        if (credentialSource instanceof IdentityCredentials) {
            return new AuthenticationConfiguration(this, 8, ((IdentityCredentials)credentialSource).withCredential(credential));
        }
        return new AuthenticationConfiguration(this, 8, credentialSource.with(IdentityCredentials.NONE.withCredential(credential)));
    }

    public AuthenticationConfiguration usePassword(Password password) {
        CredentialSource filtered = this.getCredentialSource().without(PasswordCredential.class);
        return password == null ? this.useCredentials(filtered) : this.useCredentials(filtered).useCredential(new PasswordCredential(password));
    }

    public AuthenticationConfiguration usePassword(char[] password) {
        return this.usePassword(password == null ? null : ClearPassword.createRaw("clear", password));
    }

    public AuthenticationConfiguration usePassword(String password) {
        return this.usePassword(password == null ? null : ClearPassword.createRaw("clear", password.toCharArray()));
    }

    public AuthenticationConfiguration useCredentialCallbackHandler(CallbackHandler callbackHandler) {
        return this.useCallbackHandler(callbackHandler, EnumSet.of(CallbackKind.CREDENTIAL));
    }

    public AuthenticationConfiguration useCallbackHandler(CallbackHandler callbackHandler) {
        return callbackHandler == null ? this : new AuthenticationConfiguration(this, 6, callbackHandler, 7, EnumSet.allOf(CallbackKind.class));
    }

    public AuthenticationConfiguration useCallbackHandler(CallbackHandler callbackHandler, Set<CallbackKind> callbackKinds) {
        return callbackHandler == null ? this : new AuthenticationConfiguration(this, 6, callbackHandler, 7, EnumSet.copyOf(callbackKinds));
    }

    public AuthenticationConfiguration useGSSCredential(GSSCredential credential) {
        return credential == null ? this : this.useCredential(new GSSKerberosCredential(credential));
    }

    public AuthenticationConfiguration useKeyStoreCredential(KeyStore.Entry keyStoreEntry) {
        return keyStoreEntry == null ? this : this.useCredentials(this.getCredentialSource().with(new KeyStoreCredentialSource(new FixedSecurityFactory<KeyStore.Entry>(keyStoreEntry))));
    }

    public AuthenticationConfiguration useKeyStoreCredential(KeyStore keyStore, String alias) {
        return keyStore == null || alias == null ? this : this.useCredentials(this.getCredentialSource().with(new KeyStoreCredentialSource(keyStore, alias, null)));
    }

    public AuthenticationConfiguration useKeyStoreCredential(KeyStore keyStore, String alias, KeyStore.ProtectionParameter protectionParameter) {
        return keyStore == null || alias == null ? this : this.useCredentials(this.getCredentialSource().with(new KeyStoreCredentialSource(keyStore, alias, protectionParameter)));
    }

    public AuthenticationConfiguration useCertificateCredential(PrivateKey privateKey, X509Certificate ... certificateChain) {
        return certificateChain == null || certificateChain.length == 0 || privateKey == null ? this : this.useCertificateCredential(new X509CertificateChainPrivateCredential(privateKey, certificateChain));
    }

    public AuthenticationConfiguration useCertificateCredential(X509CertificateChainPrivateCredential credential) {
        return credential == null ? this : this.useCredential(credential);
    }

    public AuthenticationConfiguration useCredentialStoreEntry(CredentialStore credentialStore, String alias) {
        Assert.checkNotNullParam("credentialStore", credentialStore);
        Assert.checkNotNullParam("alias", alias);
        CredentialStoreCredentialSource csCredentialSource = new CredentialStoreCredentialSource(credentialStore, alias);
        return this.useCredentials(this.getCredentialSource().with(csCredentialSource));
    }

    public AuthenticationConfiguration useKeyManagerCredential(X509KeyManager keyManager) {
        return new AuthenticationConfiguration(this, 10, new FixedSecurityFactory<X509KeyManager>(keyManager));
    }

    public AuthenticationConfiguration useLocalKerberosCredential(Oid[] mechanismOids) {
        return this.useCredentials(this.getCredentialSource().with(LocalKerberosCredentialSource.builder().setMechanismOids(mechanismOids).build()));
    }

    public AuthenticationConfiguration useCredentials(CredentialSource credentials) {
        return new AuthenticationConfiguration(this, 8, credentials == null ? CredentialSource.NONE : credentials);
    }

    public AuthenticationConfiguration useChoice(BiPredicate<Class<? extends ChoiceCallback>, String> matchPredicate, String choice) {
        Assert.checkNotNullParam("matchPredicate", matchPredicate);
        Assert.checkNotNullParam("choice", choice);
        Predicate<Callback> callbackIntercept = this.callbackIntercept;
        Predicate<Callback> newIntercept = cb -> {
            if (!(cb instanceof ChoiceCallback)) {
                return false;
            }
            ChoiceCallback choiceCallback = (ChoiceCallback)cb;
            if (matchPredicate.test(choiceCallback.getClass(), choiceCallback.getPrompt())) {
                String[] choices = choiceCallback.getChoices();
                int choicesLength = choices.length;
                for (int i = 0; i < choicesLength; ++i) {
                    if (!choices[i].equals(choice)) continue;
                    choiceCallback.setSelectedIndex(i);
                    return true;
                }
            }
            return false;
        };
        if (callbackIntercept == null) {
            return new AuthenticationConfiguration(this, 19, newIntercept);
        }
        return new AuthenticationConfiguration(this, 19, newIntercept.or(callbackIntercept));
    }

    public AuthenticationConfiguration useParameterSpec(AlgorithmParameterSpec parameterSpec) {
        if (parameterSpec == null) {
            return this;
        }
        List<AlgorithmParameterSpec> specs = this.parameterSpecs;
        if (specs.isEmpty()) {
            return new AuthenticationConfiguration(this, 15, Collections.singletonList(parameterSpec));
        }
        ArrayList<AlgorithmParameterSpec> newList = new ArrayList<AlgorithmParameterSpec>();
        for (AlgorithmParameterSpec spec : specs) {
            if (spec.getClass() == parameterSpec.getClass()) continue;
            newList.add(spec);
        }
        if (newList.isEmpty()) {
            return new AuthenticationConfiguration(this, 15, Collections.singletonList(parameterSpec));
        }
        newList.add(parameterSpec);
        return new AuthenticationConfiguration(this, 15, newList);
    }

    public AuthenticationConfiguration useTrustManager(X509TrustManager trustManager) {
        return trustManager == null ? new AuthenticationConfiguration(this, 16, null) : new AuthenticationConfiguration(this, 16, new FixedSecurityFactory<X509TrustManager>(trustManager));
    }

    public AuthenticationConfiguration useHost(String hostName) {
        if (hostName == null || hostName.isEmpty()) {
            hostName = null;
        }
        if (Objects.equals(this.setHost, hostName)) {
            return this;
        }
        return new AuthenticationConfiguration(this, 1, hostName);
    }

    public AuthenticationConfiguration useProtocol(String protocol) {
        if (protocol == null || protocol.isEmpty()) {
            protocol = null;
        }
        if (Objects.equals(this.setProtocol, protocol)) {
            return this;
        }
        return new AuthenticationConfiguration(this, 2, protocol);
    }

    public AuthenticationConfiguration useSaslProtocol(String saslProtocol) {
        if (saslProtocol == null || saslProtocol.isEmpty()) {
            saslProtocol = null;
        }
        if (Objects.equals(this.saslProtocol, saslProtocol)) {
            return this;
        }
        return new AuthenticationConfiguration(this, 20, saslProtocol);
    }

    public AuthenticationConfiguration usePort(int port) {
        if (port < -1 || port > 65535) {
            throw ElytronMessages.log.invalidPortNumber(port);
        }
        if (port == this.setPort) {
            return this;
        }
        return new AuthenticationConfiguration(this, port);
    }

    public AuthenticationConfiguration useForwardedIdentity(SecurityDomain securityDomain) {
        return this.useForwardedAuthenticationIdentity(securityDomain).useForwardedAuthenticationCredentials(securityDomain);
    }

    public AuthenticationConfiguration useForwardedAuthenticationIdentity(SecurityDomain securityDomain) {
        if (Objects.equals(this.authenticationNameForwardSecurityDomain, securityDomain)) {
            return this;
        }
        return new AuthenticationConfiguration(this, 18, securityDomain != null ? AccessController.getContext() : null, 5, securityDomain);
    }

    public AuthenticationConfiguration useForwardedAuthenticationCredentials(SecurityDomain securityDomain) {
        if (Objects.equals(this.authenticationCredentialsForwardSecurityDomain, securityDomain)) {
            return this;
        }
        return new AuthenticationConfiguration(this, 18, securityDomain != null ? AccessController.getContext() : null, 12, securityDomain);
    }

    public AuthenticationConfiguration useForwardedAuthorizationIdentity(SecurityDomain securityDomain) {
        if (Objects.equals(this.authorizationNameForwardSecurityDomain, securityDomain)) {
            return this;
        }
        return new AuthenticationConfiguration(this, 18, securityDomain != null ? AccessController.getContext() : null, 21, securityDomain);
    }

    public AuthenticationConfiguration useProviders(Supplier<Provider[]> providerSupplier) {
        if (Objects.equals(this.providerSupplier, providerSupplier)) {
            return this;
        }
        return new AuthenticationConfiguration(this, 9, providerSupplier);
    }

    public AuthenticationConfiguration useDefaultProviders() {
        return this.useProviders(DEFAULT_PROVIDER_SUPPLIER);
    }

    public AuthenticationConfiguration useProvidersFromClassLoader(ClassLoader classLoader) {
        return this.useProviders(new ProviderServiceLoaderSupplier(classLoader));
    }

    public AuthenticationConfiguration useSaslClientFactory(SaslClientFactory saslClientFactory) {
        return this.useSaslClientFactory(() -> saslClientFactory);
    }

    public AuthenticationConfiguration useSaslClientFactory(Supplier<SaslClientFactory> saslClientFactory) {
        return new AuthenticationConfiguration(this, 14, saslClientFactory);
    }

    public AuthenticationConfiguration useSaslClientFactoryFromProviders() {
        return new AuthenticationConfiguration(this, 14, null);
    }

    @Deprecated
    public AuthenticationConfiguration useMechanismProperties(Map<String, ?> mechanismProperties) {
        return this.useSaslMechanismProperties(mechanismProperties);
    }

    public AuthenticationConfiguration useSaslMechanismProperties(Map<String, ?> mechanismProperties) {
        return this.useSaslMechanismProperties(mechanismProperties, false);
    }

    @Deprecated
    public AuthenticationConfiguration useMechanismProperties(Map<String, ?> mechanismProperties, boolean exclusive) {
        return this.useSaslMechanismProperties(mechanismProperties, exclusive);
    }

    public AuthenticationConfiguration useSaslMechanismProperties(Map<String, ?> mechanismProperties, boolean exclusive) {
        if (!exclusive && (mechanismProperties == null || mechanismProperties.isEmpty())) {
            return this;
        }
        HashMap newMap = exclusive ? new HashMap() : new HashMap(this.saslMechanismProperties);
        newMap.putAll(mechanismProperties);
        newMap.values().removeIf(Objects::isNull);
        return new AuthenticationConfiguration(this, 17, AuthenticationConfiguration.optimizeMap(newMap));
    }

    private static <K, V> Map<K, V> optimizeMap(Map<K, V> orig) {
        if (orig.isEmpty()) {
            return Collections.emptyMap();
        }
        if (orig.size() == 1) {
            Map.Entry<K, V> entry = orig.entrySet().iterator().next();
            return Collections.singletonMap(entry.getKey(), entry.getValue());
        }
        return orig;
    }

    @Deprecated
    public AuthenticationConfiguration useKerberosSecurityFactory(SecurityFactory<Credential> kerberosSecurityFactory) {
        CredentialSource cs = this.getCredentialSource();
        if (kerberosSecurityFactory != null) {
            return cs != null ? new AuthenticationConfiguration(this, 8, cs.with(new FactoryCredentialSource(kerberosSecurityFactory))) : new AuthenticationConfiguration(this, 8, new FactoryCredentialSource(kerberosSecurityFactory));
        }
        return this;
    }

    public AuthenticationConfiguration setSaslMechanismSelector(SaslMechanismSelector saslMechanismSelector) {
        if (Objects.equals(this.saslMechanismSelector, saslMechanismSelector)) {
            return this;
        }
        return new AuthenticationConfiguration(this, 11, saslMechanismSelector);
    }

    public AuthenticationConfiguration useRealm(String realm) {
        if (Objects.equals(realm, this.setRealm)) {
            return this;
        }
        return new AuthenticationConfiguration(this, 3, realm);
    }

    public AuthenticationConfiguration useBearerTokenCredential(BearerTokenCredential credential) {
        return credential == null ? this : this.useCredentials(this.getCredentialSource().with(IdentityCredentials.NONE.withCredential(credential)));
    }

    public AuthenticationConfiguration withCapturedAccessControlContext() {
        return new AuthenticationConfiguration(this, 18, AccessController.getContext());
    }

    public AuthenticationConfiguration with(AuthenticationConfiguration other) {
        return new AuthenticationConfiguration(this, other);
    }

    CallbackHandler getUserCallbackHandler() {
        return this.userCallbackHandler;
    }

    EnumSet<CallbackKind> getUserCallbackKinds() {
        return this.userCallbackKinds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SaslClientFactory getSaslClientFactory() {
        if (this.saslClientFactory == null) {
            AuthenticationConfiguration authenticationConfiguration = this;
            synchronized (authenticationConfiguration) {
                if (this.saslClientFactory == null) {
                    this.saslClientFactory = this.getSaslClientFactory(this.getProviderSupplier());
                }
            }
        }
        return this.saslClientFactory;
    }

    SaslClient createSaslClient(URI uri, Collection<String> serverMechanisms, UnaryOperator<SaslClientFactory> factoryOperator, SSLSession sslSession) throws SaslException {
        String protocol;
        String host;
        String authzName;
        Predicate<String> filter;
        SaslClientFactory saslClientFactory = (SaslClientFactory)factoryOperator.apply(this.getSaslClientFactory());
        SaslMechanismSelector selector = this.saslMechanismSelector;
        serverMechanisms = (selector == null ? SaslMechanismSelector.DEFAULT : selector).apply(serverMechanisms, sslSession);
        if (serverMechanisms.isEmpty()) {
            return null;
        }
        Principal authorizationPrincipal = this.getAuthorizationPrincipal();
        if (authorizationPrincipal == null) {
            filter = this::saslSupportedByConfiguration;
            authzName = null;
        } else if (authorizationPrincipal instanceof NamePrincipal) {
            filter = this::saslSupportedByConfiguration;
            authzName = authorizationPrincipal.getName();
        } else if (authorizationPrincipal instanceof AnonymousPrincipal) {
            filter = ((Predicate<String>)this::saslSupportedByConfiguration).and("ANONYMOUS"::equals);
            authzName = null;
        } else {
            return null;
        }
        Map<String, ?> mechanismProperties = this.saslMechanismProperties;
        if (!mechanismProperties.isEmpty()) {
            mechanismProperties = new HashMap(mechanismProperties);
            if (!this.userCallbackKinds.contains((Object)CallbackKind.PRINCIPAL) && this.principal != AnonymousPrincipal.getInstance()) {
                mechanismProperties.remove("wildfly.sasl.local-user.quiet-auth");
                mechanismProperties.remove("jboss.sasl.local-user.quiet-auth");
            }
            if (!mechanismProperties.isEmpty()) {
                saslClientFactory = new PropertiesSaslClientFactory(saslClientFactory, mechanismProperties);
            }
        }
        if ((host = this.getHost()) != null) {
            saslClientFactory = new ServerNameSaslClientFactory(saslClientFactory, host);
        }
        if ((protocol = this.getSaslProtocol()) != null) {
            saslClientFactory = new ProtocolSaslClientFactory(saslClientFactory, protocol);
        }
        if (sslSession != null) {
            saslClientFactory = new SSLSaslClientFactory(() -> SSLConnection.forSession(sslSession, true), saslClientFactory);
        }
        SaslClientFactory finalSaslClientFactory = saslClientFactory = new LocalPrincipalSaslClientFactory(new FilterMechanismSaslClientFactory(saslClientFactory, filter));
        saslClientFactory = AccessController.doPrivileged(() -> new PrivilegedSaslClientFactory(finalSaslClientFactory), this.capturedAccessContext);
        SaslClient saslClient = saslClientFactory.createSaslClient(serverMechanisms.toArray(NO_STRINGS), authzName, uri.getScheme(), uri.getHost(), Collections.emptyMap(), this.createCallbackHandler());
        if (ElytronMessages.log.isTraceEnabled()) {
            ElytronMessages.log.tracef("Created SaslClient [%s] for mechanisms %s", (Object)saslClient, (Object)Arrays2.objectToString(serverMechanisms));
        }
        return saslClient;
    }

    CallbackHandler createCallbackHandler() {
        return new ClientCallbackHandler(this);
    }

    public boolean equals(Object obj) {
        return obj instanceof AuthenticationConfiguration && this.equals((AuthenticationConfiguration)obj);
    }

    public boolean equals(AuthenticationConfiguration other) {
        return this.hashCode() == other.hashCode() && Objects.equals(this.principal, other.principal) && Objects.equals(this.setHost, other.setHost) && Objects.equals(this.setProtocol, other.setProtocol) && Objects.equals(this.setRealm, other.setRealm) && Objects.equals(this.setAuthzPrincipal, other.setAuthzPrincipal) && Objects.equals(this.authenticationNameForwardSecurityDomain, other.authenticationNameForwardSecurityDomain) && Objects.equals(this.authenticationCredentialsForwardSecurityDomain, other.authenticationCredentialsForwardSecurityDomain) && Objects.equals(this.authorizationNameForwardSecurityDomain, other.authorizationNameForwardSecurityDomain) && Objects.equals(this.userCallbackHandler, other.userCallbackHandler) && Objects.equals(this.userCallbackKinds, other.userCallbackKinds) && Objects.equals(this.credentialSource, other.credentialSource) && this.setPort == other.setPort && Objects.equals(this.providerSupplier, other.providerSupplier) && Objects.equals(this.keyManagerFactory, other.keyManagerFactory) && Objects.equals(this.saslMechanismSelector, other.saslMechanismSelector) && Objects.equals(this.principalRewriter, other.principalRewriter) && Objects.equals(this.saslClientFactorySupplier, other.saslClientFactorySupplier) && Objects.equals(this.parameterSpecs, other.parameterSpecs) && Objects.equals(this.trustManagerFactory, other.trustManagerFactory) && Objects.equals(this.saslMechanismProperties, other.saslMechanismProperties) && Objects.equals(this.saslProtocol, other.saslProtocol);
    }

    public int hashCode() {
        int hashCode = this.hashCode;
        if (hashCode == 0) {
            hashCode = Objects.hash(this.principal, this.setHost, this.setProtocol, this.setRealm, this.setAuthzPrincipal, this.authenticationNameForwardSecurityDomain, this.authenticationCredentialsForwardSecurityDomain, this.authorizationNameForwardSecurityDomain, this.userCallbackHandler, this.credentialSource, this.providerSupplier, this.keyManagerFactory, this.saslMechanismSelector, this.principalRewriter, this.saslClientFactorySupplier, this.parameterSpecs, this.trustManagerFactory, this.saslMechanismProperties, this.saslProtocol) * 19 + this.setPort;
            if (hashCode == 0) {
                hashCode = 1;
            }
            this.hashCode = hashCode;
        }
        return hashCode;
    }

    public String toString() {
        String toString = this.toString;
        if (toString == null) {
            StringBuilder b = new StringBuilder(64);
            b.append("AuthenticationConfiguration:");
            b.append("principal=").append(this.principal).append(',');
            if (this.setAuthzPrincipal != null) {
                b.append("authorization-id=").append(this.setAuthzPrincipal).append(',');
            }
            if (this.setHost != null) {
                b.append("set-host=").append(this.setHost).append(',');
            }
            if (this.setProtocol != null) {
                b.append("set-protocol=").append(this.setProtocol).append(',');
            }
            if (this.saslProtocol != null) {
                b.append("sasl-protocol-name=").append(this.saslProtocol).append(',');
            }
            if (this.setPort != -1) {
                b.append("set-port=").append(this.setPort).append(',');
            }
            if (this.setRealm != null) {
                b.append("set-realm=").append(this.setRealm).append(',');
            }
            if (this.authenticationNameForwardSecurityDomain != null) {
                b.append("forwarding-authentication-name,");
            }
            if (this.authenticationCredentialsForwardSecurityDomain != null) {
                b.append("forwarding-authentication-credentials,");
            }
            if (this.authorizationNameForwardSecurityDomain != null) {
                b.append("forwarding-authorization-name,");
            }
            if (this.userCallbackHandler != null) {
                b.append("user-callback-handler=").append(this.userCallbackHandler).append(',');
            }
            if (!this.userCallbackKinds.isEmpty()) {
                b.append("user-callback-kinds=").append(this.userCallbackKinds).append(',');
            }
            if (this.credentialSource != null && this.credentialSource != CredentialSource.NONE && this.credentialSource != IdentityCredentials.NONE) {
                b.append("credentials-present,");
            }
            if (this.providerSupplier != null) {
                b.append("providers-supplier=").append(this.providerSupplier).append(',');
            }
            if (this.keyManagerFactory != null) {
                b.append("key-manager-factory=").append(this.keyManagerFactory).append(',');
            }
            if (this.saslMechanismSelector != null) {
                b.append("sasl-mechanism-selector=").append(this.saslMechanismSelector).append(',');
            }
            if (this.principalRewriter != null) {
                b.append("principal-rewriter=").append(this.principalRewriter).append(',');
            }
            if (this.saslClientFactorySupplier != null) {
                b.append("sasl-client-factory-supplier=").append(this.saslClientFactorySupplier).append(',');
            }
            if (!this.parameterSpecs.isEmpty()) {
                b.append("parameter-specifications=").append(this.parameterSpecs).append(',');
            }
            if (this.trustManagerFactory != null) {
                b.append("trust-manager-factory=").append(this.trustManagerFactory).append(',');
            }
            if (!this.saslMechanismProperties.isEmpty()) {
                b.append("mechanism-properties=").append(this.saslMechanismProperties).append(',');
            }
            b.setLength(b.length() - 1);
            this.toString = b.toString();
            return this.toString;
        }
        return toString;
    }

    private void sanitazeOnMutation(int what) {
        switch (what) {
            case 0: {
                if (this.principal == null || this.principal.equals(AnonymousPrincipal.getInstance())) break;
                this.userCallbackKinds.remove((Object)CallbackKind.PRINCIPAL);
                break;
            }
            case 8: {
                if (this.credentialSource == null || this.credentialSource.equals(IdentityCredentials.NONE)) break;
                this.userCallbackKinds.remove((Object)CallbackKind.CREDENTIAL);
                break;
            }
            case 3: {
                this.userCallbackKinds.remove((Object)CallbackKind.REALM);
                break;
            }
            case 15: {
                this.userCallbackKinds.remove((Object)CallbackKind.PARAMETERS);
                break;
            }
            case 10: {
                this.userCallbackKinds.remove((Object)CallbackKind.PEER_CREDENTIAL);
                break;
            }
            case 7: {
                if (this.principal != null) {
                    this.sanitazeOnMutation(0);
                }
                if (this.credentialSource != null) {
                    this.sanitazeOnMutation(8);
                }
                if (this.setRealm != null) {
                    this.sanitazeOnMutation(3);
                }
                if (this.parameterSpecs != null) {
                    this.sanitazeOnMutation(15);
                }
                if (this.keyManagerFactory == null) break;
                this.sanitazeOnMutation(10);
            }
        }
    }

    AccessControlContext getCapturedContext() {
        return this.capturedAccessContext;
    }

    static class ClientCallbackHandler
    implements CallbackHandler {
        private final AuthenticationConfiguration config;
        private final CallbackHandler userCallbackHandler;
        private List<TrustedAuthority> trustedAuthorities;
        private SSLConnection sslConnection;

        ClientCallbackHandler(AuthenticationConfiguration config) {
            this.config = config;
            this.userCallbackHandler = config.getUserCallbackHandler();
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            AuthenticationConfiguration config = this.config;
            Predicate<Callback> callbackIntercept = config.callbackIntercept;
            ArrayList<Callback> userCallbacks = new ArrayList<Callback>(callbacks.length);
            block8: for (Callback callback : callbacks) {
                Object realm;
                if (callbackIntercept != null && callbackIntercept.test(callback)) continue;
                if (callback instanceof NameCallback) {
                    if (config.getUserCallbackKinds().contains((Object)CallbackKind.PRINCIPAL)) {
                        userCallbacks.add(callback);
                        continue;
                    }
                    NameCallback nameCallback = (NameCallback)callback;
                    Principal principal = config.getPrincipal();
                    if (principal instanceof AnonymousPrincipal) {
                        String defaultName = nameCallback.getDefaultName();
                        if (defaultName == null) continue;
                        nameCallback.setName(defaultName);
                        continue;
                    }
                    nameCallback.setName(config.doRewriteUser(principal).getName());
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    if (config.getUserCallbackKinds().contains((Object)CallbackKind.CREDENTIAL)) {
                        userCallbacks.add(callback);
                        continue;
                    }
                    PasswordCallback passwordCallback = (PasswordCallback)callback;
                    CredentialSource credentials = config.getCredentialSource();
                    if (credentials == null) continue;
                    TwoWayPassword password = credentials.applyToCredential(PasswordCredential.class, "clear", c -> c.getPassword(TwoWayPassword.class));
                    if (password instanceof ClearPassword) {
                        passwordCallback.setPassword(((ClearPassword)password).getPassword());
                        continue;
                    }
                    if (password == null) continue;
                    try {
                        PasswordFactory passwordFactory = PasswordFactory.getInstance(password.getAlgorithm());
                        ClearPasswordSpec clearPasswordSpec = passwordFactory.getKeySpec(passwordFactory.translate(password), ClearPasswordSpec.class);
                        passwordCallback.setPassword(clearPasswordSpec.getEncodedPassword());
                    }
                    catch (GeneralSecurityException e) {
                        CallbackUtil.unsupported(passwordCallback);
                    }
                    continue;
                }
                if (callback instanceof PasswordResetCallback) {
                    if (config.getUserCallbackKinds().contains((Object)CallbackKind.CREDENTIAL_RESET)) {
                        userCallbacks.add(callback);
                        continue;
                    }
                    CallbackUtil.unsupported(callback);
                    continue;
                }
                if (callback instanceof CredentialCallback) {
                    Credential credential;
                    String allowedAlgorithm;
                    if (config.getUserCallbackKinds().contains((Object)CallbackKind.CREDENTIAL)) {
                        userCallbacks.add(callback);
                        continue;
                    }
                    CredentialCallback credentialCallback = (CredentialCallback)callback;
                    SecurityFactory<X509KeyManager> keyManagerFactory = config.getX509KeyManagerFactory();
                    if (keyManagerFactory != null && (allowedAlgorithm = credentialCallback.getAlgorithm()) != null && credentialCallback.isCredentialTypeSupported(X509CertificateChainPrivateCredential.class, allowedAlgorithm)) {
                        Principal[] acceptableIssuers;
                        X509KeyManager keyManager;
                        try {
                            keyManager = keyManagerFactory.create();
                        }
                        catch (GeneralSecurityException e) {
                            throw ElytronMessages.log.unableToCreateKeyManager(e);
                        }
                        if (this.trustedAuthorities != null) {
                            ArrayList<X500Principal> issuers = new ArrayList<X500Principal>();
                            for (TrustedAuthority trustedAuthority : this.trustedAuthorities) {
                                if (trustedAuthority instanceof TrustedAuthority.CertificateTrustedAuthority) {
                                    X509Certificate authorityCertificate = ((TrustedAuthority.CertificateTrustedAuthority)trustedAuthority).getIdentifier();
                                    issuers.add(authorityCertificate.getSubjectX500Principal());
                                    continue;
                                }
                                if (!(trustedAuthority instanceof TrustedAuthority.NameTrustedAuthority)) continue;
                                String authorityName = ((TrustedAuthority.NameTrustedAuthority)trustedAuthority).getIdentifier();
                                issuers.add(new X500Principal(authorityName));
                            }
                            acceptableIssuers = issuers.toArray(NO_PRINCIPALS);
                        } else {
                            acceptableIssuers = null;
                        }
                        String alias = keyManager.chooseClientAlias(new String[]{allowedAlgorithm}, acceptableIssuers, null);
                        if (alias != null) {
                            X509Certificate[] certificateChain = keyManager.getCertificateChain(alias);
                            PrivateKey privateKey = keyManager.getPrivateKey(alias);
                            credentialCallback.setCredential(new X509CertificateChainPrivateCredential(privateKey, certificateChain));
                            continue;
                        }
                    }
                    if ((credential = config.getCredentialSource().getCredential(credentialCallback.getCredentialType(), credentialCallback.getAlgorithm(), credentialCallback.getParameterSpec())) == null || !credentialCallback.isCredentialSupported(credential)) continue;
                    credentialCallback.setCredential(credential);
                    continue;
                }
                if (callback instanceof RealmChoiceCallback) {
                    if (config.getUserCallbackKinds().contains((Object)CallbackKind.REALM)) {
                        userCallbacks.add(callback);
                        continue;
                    }
                    RealmChoiceCallback realmChoiceCallback = (RealmChoiceCallback)callback;
                    realm = config.setRealm;
                    if (realm == null) {
                        realmChoiceCallback.setSelectedIndex(realmChoiceCallback.getDefaultChoice());
                        continue;
                    }
                    String[] choices = realmChoiceCallback.getChoices();
                    for (int i = 0; i < choices.length; ++i) {
                        if (!((String)realm).equals(choices[i])) continue;
                        realmChoiceCallback.setSelectedIndex(i);
                        continue block8;
                    }
                    continue;
                }
                if (callback instanceof RealmCallback) {
                    if (config.getUserCallbackKinds().contains((Object)CallbackKind.REALM)) {
                        userCallbacks.add(callback);
                        continue;
                    }
                    RealmCallback realmCallback = (RealmCallback)callback;
                    realm = config.setRealm;
                    realmCallback.setText((String)(realm != null ? realm : realmCallback.getDefaultText()));
                    continue;
                }
                if (callback instanceof ParameterCallback) {
                    if (config.getUserCallbackKinds().contains((Object)CallbackKind.PARAMETERS)) {
                        userCallbacks.add(callback);
                        continue;
                    }
                    ParameterCallback parameterCallback = (ParameterCallback)callback;
                    if (parameterCallback.getParameterSpec() != null) continue;
                    for (AlgorithmParameterSpec parameterSpec : config.parameterSpecs) {
                        if (!parameterCallback.isParameterSupported(parameterSpec)) continue;
                        parameterCallback.setParameterSpec(parameterSpec);
                        continue block8;
                    }
                    continue;
                }
                if (callback instanceof SSLCallback) {
                    if (config.getUserCallbackKinds().contains((Object)CallbackKind.SSL)) {
                        userCallbacks.add(callback);
                        continue;
                    }
                    SSLCallback sslCallback = (SSLCallback)callback;
                    this.sslConnection = sslCallback.getSslConnection();
                    continue;
                }
                if (callback instanceof ChannelBindingCallback) {
                    if (config.getUserCallbackKinds().contains((Object)CallbackKind.CHANNEL_BINDING)) {
                        userCallbacks.add(callback);
                        continue;
                    }
                    SSLConnection sslConnection = this.sslConnection;
                    if (sslConnection == null) continue;
                    sslConnection.handleChannelBindingCallback((ChannelBindingCallback)callback);
                    continue;
                }
                if (callback instanceof ChoiceCallback) {
                    if (config.getUserCallbackKinds().contains((Object)CallbackKind.CHOICE)) {
                        userCallbacks.add(callback);
                        continue;
                    }
                    ChoiceCallback choiceCallback = (ChoiceCallback)callback;
                    choiceCallback.setSelectedIndex(choiceCallback.getDefaultChoice());
                    continue;
                }
                if (callback instanceof TrustedAuthoritiesCallback) {
                    if (config.getUserCallbackKinds().contains((Object)CallbackKind.SERVER_TRUSTED_AUTHORITIES)) {
                        userCallbacks.add(callback);
                        continue;
                    }
                    TrustedAuthoritiesCallback trustedAuthoritiesCallback = (TrustedAuthoritiesCallback)callback;
                    if (this.trustedAuthorities == null) {
                        this.trustedAuthorities = new ArrayList<TrustedAuthority>(trustedAuthoritiesCallback.getTrustedAuthorities());
                        continue;
                    }
                    ArrayList<TrustedAuthority> authorities = new ArrayList<TrustedAuthority>(trustedAuthoritiesCallback.getTrustedAuthorities());
                    authorities.removeIf(this.trustedAuthorities::contains);
                    this.trustedAuthorities.addAll(authorities);
                    continue;
                }
                if (callback instanceof EvidenceVerifyCallback) {
                    X509TrustManager trustManager;
                    X509PeerCertificateChainEvidence peerCertificateChainEvidence;
                    if (config.getUserCallbackKinds().contains((Object)CallbackKind.PEER_CREDENTIAL)) {
                        userCallbacks.add(callback);
                        continue;
                    }
                    EvidenceVerifyCallback evidenceVerifyCallback = (EvidenceVerifyCallback)callback;
                    SecurityFactory<X509TrustManager> trustManagerFactory = config.getX509TrustManagerFactory();
                    if (trustManagerFactory == null || (peerCertificateChainEvidence = evidenceVerifyCallback.getEvidence(X509PeerCertificateChainEvidence.class)) == null) continue;
                    try {
                        trustManager = trustManagerFactory.create();
                    }
                    catch (GeneralSecurityException e) {
                        throw ElytronMessages.log.unableToCreateTrustManager(e);
                    }
                    try {
                        trustManager.checkServerTrusted(peerCertificateChainEvidence.getPeerCertificateChain(), peerCertificateChainEvidence.getAlgorithm());
                        evidenceVerifyCallback.setVerified(true);
                    }
                    catch (CertificateException certificateException) {}
                    continue;
                }
                if (callback instanceof TextOutputCallback) {
                    if (!config.getUserCallbackKinds().contains((Object)CallbackKind.GENERAL_OUTPUT)) continue;
                    userCallbacks.add(callback);
                    continue;
                }
                if (callback instanceof TextInputCallback) {
                    if (config.getUserCallbackKinds().contains((Object)CallbackKind.GENERAL_INPUT)) {
                        userCallbacks.add(callback);
                        continue;
                    }
                    TextInputCallback inputCallback = (TextInputCallback)callback;
                    String text = inputCallback.getText();
                    if (text != null) continue;
                    String defaultText = inputCallback.getDefaultText();
                    if (defaultText != null) {
                        inputCallback.setText(defaultText);
                        continue;
                    }
                    CallbackUtil.unsupported(callback);
                    continue;
                }
                if (this.userCallbackHandler != null) {
                    userCallbacks.add(callback);
                    continue;
                }
                CallbackUtil.unsupported(callback);
            }
            if (!userCallbacks.isEmpty()) {
                assert (this.userCallbackHandler != null);
                Callback[] userCallbackArray = userCallbacks.toArray(NO_CALLBACKS);
                this.userCallbackHandler.handle(userCallbackArray);
            }
        }
    }
}

