/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.pem;

import java.io.Serializable;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.security.asn1.ASN1Exception;
import org.wildfly.security.pem.ElytronMessages;

public class ElytronMessages_$logger
extends DelegatingBasicLogger
implements ElytronMessages,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public ElytronMessages_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String malformedPemContent$str() {
        return "ELY03010: Malformed PEM content at offset %d";
    }

    @Override
    public final IllegalArgumentException malformedPemContent(long offset) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.malformedPemContent$str(), offset));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String invalidPemType$str() {
        return "ELY03011: Invalid PEM type (expected \"%s\", got \"%s\"";
    }

    @Override
    public final IllegalArgumentException invalidPemType(String expected, String actual) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidPemType$str(), expected, actual));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String certificateParseError$str() {
        return "ELY03012: Certificate parse error";
    }

    @Override
    public final IllegalArgumentException certificateParseError(CertificateException cause) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.certificateParseError$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String publicKeyParseError$str() {
        return "ELY03023: PublicKey parse error";
    }

    @Override
    public final IllegalArgumentException publicKeyParseError(Throwable cause) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.publicKeyParseError$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String privateKeyParseError$str() {
        return "ELY03033: PrivateKey parse error";
    }

    @Override
    public final IllegalArgumentException privateKeyParseError(Throwable cause) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.privateKeyParseError$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String asnUnrecognisedAlgorithm$str() {
        return "ELY07001: Unrecognized encoding algorithm [%s]";
    }

    @Override
    public final ASN1Exception asnUnrecognisedAlgorithm(String algorithm) {
        ASN1Exception result = new ASN1Exception(String.format(this.getLoggingLocale(), this.asnUnrecognisedAlgorithm$str(), algorithm));
        ElytronMessages_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String asnUnexpectedTag$str() {
        return "ELY07004: Unexpected ASN.1 tag encountered";
    }

    @Override
    public final ASN1Exception asnUnexpectedTag() {
        ASN1Exception result = new ASN1Exception(String.format(this.getLoggingLocale(), this.asnUnexpectedTag$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }
}

