/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=jpa")
@ResourceType(value="subsystem")
@Implicit
public class JPA<T extends JPA<T>>
implements Keyed {
    private String key = "jpa";
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    @AttributeDocumentation(value="The name of the default global datasource.")
    private String defaultDatasource;
    @AttributeDocumentation(value="Controls how JPA extended persistence context (XPC) inheritance is performed. 'DEEP' shares the extended persistence context at top bean level.  'SHALLOW' the extended persistece context is only shared with the parent bean (never with sibling beans).")
    private DefaultExtendedPersistenceInheritance defaultExtendedPersistenceInheritance;

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="default-datasource")
    public String defaultDatasource() {
        return this.defaultDatasource;
    }

    public T defaultDatasource(String value) {
        String oldValue = this.defaultDatasource;
        this.defaultDatasource = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("defaultDatasource", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="default-extended-persistence-inheritance")
    public DefaultExtendedPersistenceInheritance defaultExtendedPersistenceInheritance() {
        return this.defaultExtendedPersistenceInheritance;
    }

    public T defaultExtendedPersistenceInheritance(DefaultExtendedPersistenceInheritance value) {
        DefaultExtendedPersistenceInheritance oldValue = this.defaultExtendedPersistenceInheritance;
        this.defaultExtendedPersistenceInheritance = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("defaultExtendedPersistenceInheritance", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    public static enum DefaultExtendedPersistenceInheritance {
        DEEP("DEEP"),
        SHALLOW("SHALLOW");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private DefaultExtendedPersistenceInheritance(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }
}

