/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.messaging.activemq.JMSBridge;
import org.wildfly.swarm.config.messaging.activemq.JMSBridgeConsumer;
import org.wildfly.swarm.config.messaging.activemq.JMSBridgeSupplier;
import org.wildfly.swarm.config.messaging.activemq.Server;
import org.wildfly.swarm.config.messaging.activemq.ServerConsumer;
import org.wildfly.swarm.config.messaging.activemq.ServerSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=messaging-activemq")
@ResourceType(value="subsystem")
@Implicit
public class MessagingActiveMQ<T extends MessagingActiveMQ<T>>
implements Keyed {
    private String key = "messaging-activemq";
    private PropertyChangeSupport pcs;
    private MessagingActiveMQResources subresources = new MessagingActiveMQResources();
    @AttributeDocumentation(value="Maximum size of the pool of threads used by all ActiveMQ clients running inside this server. If the attribute is undefined (by default), ActiveMQ will configure it to be 8 x the number of available processors.")
    private Integer globalClientScheduledThreadPoolMaxSize;
    @AttributeDocumentation(value="Maximum size of the pool of scheduled threads used by all ActiveMQ clients running inside this server.")
    private Integer globalClientThreadPoolMaxSize;

    public MessagingActiveMQ() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public MessagingActiveMQResources subresources() {
        return this.subresources;
    }

    public T servers(List<Server> value) {
        this.subresources.servers = value;
        return (T)this;
    }

    public T server(Server value) {
        this.subresources.servers.add(value);
        return (T)this;
    }

    public T server(String childKey, ServerConsumer consumer) {
        Server child = new Server(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.server(child);
        return (T)this;
    }

    public T server(String childKey) {
        this.server(childKey, null);
        return (T)this;
    }

    public T server(ServerSupplier supplier) {
        this.server(supplier.get());
        return (T)this;
    }

    public T jmsBridges(List<JMSBridge> value) {
        this.subresources.jmsBridges = value;
        return (T)this;
    }

    public T jmsBridge(JMSBridge value) {
        this.subresources.jmsBridges.add(value);
        return (T)this;
    }

    public T jmsBridge(String childKey, JMSBridgeConsumer consumer) {
        JMSBridge child = new JMSBridge(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.jmsBridge(child);
        return (T)this;
    }

    public T jmsBridge(String childKey) {
        this.jmsBridge(childKey, null);
        return (T)this;
    }

    public T jmsBridge(JMSBridgeSupplier supplier) {
        this.jmsBridge(supplier.get());
        return (T)this;
    }

    @ModelNodeBinding(detypedName="global-client-scheduled-thread-pool-max-size")
    public Integer globalClientScheduledThreadPoolMaxSize() {
        return this.globalClientScheduledThreadPoolMaxSize;
    }

    public T globalClientScheduledThreadPoolMaxSize(Integer value) {
        Integer oldValue = this.globalClientScheduledThreadPoolMaxSize;
        this.globalClientScheduledThreadPoolMaxSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("globalClientScheduledThreadPoolMaxSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="global-client-thread-pool-max-size")
    public Integer globalClientThreadPoolMaxSize() {
        return this.globalClientThreadPoolMaxSize;
    }

    public T globalClientThreadPoolMaxSize(Integer value) {
        Integer oldValue = this.globalClientThreadPoolMaxSize;
        this.globalClientThreadPoolMaxSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("globalClientThreadPoolMaxSize", oldValue, value);
        }
        return (T)this;
    }

    public static class MessagingActiveMQResources {
        @ResourceDocumentation(value="An ActiveMQ server instance.")
        @SubresourceInfo(value="server")
        private List<Server> servers = new ArrayList<Server>();
        @ResourceDocumentation(value="A JMS bridge instance.")
        @SubresourceInfo(value="jmsBridge")
        private List<JMSBridge> jmsBridges = new ArrayList<JMSBridge>();

        @Subresource
        public List<Server> servers() {
            return this.servers;
        }

        public Server server(String key) {
            return this.servers.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<JMSBridge> jmsBridges() {
            return this.jmsBridges;
        }

        public JMSBridge jmsBridge(String key) {
            return this.jmsBridges.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

