/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.security.ClassicVault;
import org.wildfly.swarm.config.security.ClassicVaultConsumer;
import org.wildfly.swarm.config.security.ClassicVaultSupplier;
import org.wildfly.swarm.config.security.ElytronKeyManager;
import org.wildfly.swarm.config.security.ElytronKeyManagerConsumer;
import org.wildfly.swarm.config.security.ElytronKeyManagerSupplier;
import org.wildfly.swarm.config.security.ElytronKeyStore;
import org.wildfly.swarm.config.security.ElytronKeyStoreConsumer;
import org.wildfly.swarm.config.security.ElytronKeyStoreSupplier;
import org.wildfly.swarm.config.security.ElytronRealm;
import org.wildfly.swarm.config.security.ElytronRealmConsumer;
import org.wildfly.swarm.config.security.ElytronRealmSupplier;
import org.wildfly.swarm.config.security.ElytronTrustManager;
import org.wildfly.swarm.config.security.ElytronTrustManagerConsumer;
import org.wildfly.swarm.config.security.ElytronTrustManagerSupplier;
import org.wildfly.swarm.config.security.ElytronTrustStore;
import org.wildfly.swarm.config.security.ElytronTrustStoreConsumer;
import org.wildfly.swarm.config.security.ElytronTrustStoreSupplier;
import org.wildfly.swarm.config.security.SecurityDomain;
import org.wildfly.swarm.config.security.SecurityDomainConsumer;
import org.wildfly.swarm.config.security.SecurityDomainSupplier;

@Address(value="/subsystem=security")
@ResourceType(value="subsystem")
@Implicit
public class Security<T extends Security<T>>
implements Keyed {
    private String key = "security";
    private PropertyChangeSupport pcs;
    private SecurityResources subresources = new SecurityResources();
    @AttributeDocumentation(value="Sets the copy mode of subjects done by the security managers to be deep copies that makes copies of the subject principals and credentials if they are cloneable. It should be set to true if subject include mutable content that can be corrupted when multiple threads have the same identity and cache flushes/logout clearing the subject in one thread results in subject references affecting other threads.")
    private Boolean deepCopySubjectMode;
    @AttributeDocumentation(value="Indicates if this subsystem should be in charge of initializing JACC related services.")
    private Boolean initializeJacc;

    public Security() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public SecurityResources subresources() {
        return this.subresources;
    }

    public T securityDomains(List<SecurityDomain> value) {
        this.subresources.securityDomains = value;
        return (T)this;
    }

    public T securityDomain(SecurityDomain value) {
        this.subresources.securityDomains.add(value);
        return (T)this;
    }

    public T securityDomain(String childKey, SecurityDomainConsumer consumer) {
        SecurityDomain child = new SecurityDomain(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.securityDomain(child);
        return (T)this;
    }

    public T securityDomain(String childKey) {
        this.securityDomain(childKey, null);
        return (T)this;
    }

    public T securityDomain(SecurityDomainSupplier supplier) {
        this.securityDomain(supplier.get());
        return (T)this;
    }

    public T elytronTrustManagers(List<ElytronTrustManager> value) {
        this.subresources.elytronTrustManagers = value;
        return (T)this;
    }

    public T elytronTrustManager(ElytronTrustManager value) {
        this.subresources.elytronTrustManagers.add(value);
        return (T)this;
    }

    public T elytronTrustManager(String childKey, ElytronTrustManagerConsumer consumer) {
        ElytronTrustManager child = new ElytronTrustManager(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.elytronTrustManager(child);
        return (T)this;
    }

    public T elytronTrustManager(String childKey) {
        this.elytronTrustManager(childKey, null);
        return (T)this;
    }

    public T elytronTrustManager(ElytronTrustManagerSupplier supplier) {
        this.elytronTrustManager(supplier.get());
        return (T)this;
    }

    public T elytronKeyManagers(List<ElytronKeyManager> value) {
        this.subresources.elytronKeyManagers = value;
        return (T)this;
    }

    public T elytronKeyManager(ElytronKeyManager value) {
        this.subresources.elytronKeyManagers.add(value);
        return (T)this;
    }

    public T elytronKeyManager(String childKey, ElytronKeyManagerConsumer consumer) {
        ElytronKeyManager child = new ElytronKeyManager(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.elytronKeyManager(child);
        return (T)this;
    }

    public T elytronKeyManager(String childKey) {
        this.elytronKeyManager(childKey, null);
        return (T)this;
    }

    public T elytronKeyManager(ElytronKeyManagerSupplier supplier) {
        this.elytronKeyManager(supplier.get());
        return (T)this;
    }

    public T elytronTrustStores(List<ElytronTrustStore> value) {
        this.subresources.elytronTrustStores = value;
        return (T)this;
    }

    public T elytronTrustStore(ElytronTrustStore value) {
        this.subresources.elytronTrustStores.add(value);
        return (T)this;
    }

    public T elytronTrustStore(String childKey, ElytronTrustStoreConsumer consumer) {
        ElytronTrustStore child = new ElytronTrustStore(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.elytronTrustStore(child);
        return (T)this;
    }

    public T elytronTrustStore(String childKey) {
        this.elytronTrustStore(childKey, null);
        return (T)this;
    }

    public T elytronTrustStore(ElytronTrustStoreSupplier supplier) {
        this.elytronTrustStore(supplier.get());
        return (T)this;
    }

    public T elytronKeyStores(List<ElytronKeyStore> value) {
        this.subresources.elytronKeyStores = value;
        return (T)this;
    }

    public T elytronKeyStore(ElytronKeyStore value) {
        this.subresources.elytronKeyStores.add(value);
        return (T)this;
    }

    public T elytronKeyStore(String childKey, ElytronKeyStoreConsumer consumer) {
        ElytronKeyStore child = new ElytronKeyStore(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.elytronKeyStore(child);
        return (T)this;
    }

    public T elytronKeyStore(String childKey) {
        this.elytronKeyStore(childKey, null);
        return (T)this;
    }

    public T elytronKeyStore(ElytronKeyStoreSupplier supplier) {
        this.elytronKeyStore(supplier.get());
        return (T)this;
    }

    public T elytronRealms(List<ElytronRealm> value) {
        this.subresources.elytronRealms = value;
        return (T)this;
    }

    public T elytronRealm(ElytronRealm value) {
        this.subresources.elytronRealms.add(value);
        return (T)this;
    }

    public T elytronRealm(String childKey, ElytronRealmConsumer consumer) {
        ElytronRealm child = new ElytronRealm(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.elytronRealm(child);
        return (T)this;
    }

    public T elytronRealm(String childKey) {
        this.elytronRealm(childKey, null);
        return (T)this;
    }

    public T elytronRealm(ElytronRealmSupplier supplier) {
        this.elytronRealm(supplier.get());
        return (T)this;
    }

    public T classicVault(ClassicVault value) {
        this.subresources.classicVault = value;
        return (T)this;
    }

    public T classicVault(ClassicVaultConsumer consumer) {
        ClassicVault child = new ClassicVault();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.classicVault = child;
        return (T)this;
    }

    public T classicVault() {
        ClassicVault child = new ClassicVault();
        this.subresources.classicVault = child;
        return (T)this;
    }

    public T classicVault(ClassicVaultSupplier supplier) {
        this.subresources.classicVault = supplier.get();
        return (T)this;
    }

    @ModelNodeBinding(detypedName="deep-copy-subject-mode")
    public Boolean deepCopySubjectMode() {
        return this.deepCopySubjectMode;
    }

    public T deepCopySubjectMode(Boolean value) {
        Boolean oldValue = this.deepCopySubjectMode;
        this.deepCopySubjectMode = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("deepCopySubjectMode", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="initialize-jacc")
    public Boolean initializeJacc() {
        return this.initializeJacc;
    }

    public T initializeJacc(Boolean value) {
        Boolean oldValue = this.initializeJacc;
        this.initializeJacc = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("initializeJacc", oldValue, value);
        }
        return (T)this;
    }

    public static class SecurityResources {
        @ResourceDocumentation(value="Configures a security domain. Authentication, authorization, ACL, mapping, auditing and identity trust are configured here.")
        @SubresourceInfo(value="securityDomain")
        private List<SecurityDomain> securityDomains = new ArrayList<SecurityDomain>();
        @ResourceDocumentation(value="The configuration of an Elytron-compatible trust manager that is exported from a legacy JSSE domain.")
        @SubresourceInfo(value="elytronTrustManager")
        private List<ElytronTrustManager> elytronTrustManagers = new ArrayList<ElytronTrustManager>();
        @ResourceDocumentation(value="The configuration of an Elytron-compatible key manager that is exported from a legacy JSSE domain.")
        @SubresourceInfo(value="elytronKeyManager")
        private List<ElytronKeyManager> elytronKeyManagers = new ArrayList<ElytronKeyManager>();
        @ResourceDocumentation(value="The configuration of an Elytron-compatible trust store that is exported from a legacy JSSE domain.")
        @SubresourceInfo(value="elytronTrustStore")
        private List<ElytronTrustStore> elytronTrustStores = new ArrayList<ElytronTrustStore>();
        @ResourceDocumentation(value="The configuration of an Elytron-compatible key store that is exported from a legacy JSSE domain.")
        @SubresourceInfo(value="elytronKeyStore")
        private List<ElytronKeyStore> elytronKeyStores = new ArrayList<ElytronKeyStore>();
        @ResourceDocumentation(value="The configuration of an Elytron-compatible realm that delegates authentication decisions to a legacy security domain.")
        @SubresourceInfo(value="elytronRealm")
        private List<ElytronRealm> elytronRealms = new ArrayList<ElytronRealm>();
        @SingletonResource
        @ResourceDocumentation(value="Security Vault for attributes.")
        private ClassicVault classicVault;

        @Subresource
        public List<SecurityDomain> securityDomains() {
            return this.securityDomains;
        }

        public SecurityDomain securityDomain(String key) {
            return this.securityDomains.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<ElytronTrustManager> elytronTrustManagers() {
            return this.elytronTrustManagers;
        }

        public ElytronTrustManager elytronTrustManager(String key) {
            return this.elytronTrustManagers.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<ElytronKeyManager> elytronKeyManagers() {
            return this.elytronKeyManagers;
        }

        public ElytronKeyManager elytronKeyManager(String key) {
            return this.elytronKeyManagers.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<ElytronTrustStore> elytronTrustStores() {
            return this.elytronTrustStores;
        }

        public ElytronTrustStore elytronTrustStore(String key) {
            return this.elytronTrustStores.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<ElytronKeyStore> elytronKeyStores() {
            return this.elytronKeyStores;
        }

        public ElytronKeyStore elytronKeyStore(String key) {
            return this.elytronKeyStores.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<ElytronRealm> elytronRealms() {
            return this.elytronRealms;
        }

        public ElytronRealm elytronRealm(String key) {
            return this.elytronRealms.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public ClassicVault classicVault() {
            return this.classicVault;
        }
    }
}

