/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.elytron;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=elytron/chained-principal-transformer=*")
@ResourceType(value="chained-principal-transformer")
public class ChainedPrincipalTransformer<T extends ChainedPrincipalTransformer<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The referenced principal transformers to chain.")
    private List<String> principalTransformers;

    public ChainedPrincipalTransformer(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="principal-transformers")
    public List<String> principalTransformers() {
        return this.principalTransformers;
    }

    public T principalTransformers(List<String> value) {
        List<String> oldValue = this.principalTransformers;
        this.principalTransformers = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("principalTransformers", oldValue, value);
        }
        return (T)this;
    }

    public T principalTransformer(String value) {
        if (this.principalTransformers == null) {
            this.principalTransformers = new ArrayList<String>();
        }
        this.principalTransformers.add(value);
        return (T)this;
    }

    public T principalTransformers(String ... args) {
        this.principalTransformers(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }
}

