/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.messaging.activemq.server;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=messaging-activemq/server=*/address-setting=*")
@ResourceType(value="address-setting")
public class AddressSetting<T extends AddressSetting<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="Determines what happens when an address where max-size-bytes is specified becomes full. (PAGE, DROP or BLOCK)")
    private AddressFullPolicy addressFullPolicy;
    @AttributeDocumentation(value="Determines whether ActiveMQ should automatically create a JMS queue corresponding to the address-settings match when a JMS producer or a consumer is tries to use such a queue.")
    private Boolean autoCreateJmsQueues;
    @AttributeDocumentation(value="Determises Whether ActiveMQ should automatically delete auto-created JMS queues when they have no consumers and no messages.")
    private Boolean autoDeleteJmsQueues;
    @AttributeDocumentation(value="The dead letter address")
    private String deadLetterAddress;
    @AttributeDocumentation(value="Defines where to send a message that has expired.")
    private String expiryAddress;
    @AttributeDocumentation(value="Defines the expiration time that will be used for messages using the default expiration time")
    private Long expiryDelay;
    @AttributeDocumentation(value="Defines whether a queue only uses last values or not")
    private Boolean lastValueQueue;
    @AttributeDocumentation(value="Defines how many time a cancelled message can be redelivered before sending to the dead-letter-address")
    private Integer maxDeliveryAttempts;
    @AttributeDocumentation(value="Maximum value for the redelivery-delay (in ms).")
    private Long maxRedeliveryDelay;
    @AttributeDocumentation(value="The max bytes size.")
    private Long maxSizeBytes;
    @AttributeDocumentation(value="Day limit for the message counter history.")
    private Integer messageCounterHistoryDayLimit;
    @AttributeDocumentation(value="The number of page files to keep in memory to optimize IO during paging navigation.")
    private Integer pageMaxCacheSize;
    @AttributeDocumentation(value="The paging size.")
    private Long pageSizeBytes;
    @AttributeDocumentation(value="Defines how long to wait before attempting redelivery of a cancelled message")
    private Long redeliveryDelay;
    @AttributeDocumentation(value="Multiplier to apply to the redelivery-delay parameter")
    private Double redeliveryMultiplier;
    @AttributeDocumentation(value="Defines how long to wait when the last consumer is closed on a queue before redistributing any messages")
    private Long redistributionDelay;
    @AttributeDocumentation(value="If this parameter is set to true for that address, if the message is not routed to any queues it will instead be sent to the dead letter address (DLA) for that address, if it exists.")
    private Boolean sendToDlaOnNoRoute;
    @AttributeDocumentation(value="How often to check for slow consumers on a particular queue.")
    private Long slowConsumerCheckPeriod;
    @AttributeDocumentation(value="Determine what happens when a slow consumer is identified.")
    private SlowConsumerPolicy slowConsumerPolicy;
    @AttributeDocumentation(value="The minimum rate of message consumption allowed before a consumer is considered slow.")
    private Long slowConsumerThreshold;

    public AddressSetting(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="address-full-policy")
    public AddressFullPolicy addressFullPolicy() {
        return this.addressFullPolicy;
    }

    public T addressFullPolicy(AddressFullPolicy value) {
        AddressFullPolicy oldValue = this.addressFullPolicy;
        this.addressFullPolicy = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("addressFullPolicy", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="auto-create-jms-queues")
    public Boolean autoCreateJmsQueues() {
        return this.autoCreateJmsQueues;
    }

    public T autoCreateJmsQueues(Boolean value) {
        Boolean oldValue = this.autoCreateJmsQueues;
        this.autoCreateJmsQueues = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("autoCreateJmsQueues", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="auto-delete-jms-queues")
    public Boolean autoDeleteJmsQueues() {
        return this.autoDeleteJmsQueues;
    }

    public T autoDeleteJmsQueues(Boolean value) {
        Boolean oldValue = this.autoDeleteJmsQueues;
        this.autoDeleteJmsQueues = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("autoDeleteJmsQueues", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="dead-letter-address")
    public String deadLetterAddress() {
        return this.deadLetterAddress;
    }

    public T deadLetterAddress(String value) {
        String oldValue = this.deadLetterAddress;
        this.deadLetterAddress = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("deadLetterAddress", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="expiry-address")
    public String expiryAddress() {
        return this.expiryAddress;
    }

    public T expiryAddress(String value) {
        String oldValue = this.expiryAddress;
        this.expiryAddress = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("expiryAddress", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="expiry-delay")
    public Long expiryDelay() {
        return this.expiryDelay;
    }

    public T expiryDelay(Long value) {
        Long oldValue = this.expiryDelay;
        this.expiryDelay = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("expiryDelay", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="last-value-queue")
    public Boolean lastValueQueue() {
        return this.lastValueQueue;
    }

    public T lastValueQueue(Boolean value) {
        Boolean oldValue = this.lastValueQueue;
        this.lastValueQueue = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("lastValueQueue", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-delivery-attempts")
    public Integer maxDeliveryAttempts() {
        return this.maxDeliveryAttempts;
    }

    public T maxDeliveryAttempts(Integer value) {
        Integer oldValue = this.maxDeliveryAttempts;
        this.maxDeliveryAttempts = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxDeliveryAttempts", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-redelivery-delay")
    public Long maxRedeliveryDelay() {
        return this.maxRedeliveryDelay;
    }

    public T maxRedeliveryDelay(Long value) {
        Long oldValue = this.maxRedeliveryDelay;
        this.maxRedeliveryDelay = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxRedeliveryDelay", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-size-bytes")
    public Long maxSizeBytes() {
        return this.maxSizeBytes;
    }

    public T maxSizeBytes(Long value) {
        Long oldValue = this.maxSizeBytes;
        this.maxSizeBytes = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxSizeBytes", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="message-counter-history-day-limit")
    public Integer messageCounterHistoryDayLimit() {
        return this.messageCounterHistoryDayLimit;
    }

    public T messageCounterHistoryDayLimit(Integer value) {
        Integer oldValue = this.messageCounterHistoryDayLimit;
        this.messageCounterHistoryDayLimit = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("messageCounterHistoryDayLimit", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="page-max-cache-size")
    public Integer pageMaxCacheSize() {
        return this.pageMaxCacheSize;
    }

    public T pageMaxCacheSize(Integer value) {
        Integer oldValue = this.pageMaxCacheSize;
        this.pageMaxCacheSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("pageMaxCacheSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="page-size-bytes")
    public Long pageSizeBytes() {
        return this.pageSizeBytes;
    }

    public T pageSizeBytes(Long value) {
        Long oldValue = this.pageSizeBytes;
        this.pageSizeBytes = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("pageSizeBytes", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="redelivery-delay")
    public Long redeliveryDelay() {
        return this.redeliveryDelay;
    }

    public T redeliveryDelay(Long value) {
        Long oldValue = this.redeliveryDelay;
        this.redeliveryDelay = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("redeliveryDelay", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="redelivery-multiplier")
    public Double redeliveryMultiplier() {
        return this.redeliveryMultiplier;
    }

    public T redeliveryMultiplier(Double value) {
        Double oldValue = this.redeliveryMultiplier;
        this.redeliveryMultiplier = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("redeliveryMultiplier", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="redistribution-delay")
    public Long redistributionDelay() {
        return this.redistributionDelay;
    }

    public T redistributionDelay(Long value) {
        Long oldValue = this.redistributionDelay;
        this.redistributionDelay = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("redistributionDelay", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="send-to-dla-on-no-route")
    public Boolean sendToDlaOnNoRoute() {
        return this.sendToDlaOnNoRoute;
    }

    public T sendToDlaOnNoRoute(Boolean value) {
        Boolean oldValue = this.sendToDlaOnNoRoute;
        this.sendToDlaOnNoRoute = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("sendToDlaOnNoRoute", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="slow-consumer-check-period")
    public Long slowConsumerCheckPeriod() {
        return this.slowConsumerCheckPeriod;
    }

    public T slowConsumerCheckPeriod(Long value) {
        Long oldValue = this.slowConsumerCheckPeriod;
        this.slowConsumerCheckPeriod = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("slowConsumerCheckPeriod", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="slow-consumer-policy")
    public SlowConsumerPolicy slowConsumerPolicy() {
        return this.slowConsumerPolicy;
    }

    public T slowConsumerPolicy(SlowConsumerPolicy value) {
        SlowConsumerPolicy oldValue = this.slowConsumerPolicy;
        this.slowConsumerPolicy = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("slowConsumerPolicy", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="slow-consumer-threshold")
    public Long slowConsumerThreshold() {
        return this.slowConsumerThreshold;
    }

    public T slowConsumerThreshold(Long value) {
        Long oldValue = this.slowConsumerThreshold;
        this.slowConsumerThreshold = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("slowConsumerThreshold", oldValue, value);
        }
        return (T)this;
    }

    public static enum SlowConsumerPolicy {
        KILL("KILL"),
        NOTIFY("NOTIFY");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private SlowConsumerPolicy(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }

    public static enum AddressFullPolicy {
        DROP("DROP"),
        PAGE("PAGE"),
        BLOCK("BLOCK"),
        FAIL("FAIL");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private AddressFullPolicy(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }
}

