/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.modcluster;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.modcluster.mod_cluster_config.ConfigurationDynamicLoadProvider;
import org.wildfly.swarm.config.modcluster.mod_cluster_config.ConfigurationDynamicLoadProviderConsumer;
import org.wildfly.swarm.config.modcluster.mod_cluster_config.ConfigurationDynamicLoadProviderSupplier;
import org.wildfly.swarm.config.modcluster.mod_cluster_config.ConfigurationSsl;
import org.wildfly.swarm.config.modcluster.mod_cluster_config.ConfigurationSslConsumer;
import org.wildfly.swarm.config.modcluster.mod_cluster_config.ConfigurationSslSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Subresource;

@Address(value="/subsystem=modcluster/mod-cluster-config=configuration")
@ResourceType(value="mod-cluster-config")
@Implicit
public class ConfigurationModClusterConfig<T extends ConfigurationModClusterConfig<T>>
implements Keyed {
    private String key = "configuration";
    private PropertyChangeSupport pcs;
    private ConfigurationModClusterConfigResources subresources = new ConfigurationModClusterConfigResources();
    @AttributeDocumentation(value="Whether to enable multicast-based advertise mechanism.")
    private Boolean advertise;
    @AttributeDocumentation(value="If specified, reverse proxy advertisements checksums will be verified using this value as a salt.")
    private String advertiseSecurityKey;
    @AttributeDocumentation(value="Name of socket binding to use for the advertise socket.")
    private String advertiseSocket;
    @AttributeDocumentation(value="If false, the contexts are registered with the reverse proxy as disabled; they need to be enabled via the enable-context operation or via mod_cluster_manager console.")
    private Boolean autoEnableContexts;
    @AttributeDocumentation(value="The name of the balancer on the reverse proxy to register with.")
    private String balancer;
    @AttributeDocumentation(value="The name of Undertow listener that will be registered with the reverse proxy.")
    private String connector;
    @AttributeDocumentation(value="List of contexts to exclude from registration with the reverse proxies.")
    private String excludedContexts;
    @AttributeDocumentation(value="Whether to enable packet flushing on the reverse proxy.")
    private Boolean flushPackets;
    @AttributeDocumentation(value="Time to wait before flushing packets on the reverse proxy.")
    private Integer flushWait;
    @AttributeDocumentation(value="Name of the load balancing group this node belongs to.")
    private String loadBalancingGroup;
    @AttributeDocumentation(value="Number of times the reverse proxy will attempt to send a given request to a worker before giving up.")
    private Integer maxAttempts;
    @AttributeDocumentation(value="Timeout (in seconds) for proxy connections to a node. That is the time mod_cluster will wait for the back-end response before returning an error.")
    private Integer nodeTimeout;
    @AttributeDocumentation(value="Time (in seconds) in which to wait for a pong answer to a ping.")
    private Integer ping;
    @AttributeDocumentation(value="List of reverse proxies for mod_cluster to register with defined by outbound-socket-binding in socket-binding-group.")
    private List<String> proxies;
    @AttributeDocumentation(value="Base URL for MCMP requests.")
    private String proxyUrl;
    @AttributeDocumentation(value="Session draining strategy used during undeployment of a web application.")
    private SessionDrainingStrategy sessionDrainingStrategy;
    @AttributeDocumentation(value="Simple load provider configuration.")
    private Integer simpleLoadProvider;
    @AttributeDocumentation(value="Soft maximum idle connection count for reverse proxy.")
    private Integer smax;
    @AttributeDocumentation(value="Timeout to wait for the reverse proxy to answer a MCMP message.")
    private Integer socketTimeout;
    @AttributeDocumentation(value="Reference to the SSLContext to be used by mod_cluster.")
    private String sslContext;
    @AttributeDocumentation(value="Number of seconds a STATUS message is sent from the application server to the proxy.")
    private Integer statusInterval;
    @AttributeDocumentation(value="Indicates whether subsequent requests for a given session should be routed to the same node, if possible.")
    private Boolean stickySession;
    @AttributeDocumentation(value="Indicates whether the reverse proxy should return an error in the event that the balancer is unable to route a request to the node to which it is stuck. Ignored if sticky sessions are disabled.")
    private Boolean stickySessionForce;
    @AttributeDocumentation(value="Indicates whether the reverse proxy should remove session stickiness in the event that the balancer is unable to route a request to the node to which it is stuck. Ignored if sticky sessions are disabled.")
    private Boolean stickySessionRemove;
    @AttributeDocumentation(value="Maximum time to wait for context to process pending requests.")
    private Integer stopContextTimeout;
    @AttributeDocumentation(value="Time to live (in seconds) for idle connections above smax.")
    private Integer ttl;
    @AttributeDocumentation(value="Number of seconds to wait for a worker to become available to handle a request.")
    private Integer workerTimeout;

    public ConfigurationModClusterConfig() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public ConfigurationModClusterConfigResources subresources() {
        return this.subresources;
    }

    public T configurationSsl(ConfigurationSsl value) {
        this.subresources.configurationSsl = value;
        return (T)this;
    }

    public T configurationSsl(ConfigurationSslConsumer consumer) {
        ConfigurationSsl child = new ConfigurationSsl();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.configurationSsl = child;
        return (T)this;
    }

    public T configurationSsl() {
        ConfigurationSsl child = new ConfigurationSsl();
        this.subresources.configurationSsl = child;
        return (T)this;
    }

    public T configurationSsl(ConfigurationSslSupplier supplier) {
        this.subresources.configurationSsl = supplier.get();
        return (T)this;
    }

    public T configurationDynamicLoadProvider(ConfigurationDynamicLoadProvider value) {
        this.subresources.configurationDynamicLoadProvider = value;
        return (T)this;
    }

    public T configurationDynamicLoadProvider(ConfigurationDynamicLoadProviderConsumer consumer) {
        ConfigurationDynamicLoadProvider child = new ConfigurationDynamicLoadProvider();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.configurationDynamicLoadProvider = child;
        return (T)this;
    }

    public T configurationDynamicLoadProvider() {
        ConfigurationDynamicLoadProvider child = new ConfigurationDynamicLoadProvider();
        this.subresources.configurationDynamicLoadProvider = child;
        return (T)this;
    }

    public T configurationDynamicLoadProvider(ConfigurationDynamicLoadProviderSupplier supplier) {
        this.subresources.configurationDynamicLoadProvider = supplier.get();
        return (T)this;
    }

    @ModelNodeBinding(detypedName="advertise")
    public Boolean advertise() {
        return this.advertise;
    }

    public T advertise(Boolean value) {
        Boolean oldValue = this.advertise;
        this.advertise = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("advertise", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="advertise-security-key")
    public String advertiseSecurityKey() {
        return this.advertiseSecurityKey;
    }

    public T advertiseSecurityKey(String value) {
        String oldValue = this.advertiseSecurityKey;
        this.advertiseSecurityKey = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("advertiseSecurityKey", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="advertise-socket")
    public String advertiseSocket() {
        return this.advertiseSocket;
    }

    public T advertiseSocket(String value) {
        String oldValue = this.advertiseSocket;
        this.advertiseSocket = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("advertiseSocket", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="auto-enable-contexts")
    public Boolean autoEnableContexts() {
        return this.autoEnableContexts;
    }

    public T autoEnableContexts(Boolean value) {
        Boolean oldValue = this.autoEnableContexts;
        this.autoEnableContexts = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("autoEnableContexts", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="balancer")
    public String balancer() {
        return this.balancer;
    }

    public T balancer(String value) {
        String oldValue = this.balancer;
        this.balancer = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("balancer", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="connector")
    public String connector() {
        return this.connector;
    }

    public T connector(String value) {
        String oldValue = this.connector;
        this.connector = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("connector", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="excluded-contexts")
    public String excludedContexts() {
        return this.excludedContexts;
    }

    public T excludedContexts(String value) {
        String oldValue = this.excludedContexts;
        this.excludedContexts = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("excludedContexts", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="flush-packets")
    public Boolean flushPackets() {
        return this.flushPackets;
    }

    public T flushPackets(Boolean value) {
        Boolean oldValue = this.flushPackets;
        this.flushPackets = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("flushPackets", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="flush-wait")
    public Integer flushWait() {
        return this.flushWait;
    }

    public T flushWait(Integer value) {
        Integer oldValue = this.flushWait;
        this.flushWait = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("flushWait", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="load-balancing-group")
    public String loadBalancingGroup() {
        return this.loadBalancingGroup;
    }

    public T loadBalancingGroup(String value) {
        String oldValue = this.loadBalancingGroup;
        this.loadBalancingGroup = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("loadBalancingGroup", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-attempts")
    public Integer maxAttempts() {
        return this.maxAttempts;
    }

    public T maxAttempts(Integer value) {
        Integer oldValue = this.maxAttempts;
        this.maxAttempts = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxAttempts", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="node-timeout")
    public Integer nodeTimeout() {
        return this.nodeTimeout;
    }

    public T nodeTimeout(Integer value) {
        Integer oldValue = this.nodeTimeout;
        this.nodeTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("nodeTimeout", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="ping")
    public Integer ping() {
        return this.ping;
    }

    public T ping(Integer value) {
        Integer oldValue = this.ping;
        this.ping = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("ping", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="proxies")
    public List<String> proxies() {
        return this.proxies;
    }

    public T proxies(List<String> value) {
        List<String> oldValue = this.proxies;
        this.proxies = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("proxies", oldValue, value);
        }
        return (T)this;
    }

    public T proxy(String value) {
        if (this.proxies == null) {
            this.proxies = new ArrayList<String>();
        }
        this.proxies.add(value);
        return (T)this;
    }

    public T proxies(String ... args) {
        this.proxies(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="proxy-url")
    public String proxyUrl() {
        return this.proxyUrl;
    }

    public T proxyUrl(String value) {
        String oldValue = this.proxyUrl;
        this.proxyUrl = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("proxyUrl", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="session-draining-strategy")
    public SessionDrainingStrategy sessionDrainingStrategy() {
        return this.sessionDrainingStrategy;
    }

    public T sessionDrainingStrategy(SessionDrainingStrategy value) {
        SessionDrainingStrategy oldValue = this.sessionDrainingStrategy;
        this.sessionDrainingStrategy = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("sessionDrainingStrategy", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="simple-load-provider")
    public Integer simpleLoadProvider() {
        return this.simpleLoadProvider;
    }

    public T simpleLoadProvider(Integer value) {
        Integer oldValue = this.simpleLoadProvider;
        this.simpleLoadProvider = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("simpleLoadProvider", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="smax")
    public Integer smax() {
        return this.smax;
    }

    public T smax(Integer value) {
        Integer oldValue = this.smax;
        this.smax = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("smax", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="socket-timeout")
    public Integer socketTimeout() {
        return this.socketTimeout;
    }

    public T socketTimeout(Integer value) {
        Integer oldValue = this.socketTimeout;
        this.socketTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("socketTimeout", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="ssl-context")
    public String sslContext() {
        return this.sslContext;
    }

    public T sslContext(String value) {
        String oldValue = this.sslContext;
        this.sslContext = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("sslContext", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="status-interval")
    public Integer statusInterval() {
        return this.statusInterval;
    }

    public T statusInterval(Integer value) {
        Integer oldValue = this.statusInterval;
        this.statusInterval = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("statusInterval", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="sticky-session")
    public Boolean stickySession() {
        return this.stickySession;
    }

    public T stickySession(Boolean value) {
        Boolean oldValue = this.stickySession;
        this.stickySession = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("stickySession", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="sticky-session-force")
    public Boolean stickySessionForce() {
        return this.stickySessionForce;
    }

    public T stickySessionForce(Boolean value) {
        Boolean oldValue = this.stickySessionForce;
        this.stickySessionForce = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("stickySessionForce", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="sticky-session-remove")
    public Boolean stickySessionRemove() {
        return this.stickySessionRemove;
    }

    public T stickySessionRemove(Boolean value) {
        Boolean oldValue = this.stickySessionRemove;
        this.stickySessionRemove = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("stickySessionRemove", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="stop-context-timeout")
    public Integer stopContextTimeout() {
        return this.stopContextTimeout;
    }

    public T stopContextTimeout(Integer value) {
        Integer oldValue = this.stopContextTimeout;
        this.stopContextTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("stopContextTimeout", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="ttl")
    public Integer ttl() {
        return this.ttl;
    }

    public T ttl(Integer value) {
        Integer oldValue = this.ttl;
        this.ttl = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("ttl", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="worker-timeout")
    public Integer workerTimeout() {
        return this.workerTimeout;
    }

    public T workerTimeout(Integer value) {
        Integer oldValue = this.workerTimeout;
        this.workerTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("workerTimeout", oldValue, value);
        }
        return (T)this;
    }

    public static enum SessionDrainingStrategy {
        DEFAULT("DEFAULT"),
        ALWAYS("ALWAYS"),
        NEVER("NEVER");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private SessionDrainingStrategy(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }

    public static class ConfigurationModClusterConfigResources {
        @SingletonResource
        @ResourceDocumentation(value="The SSL configuration to client MCMP logic.")
        private ConfigurationSsl configurationSsl;
        @SingletonResource
        @ResourceDocumentation(value="Dynamic load provider configuration.")
        private ConfigurationDynamicLoadProvider configurationDynamicLoadProvider;

        @Subresource
        public ConfigurationSsl configurationSsl() {
            return this.configurationSsl;
        }

        @Subresource
        public ConfigurationDynamicLoadProvider configurationDynamicLoadProvider() {
            return this.configurationDynamicLoadProvider;
        }
    }
}

