/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.resource.adapters.resource_adapter;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wildfly.swarm.config.resource.adapters.resource_adapter.ConfigProperties;
import org.wildfly.swarm.config.resource.adapters.resource_adapter.ConfigPropertiesConsumer;
import org.wildfly.swarm.config.resource.adapters.resource_adapter.ConfigPropertiesSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=resource-adapters/resource-adapter=*/connection-definitions=*")
@ResourceType(value="connection-definitions")
public class ConnectionDefinitions<T extends ConnectionDefinitions<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    private ConnectionDefinitionsResources subresources = new ConnectionDefinitionsResources();
    @AttributeDocumentation(value="The allocation retry element indicates the number of times that allocating a connection should be tried before throwing an exception.")
    private Integer allocationRetry;
    @AttributeDocumentation(value="The allocation retry wait millis element specifies the amount of time, in milliseconds, to wait between retrying to allocate a connection.")
    private Long allocationRetryWaitMillis;
    @AttributeDocumentation(value="The Elytron authentication context which defines the javax.security.auth.Subject that is used to distinguish connections in the pool.")
    private String authenticationContext;
    @AttributeDocumentation(value="Indicates that either application-supplied parameters, such as from getConnection(user, pw), or Subject (provided by Elytron after authenticating using configured authentication-context), are used to distinguish connections in the pool.")
    private String authenticationContextAndApplication;
    @AttributeDocumentation(value="An element to specify that connections should be validated on a background thread versus being validated prior to use. Changing this value requires a server restart.")
    private Boolean backgroundValidation;
    @AttributeDocumentation(value="The background-validation-millis element specifies the amount of time, in milliseconds, that background validation will run. Changing this value requires a server restart.")
    private Long backgroundValidationMillis;
    @AttributeDocumentation(value="The blocking-timeout-millis element specifies the maximum time, in milliseconds, to block while waiting for a connection before throwing an exception. Note that this blocks only while waiting for locking a connection, and will never throw an exception if creating a new connection takes an inordinately long time.")
    private Long blockingTimeoutWaitMillis;
    @AttributeDocumentation(value="Class defining the policy for decrementing connections in the pool.")
    private String capacityDecrementerClass;
    @AttributeDocumentation(value="Properties to inject in class defining the policy for decrementing connections in the pool.")
    private Map capacityDecrementerProperties;
    @AttributeDocumentation(value="Class defining the policy for incrementing connections in the pool.")
    private String capacityIncrementerClass;
    @AttributeDocumentation(value="Properties to inject in class defining the policy for incrementing connections in the pool.")
    private Map capacityIncrementerProperties;
    @AttributeDocumentation(value="Specifies the fully qualified class name of a managed connection factory or admin object.")
    private String className;
    @AttributeDocumentation(value="Enable the use of CMR. This feature means that a local resource can reliably participate in an XA transaction.")
    private Boolean connectable;
    @AttributeDocumentation(value="Enables Elytron security for handling authentication of connections. The Elytron authentication-context to be used will be current context if no context is specified (see authentication-context).")
    private Boolean elytronEnabled;
    @AttributeDocumentation(value="Specifies if the resource adapter should be enabled.")
    private Boolean enabled;
    @AttributeDocumentation(value="Defines if lazy enlistment should be used if supported by the resource adapter.")
    private Boolean enlistment;
    @AttributeDocumentation(value="Defines if WildFly/IronJacamar should record enlistment traces.")
    private Boolean enlistmentTrace;
    @AttributeDocumentation(value="Specifies how the pool should be flushed in case of an error.")
    private FlushStrategy flushStrategy;
    @AttributeDocumentation(value="Specifies the maximum time, in minutes, a connection may be idle before being closed. The actual maximum time depends also on the IdleRemover scan time, which is half of the smallest idle-timeout-minutes value of any pool. Changing this value requires a server restart.")
    private Long idleTimeoutMinutes;
    @AttributeDocumentation(value="Specifies the initial number of connections a pool should hold.")
    private Integer initialPoolSize;
    @AttributeDocumentation(value="An element to enable interleaving for XA connections.")
    private Boolean interleaving;
    @AttributeDocumentation(value="Specifies the JNDI name for the connection factory.")
    private String jndiName;
    @AttributeDocumentation(value="Specifies the maximum number of connections for a pool. No more connections will be created in each sub-pool.")
    private Integer maxPoolSize;
    @AttributeDocumentation(value="Defines the ManagedConnectionPool implementation. For example: org.jboss.jca.core.connectionmanager.pool.mcp.SemaphoreArrayListManagedConnectionPool.")
    private String mcp;
    @AttributeDocumentation(value="Specifies the minimum number of connections for a pool.")
    private Integer minPoolSize;
    @AttributeDocumentation(value="Specifies if the connection pool should be excluded from recovery.")
    private Boolean noRecovery;
    @AttributeDocumentation(value="Oracle does not like XA connections getting used both inside and outside a JTA transaction. To workaround the problem you can create separate sub-pools for the different contexts.")
    private Boolean noTxSeparatePool;
    @AttributeDocumentation(value="Specifies whether the Xid should be padded.")
    private Boolean padXid;
    @AttributeDocumentation(value="Defines if pool use should be fair.")
    private Boolean poolFair;
    @AttributeDocumentation(value="Specifies if the pool should be prefilled. Changing this value requires a server restart.")
    private Boolean poolPrefill;
    @AttributeDocumentation(value="Specifies if the min-pool-size should be considered strict.")
    private Boolean poolUseStrictMin;
    @AttributeDocumentation(value="The Elytron authentication context used for recovery (current authentication-context will be used if unspecified).")
    private String recoveryAuthenticationContext;
    @AttributeDocumentation(value="Credential (from Credential Store) to authenticate on recovery connection")
    private Map recoveryCredentialReference;
    @AttributeDocumentation(value="Indicates that an Elytron authentication context will be used for recovery.")
    private Boolean recoveryElytronEnabled;
    @AttributeDocumentation(value="The password used for recovery.")
    private String recoveryPassword;
    @AttributeDocumentation(value="The fully qualified class name of the recovery plugin implementation.")
    private String recoveryPluginClassName;
    @AttributeDocumentation(value="The properties for the recovery plugin.")
    private Map recoveryPluginProperties;
    @AttributeDocumentation(value="The PicketBox security domain used for recovery.")
    private String recoverySecurityDomain;
    @AttributeDocumentation(value="The user name used for recovery.")
    private String recoveryUsername;
    @AttributeDocumentation(value="Using this attribute, you can unconditionally set whether javax.transaction.xa.XAResource.isSameRM(XAResource) returns true or false.")
    private Boolean sameRmOverride;
    @AttributeDocumentation(value="Indicates that application-supplied parameters, such as from getConnection(user, pw), are used to distinguish connections in the pool.")
    private Boolean securityApplication;
    @AttributeDocumentation(value="Specifies the PicketBox security domain which defines the javax.security.auth.Subject that is used to distinguish connections in the pool.")
    private String securityDomain;
    @AttributeDocumentation(value="Indicates that either application-supplied parameters, such as from getConnection(user, pw), or Subject (from PicketBox security domain), are used to distinguish connections in the pool.")
    private String securityDomainAndApplication;
    @AttributeDocumentation(value="Enable the use of sharable connections, which allows lazy association to be enabled if supported.")
    private Boolean sharable;
    @AttributeDocumentation(value="Defines if IronJacamar should track connection handles across transaction boundaries.")
    private Boolean tracking;
    @AttributeDocumentation(value="Enable the use of a cached connection manager.")
    private Boolean useCcm;
    @AttributeDocumentation(value="Whether to fail a connection allocation on the first try if it is invalid (true) or keep trying until the pool is exhausted of all potential connections (false).")
    private Boolean useFastFail;
    @AttributeDocumentation(value="Setting this to false will bind the object into global JNDI.")
    private Boolean useJavaContext;
    @AttributeDocumentation(value="This specifies if connection validation should be done when a connection factory attempts to match a managed connection. This is typically exclusive to the use of background validation.")
    private Boolean validateOnMatch;
    @AttributeDocumentation(value="Specifies whether XAResource instances should be wrapped in an org.jboss.tm.XAResourceWrapper instance.")
    private Boolean wrapXaResource;
    @AttributeDocumentation(value="The value is passed to XAResource.setTransactionTimeout(), in seconds.")
    private Integer xaResourceTimeout;

    public ConnectionDefinitions(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public ConnectionDefinitionsResources subresources() {
        return this.subresources;
    }

    public T configProperties(List<ConfigProperties> value) {
        this.subresources.configProperties = value;
        return (T)this;
    }

    public T configProperties(ConfigProperties value) {
        this.subresources.configProperties.add(value);
        return (T)this;
    }

    public T configProperties(String childKey, ConfigPropertiesConsumer consumer) {
        ConfigProperties child = new ConfigProperties(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.configProperties(child);
        return (T)this;
    }

    public T configProperties(String childKey) {
        this.configProperties(childKey, null);
        return (T)this;
    }

    public T configProperties(ConfigPropertiesSupplier supplier) {
        this.configProperties(supplier.get());
        return (T)this;
    }

    @ModelNodeBinding(detypedName="allocation-retry")
    public Integer allocationRetry() {
        return this.allocationRetry;
    }

    public T allocationRetry(Integer value) {
        Integer oldValue = this.allocationRetry;
        this.allocationRetry = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("allocationRetry", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="allocation-retry-wait-millis")
    public Long allocationRetryWaitMillis() {
        return this.allocationRetryWaitMillis;
    }

    public T allocationRetryWaitMillis(Long value) {
        Long oldValue = this.allocationRetryWaitMillis;
        this.allocationRetryWaitMillis = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("allocationRetryWaitMillis", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="authentication-context")
    public String authenticationContext() {
        return this.authenticationContext;
    }

    public T authenticationContext(String value) {
        String oldValue = this.authenticationContext;
        this.authenticationContext = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("authenticationContext", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="authentication-context-and-application")
    public String authenticationContextAndApplication() {
        return this.authenticationContextAndApplication;
    }

    public T authenticationContextAndApplication(String value) {
        String oldValue = this.authenticationContextAndApplication;
        this.authenticationContextAndApplication = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("authenticationContextAndApplication", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="background-validation")
    public Boolean backgroundValidation() {
        return this.backgroundValidation;
    }

    public T backgroundValidation(Boolean value) {
        Boolean oldValue = this.backgroundValidation;
        this.backgroundValidation = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("backgroundValidation", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="background-validation-millis")
    public Long backgroundValidationMillis() {
        return this.backgroundValidationMillis;
    }

    public T backgroundValidationMillis(Long value) {
        Long oldValue = this.backgroundValidationMillis;
        this.backgroundValidationMillis = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("backgroundValidationMillis", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="blocking-timeout-wait-millis")
    public Long blockingTimeoutWaitMillis() {
        return this.blockingTimeoutWaitMillis;
    }

    public T blockingTimeoutWaitMillis(Long value) {
        Long oldValue = this.blockingTimeoutWaitMillis;
        this.blockingTimeoutWaitMillis = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("blockingTimeoutWaitMillis", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="capacity-decrementer-class")
    public String capacityDecrementerClass() {
        return this.capacityDecrementerClass;
    }

    public T capacityDecrementerClass(String value) {
        String oldValue = this.capacityDecrementerClass;
        this.capacityDecrementerClass = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("capacityDecrementerClass", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="capacity-decrementer-properties")
    public Map capacityDecrementerProperties() {
        return this.capacityDecrementerProperties;
    }

    public T capacityDecrementerProperties(Map value) {
        Map oldValue = this.capacityDecrementerProperties;
        this.capacityDecrementerProperties = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("capacityDecrementerProperties", oldValue, value);
        }
        return (T)this;
    }

    public T capacityDecrementerProperty(String key, Object value) {
        if (this.capacityDecrementerProperties == null) {
            this.capacityDecrementerProperties = new HashMap();
        }
        this.capacityDecrementerProperties.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="capacity-incrementer-class")
    public String capacityIncrementerClass() {
        return this.capacityIncrementerClass;
    }

    public T capacityIncrementerClass(String value) {
        String oldValue = this.capacityIncrementerClass;
        this.capacityIncrementerClass = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("capacityIncrementerClass", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="capacity-incrementer-properties")
    public Map capacityIncrementerProperties() {
        return this.capacityIncrementerProperties;
    }

    public T capacityIncrementerProperties(Map value) {
        Map oldValue = this.capacityIncrementerProperties;
        this.capacityIncrementerProperties = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("capacityIncrementerProperties", oldValue, value);
        }
        return (T)this;
    }

    public T capacityIncrementerProperty(String key, Object value) {
        if (this.capacityIncrementerProperties == null) {
            this.capacityIncrementerProperties = new HashMap();
        }
        this.capacityIncrementerProperties.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="class-name")
    public String className() {
        return this.className;
    }

    public T className(String value) {
        String oldValue = this.className;
        this.className = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("className", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="connectable")
    public Boolean connectable() {
        return this.connectable;
    }

    public T connectable(Boolean value) {
        Boolean oldValue = this.connectable;
        this.connectable = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("connectable", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="elytron-enabled")
    public Boolean elytronEnabled() {
        return this.elytronEnabled;
    }

    public T elytronEnabled(Boolean value) {
        Boolean oldValue = this.elytronEnabled;
        this.elytronEnabled = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("elytronEnabled", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="enabled")
    public Boolean enabled() {
        return this.enabled;
    }

    public T enabled(Boolean value) {
        Boolean oldValue = this.enabled;
        this.enabled = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("enabled", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="enlistment")
    public Boolean enlistment() {
        return this.enlistment;
    }

    public T enlistment(Boolean value) {
        Boolean oldValue = this.enlistment;
        this.enlistment = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("enlistment", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="enlistment-trace")
    public Boolean enlistmentTrace() {
        return this.enlistmentTrace;
    }

    public T enlistmentTrace(Boolean value) {
        Boolean oldValue = this.enlistmentTrace;
        this.enlistmentTrace = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("enlistmentTrace", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="flush-strategy")
    public FlushStrategy flushStrategy() {
        return this.flushStrategy;
    }

    public T flushStrategy(FlushStrategy value) {
        FlushStrategy oldValue = this.flushStrategy;
        this.flushStrategy = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("flushStrategy", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="idle-timeout-minutes")
    public Long idleTimeoutMinutes() {
        return this.idleTimeoutMinutes;
    }

    public T idleTimeoutMinutes(Long value) {
        Long oldValue = this.idleTimeoutMinutes;
        this.idleTimeoutMinutes = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("idleTimeoutMinutes", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="initial-pool-size")
    public Integer initialPoolSize() {
        return this.initialPoolSize;
    }

    public T initialPoolSize(Integer value) {
        Integer oldValue = this.initialPoolSize;
        this.initialPoolSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("initialPoolSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="interleaving")
    public Boolean interleaving() {
        return this.interleaving;
    }

    public T interleaving(Boolean value) {
        Boolean oldValue = this.interleaving;
        this.interleaving = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("interleaving", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="jndi-name")
    public String jndiName() {
        return this.jndiName;
    }

    public T jndiName(String value) {
        String oldValue = this.jndiName;
        this.jndiName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("jndiName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-pool-size")
    public Integer maxPoolSize() {
        return this.maxPoolSize;
    }

    public T maxPoolSize(Integer value) {
        Integer oldValue = this.maxPoolSize;
        this.maxPoolSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxPoolSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="mcp")
    public String mcp() {
        return this.mcp;
    }

    public T mcp(String value) {
        String oldValue = this.mcp;
        this.mcp = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("mcp", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="min-pool-size")
    public Integer minPoolSize() {
        return this.minPoolSize;
    }

    public T minPoolSize(Integer value) {
        Integer oldValue = this.minPoolSize;
        this.minPoolSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("minPoolSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="no-recovery")
    public Boolean noRecovery() {
        return this.noRecovery;
    }

    public T noRecovery(Boolean value) {
        Boolean oldValue = this.noRecovery;
        this.noRecovery = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("noRecovery", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="no-tx-separate-pool")
    public Boolean noTxSeparatePool() {
        return this.noTxSeparatePool;
    }

    public T noTxSeparatePool(Boolean value) {
        Boolean oldValue = this.noTxSeparatePool;
        this.noTxSeparatePool = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("noTxSeparatePool", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="pad-xid")
    public Boolean padXid() {
        return this.padXid;
    }

    public T padXid(Boolean value) {
        Boolean oldValue = this.padXid;
        this.padXid = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("padXid", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="pool-fair")
    public Boolean poolFair() {
        return this.poolFair;
    }

    public T poolFair(Boolean value) {
        Boolean oldValue = this.poolFair;
        this.poolFair = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("poolFair", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="pool-prefill")
    public Boolean poolPrefill() {
        return this.poolPrefill;
    }

    public T poolPrefill(Boolean value) {
        Boolean oldValue = this.poolPrefill;
        this.poolPrefill = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("poolPrefill", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="pool-use-strict-min")
    public Boolean poolUseStrictMin() {
        return this.poolUseStrictMin;
    }

    public T poolUseStrictMin(Boolean value) {
        Boolean oldValue = this.poolUseStrictMin;
        this.poolUseStrictMin = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("poolUseStrictMin", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="recovery-authentication-context")
    public String recoveryAuthenticationContext() {
        return this.recoveryAuthenticationContext;
    }

    public T recoveryAuthenticationContext(String value) {
        String oldValue = this.recoveryAuthenticationContext;
        this.recoveryAuthenticationContext = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("recoveryAuthenticationContext", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="recovery-credential-reference")
    public Map recoveryCredentialReference() {
        return this.recoveryCredentialReference;
    }

    public T recoveryCredentialReference(Map value) {
        Map oldValue = this.recoveryCredentialReference;
        this.recoveryCredentialReference = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("recoveryCredentialReference", oldValue, value);
        }
        return (T)this;
    }

    public T recoveryCredentialReference(String key, Object value) {
        if (this.recoveryCredentialReference == null) {
            this.recoveryCredentialReference = new HashMap();
        }
        this.recoveryCredentialReference.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="recovery-elytron-enabled")
    public Boolean recoveryElytronEnabled() {
        return this.recoveryElytronEnabled;
    }

    public T recoveryElytronEnabled(Boolean value) {
        Boolean oldValue = this.recoveryElytronEnabled;
        this.recoveryElytronEnabled = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("recoveryElytronEnabled", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="recovery-password")
    public String recoveryPassword() {
        return this.recoveryPassword;
    }

    public T recoveryPassword(String value) {
        String oldValue = this.recoveryPassword;
        this.recoveryPassword = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("recoveryPassword", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="recovery-plugin-class-name")
    public String recoveryPluginClassName() {
        return this.recoveryPluginClassName;
    }

    public T recoveryPluginClassName(String value) {
        String oldValue = this.recoveryPluginClassName;
        this.recoveryPluginClassName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("recoveryPluginClassName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="recovery-plugin-properties")
    public Map recoveryPluginProperties() {
        return this.recoveryPluginProperties;
    }

    public T recoveryPluginProperties(Map value) {
        Map oldValue = this.recoveryPluginProperties;
        this.recoveryPluginProperties = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("recoveryPluginProperties", oldValue, value);
        }
        return (T)this;
    }

    public T recoveryPluginProperty(String key, Object value) {
        if (this.recoveryPluginProperties == null) {
            this.recoveryPluginProperties = new HashMap();
        }
        this.recoveryPluginProperties.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="recovery-security-domain")
    public String recoverySecurityDomain() {
        return this.recoverySecurityDomain;
    }

    public T recoverySecurityDomain(String value) {
        String oldValue = this.recoverySecurityDomain;
        this.recoverySecurityDomain = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("recoverySecurityDomain", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="recovery-username")
    public String recoveryUsername() {
        return this.recoveryUsername;
    }

    public T recoveryUsername(String value) {
        String oldValue = this.recoveryUsername;
        this.recoveryUsername = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("recoveryUsername", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="same-rm-override")
    public Boolean sameRmOverride() {
        return this.sameRmOverride;
    }

    public T sameRmOverride(Boolean value) {
        Boolean oldValue = this.sameRmOverride;
        this.sameRmOverride = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("sameRmOverride", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="security-application")
    public Boolean securityApplication() {
        return this.securityApplication;
    }

    public T securityApplication(Boolean value) {
        Boolean oldValue = this.securityApplication;
        this.securityApplication = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("securityApplication", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="security-domain")
    public String securityDomain() {
        return this.securityDomain;
    }

    public T securityDomain(String value) {
        String oldValue = this.securityDomain;
        this.securityDomain = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("securityDomain", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="security-domain-and-application")
    public String securityDomainAndApplication() {
        return this.securityDomainAndApplication;
    }

    public T securityDomainAndApplication(String value) {
        String oldValue = this.securityDomainAndApplication;
        this.securityDomainAndApplication = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("securityDomainAndApplication", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="sharable")
    public Boolean sharable() {
        return this.sharable;
    }

    public T sharable(Boolean value) {
        Boolean oldValue = this.sharable;
        this.sharable = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("sharable", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="tracking")
    public Boolean tracking() {
        return this.tracking;
    }

    public T tracking(Boolean value) {
        Boolean oldValue = this.tracking;
        this.tracking = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("tracking", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="use-ccm")
    public Boolean useCcm() {
        return this.useCcm;
    }

    public T useCcm(Boolean value) {
        Boolean oldValue = this.useCcm;
        this.useCcm = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("useCcm", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="use-fast-fail")
    public Boolean useFastFail() {
        return this.useFastFail;
    }

    public T useFastFail(Boolean value) {
        Boolean oldValue = this.useFastFail;
        this.useFastFail = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("useFastFail", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="use-java-context")
    public Boolean useJavaContext() {
        return this.useJavaContext;
    }

    public T useJavaContext(Boolean value) {
        Boolean oldValue = this.useJavaContext;
        this.useJavaContext = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("useJavaContext", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="validate-on-match")
    public Boolean validateOnMatch() {
        return this.validateOnMatch;
    }

    public T validateOnMatch(Boolean value) {
        Boolean oldValue = this.validateOnMatch;
        this.validateOnMatch = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("validateOnMatch", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="wrap-xa-resource")
    public Boolean wrapXaResource() {
        return this.wrapXaResource;
    }

    public T wrapXaResource(Boolean value) {
        Boolean oldValue = this.wrapXaResource;
        this.wrapXaResource = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("wrapXaResource", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="xa-resource-timeout")
    public Integer xaResourceTimeout() {
        return this.xaResourceTimeout;
    }

    public T xaResourceTimeout(Integer value) {
        Integer oldValue = this.xaResourceTimeout;
        this.xaResourceTimeout = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("xaResourceTimeout", oldValue, value);
        }
        return (T)this;
    }

    public static enum FlushStrategy {
        FAILINGCONNECTIONONLY("FailingConnectionOnly"),
        INVALIDIDLECONNECTIONS("InvalidIdleConnections"),
        IDLECONNECTIONS("IdleConnections"),
        GRACEFULLY("Gracefully"),
        ENTIREPOOL("EntirePool"),
        ALLINVALIDIDLECONNECTIONS("AllInvalidIdleConnections"),
        ALLIDLECONNECTIONS("AllIdleConnections"),
        ALLGRACEFULLY("AllGracefully"),
        ALLCONNECTIONS("AllConnections");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private FlushStrategy(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }

    public static class ConnectionDefinitionsResources {
        @ResourceDocumentation(value="A custom defined config property.")
        @SubresourceInfo(value="configProperties")
        private List<ConfigProperties> configProperties = new ArrayList<ConfigProperties>();

        @Subresource
        public List<ConfigProperties> configProperties() {
            return this.configProperties;
        }

        public ConfigProperties configProperties(String key) {
            return this.configProperties.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

