/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.undertow;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=undertow/buffer-cache=*")
@ResourceType(value="buffer-cache")
public class BufferCache<T extends BufferCache<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The size of an individual buffer, in bytes.")
    private Integer bufferSize;
    @AttributeDocumentation(value="The numbers of buffers in a region")
    private Integer buffersPerRegion;
    @AttributeDocumentation(value="The maximum number of regions")
    private Integer maxRegions;

    public BufferCache(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="buffer-size")
    public Integer bufferSize() {
        return this.bufferSize;
    }

    public T bufferSize(Integer value) {
        Integer oldValue = this.bufferSize;
        this.bufferSize = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("bufferSize", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="buffers-per-region")
    public Integer buffersPerRegion() {
        return this.buffersPerRegion;
    }

    public T buffersPerRegion(Integer value) {
        Integer oldValue = this.buffersPerRegion;
        this.buffersPerRegion = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("buffersPerRegion", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-regions")
    public Integer maxRegions() {
        return this.maxRegions;
    }

    public T maxRegions(Integer value) {
        Integer oldValue = this.maxRegions;
        this.maxRegions = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("maxRegions", oldValue, value);
        }
        return (T)this;
    }
}

