/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.internal;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.wildfly.swarm.internal.FileSystemLayout;

public class GradleFileSystemLayout
extends FileSystemLayout {
    protected static final String BUILD = "build";
    protected static final String CLASSES = "classes";
    protected static final String MAIN = "main";
    protected static final String RESOURCES = "resources";
    protected static final String SRC = "src";
    protected static final String WEBAPP = "webapp";
    private final Path rootPath;

    GradleFileSystemLayout(String root) {
        this.rootPath = Paths.get(root, new String[0]);
    }

    @Override
    public String determinePackagingType() {
        if (this.resolveSrcWebAppDir().toFile().exists()) {
            return "war";
        }
        return "jar";
    }

    @Override
    public Path resolveBuildClassesDir() {
        return this.rootPath.resolve(BUILD).resolve(CLASSES).resolve(MAIN);
    }

    @Override
    public Path resolveBuildResourcesDir() {
        return this.rootPath.resolve(BUILD).resolve(RESOURCES).resolve(MAIN);
    }

    @Override
    public Path resolveSrcWebAppDir() {
        return this.rootPath.resolve(SRC).resolve(MAIN).resolve(WEBAPP);
    }

    @Override
    public Path getRootPath() {
        return this.rootPath;
    }
}

