/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.fractions;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.wildfly.swarm.fractions.FractionList;
import org.wildfly.swarm.fractions.FractionStability;

public class FractionDescriptor {
    public static final String WILDFLY_SWARM_GROUP_ID = "org.wildfly.swarm";
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String name;
    private final String description;
    private final String tags;
    private final boolean internal;
    private final Set<FractionDescriptor> dependencies = new HashSet<FractionDescriptor>();
    private final FractionStability stability;

    public FractionDescriptor(String groupId, String artifactId, String version, String name, String description, String tags, boolean internal, FractionStability stability) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.name = name;
        this.description = description;
        this.tags = tags;
        this.internal = internal;
        this.stability = stability;
    }

    public FractionDescriptor(String groupId, String artifactId, String version) {
        this(groupId, artifactId, version, null, null, null, false, FractionStability.UNSTABLE);
    }

    public static FractionDescriptor fromGav(FractionList fractionList, String gav) {
        String[] parts = gav.split(":");
        FractionDescriptor desc = null;
        switch (parts.length) {
            case 1: {
                desc = fractionList.getFractionDescriptor(WILDFLY_SWARM_GROUP_ID, parts[0]);
                if (desc != null) break;
                throw new RuntimeException("Fraction not found: " + gav);
            }
            case 2: {
                desc = fractionList.getFractionDescriptor(WILDFLY_SWARM_GROUP_ID, parts[0]);
                if (desc == null) {
                    throw new RuntimeException("Fraction not found: " + gav);
                }
                if (desc.getVersion().equals(parts[1])) break;
                throw new RuntimeException("Version mismatch: requested " + gav + ", found " + desc.av());
            }
            case 3: {
                desc = fractionList.getFractionDescriptor(parts[0], parts[1]);
                if (desc == null) {
                    throw new RuntimeException("Fraction not found: " + gav);
                }
                if (desc.getVersion().equals(parts[2])) break;
                throw new RuntimeException("Version mismatch: requested " + gav + ", found " + desc.gav());
            }
            default: {
                throw new RuntimeException("Invalid fraction spec: " + gav);
            }
        }
        return desc;
    }

    public void addDependency(FractionDescriptor dep) {
        this.dependencies.add(dep);
    }

    @Deprecated
    public String groupId() {
        return this.groupId;
    }

    @Deprecated
    public String artifactId() {
        return this.artifactId;
    }

    @Deprecated
    public String version() {
        return this.version;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTags() {
        return this.tags;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public FractionStability getStability() {
        return this.stability;
    }

    public Set<FractionDescriptor> getDependencies() {
        return Collections.unmodifiableSet(this.dependencies);
    }

    public String av() {
        return this.artifactId + ":" + this.version;
    }

    public String gav() {
        return this.groupId + ":" + this.artifactId + ":" + this.version;
    }

    public String gavOrAv() {
        if (WILDFLY_SWARM_GROUP_ID.equals(this.groupId)) {
            return this.av();
        }
        return this.gav();
    }

    public String toString() {
        return this.gav();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FractionDescriptor other = (FractionDescriptor)obj;
        if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
            return false;
        }
        return !(this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId));
    }
}

