/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.fractions.scanner;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.function.Consumer;
import org.wildfly.swarm.fractions.scanner.Scanner;
import org.wildfly.swarm.spi.meta.FractionDetector;
import org.wildfly.swarm.spi.meta.PathSource;
import org.wildfly.swarm.spi.meta.WebXmlFractionDetector;

public class WebXmlDescriptorScanner
implements Scanner<PathSource> {
    @Override
    public String extension() {
        return "xml";
    }

    @Override
    public void scan(PathSource pathSource, Collection<FractionDetector<PathSource>> detectors, Consumer<File> handleFileAsZip) throws IOException {
        if (pathSource.getSource().getFileName().endsWith("web.xml")) {
            detectors.stream().filter(d -> WebXmlFractionDetector.class.isAssignableFrom(d.getClass())).forEach(d -> d.detect((Object)pathSource));
        }
    }
}

